<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select TABLE_NAME,COLUMN_NAME AS CLM,ORDINAL_POSITION AS SEQNO,COLUMN_NAME AS NAME_JA,
		( CASE UDT_NAME
				WHEN 'int4'    THEN 'NUMBER'
				WHEN 'int8'    THEN 'NUMBER'
				WHEN 'numeric' THEN 'NUMBER'
				WHEN 'text'    THEN 'CLOB'
				ELSE 'VARCHAR2'
				END ) AS CLS_NAME ,
		'' as VIEW_LENGTH ,
		( CASE WHEN CHARACTER_MAXIMUM_LENGTH IS NULL
					THEN NUMERIC_PRECISION
					ELSE CHARACTER_MAXIMUM_LENGTH
				END ) AS USE_LENGTH ,
		COLUMN_DEFAULT AS DATA_DEFAULT,
		( CASE IS_NULLABLE WHEN 'YES' THEN null WHEN 'NO' THEN '1' END) AS NOT_NULL,
		'0' AS KBCLM, '' AS BIKO,'' AS RENDERER,'' AS EDITOR,'' AS DBTYPE,
		'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from information_schema.columns
		<og:where>
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}'" />
			<og:and value = "table_schema = 'public'" />
		</og:where>
		order by TABLE_NAME,ORDINAL_POSITION
	</og:query>
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select A.TABLE_NAME,A.COLUMN_NAME AS CLM,A.COLUMN_ID AS SEQNO,
				COALESCE(B.COMMENTS,A.COLUMN_NAME) AS NAME_JA,
			A.DATA_TYPE AS CLS_NAME,
			'' as VIEW_LENGTH ,
			( CASE	WHEN A.DATA_TYPE = 'BLOB' or A.DATA_TYPE = 'CLOB'
						THEN NULL
					WHEN A.DATA_TYPE = 'NUMBER' AND A.DATA_PRECISION IS NULL
						THEN NULL
					WHEN A.DATA_TYPE = 'VARCHAR2'
						THEN to_char(A.DATA_LENGTH)
					WHEN A.DATA_PRECISION IS NULL
						THEN to_char(A.DATA_LENGTH)
						ELSE (	CASE WHEN A.DATA_SCALE = 0 or A.DATA_SCALE is null
									THEN to_char(A.DATA_PRECISION)
									ELSE A.DATA_PRECISION || ',' || A.DATA_SCALE
							  	END )
					 END ) AS USE_LENGTH ,
			A.DATA_DEFAULT ,
		    (CASE A.NULLABLE WHEN 'N' THEN '1' ELSE '' END) AS NOT_NULL,
			'0' AS KBCLM, '' AS BIKO, '' AS RENDERER,'' AS EDITOR,'' AS DBTYPE,
			'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from USER_TAB_COLUMNS A left outer join USER_COL_COMMENTS B
				on  A.TABLE_NAME  = B.TABLE_NAME
				and A.COLUMN_NAME = B.COLUMN_NAME
		where exists ( select 'X' from USER_TABLES C
						where C.TABLE_NAME = A.TABLE_NAME
					)
		<og:where startKey="and">
			<og:and value = "A.TABLE_NAME like '{@TABLE_NAME}'" />
			<og:and value = "INSTR(A.TABLE_NAME,'$') < 1" />
		</og:where>
		order by A.TABLE_NAME,A.COLUMN_ID
	</og:query>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select
			trim(r.RDB$RELATION_NAME)	AS TABLE_NAME,
			trim(r.RDB$FIELD_NAME)		AS CLM,
			r.RDB$FIELD_POSITION		AS SEQNO,
			trim(r.RDB$FIELD_NAME)		AS NAME_JA,
			CASE f.RDB$FIELD_TYPE
				WHEN   7 THEN
					CASE f.RDB$FIELD_SUB_TYPE
						WHEN 1 THEN 'NUMERIC'
						WHEN 2 THEN 'DECIMAL'
						ELSE        'SMALLINT'
					END
				WHEN   8 THEN
					CASE f.RDB$FIELD_SUB_TYPE
						WHEN 1 THEN 'NUMERIC'
						WHEN 2 THEN 'DECIMAL'
						ELSE        'INTEGER'
					END
				WHEN  16 THEN
					CASE f.RDB$FIELD_SUB_TYPE
						WHEN 1 THEN 'NUMERIC'
						WHEN 2 THEN 'DECIMAL'
						ELSE        'INT64'
					END
				WHEN   9 THEN 'QUAD'
				WHEN  10 THEN 'FLOAT'
				WHEN  11 THEN 'D_FLOAT'
				WHEN  12 THEN 'DATE'
				WHEN  13 THEN 'TIME'
				WHEN  14 THEN 'CHAR'
				WHEN  27 THEN 'DOUBLE'
				WHEN  35 THEN 'TIMESTAMP'
				WHEN  37 THEN 'VARCHAR'
				WHEN  40 THEN 'CSTRING'
				WHEN 261 THEN 'BLOB'
				ELSE 'UNKNOWN'
				END AS CLS_NAME ,
			'' as VIEW_LENGTH ,
	--		f.RDB$FIELD_LENGTH			AS USE_LENGTH ,
			f.RDB$CHARACTER_LENGTH 		AS USE_LENGTH ,
			replace(upper(trim(r.RDB$DEFAULT_SOURCE)),'DEFAULT ','') AS DATA_DEFAULT ,
		    r.RDB$NULL_FLAG			AS NOT_NULL,
			'0' AS KBCLM,'' AS BIKO,'' AS RENDERER,'' AS EDITOR,'' AS DBTYPE,
			'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from RDB$RELATION_FIELDS r LEFT JOIN RDB$FIELDS f
		ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
		where r.RDB$SYSTEM_FLAG = 0
		<og:where startKey="and">
			<og:and value = "r.RDB$RELATION_NAME like '{@TABLE_NAME}'" />
		</og:where>
		order by r.RDB$RELATION_NAME,r.RDB$FIELD_POSITION
	</og:query>
</og:equals>

<!-- MySQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="MYSQL">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select TABLE_NAME,COLUMN_NAME AS CLM,ORDINAL_POSITION AS SEQNO,
				case when length(COLUMN_COMMENT) = 0 then COLUMN_NAME
					 else COLUMN_COMMENT end AS NAME_JA,
				DATA_TYPE AS CLS_NAME,
				'' as VIEW_LENGTH ,
				CONVERT( CASE	WHEN CHARACTER_OCTET_LENGTH is not null
							THEN CHARACTER_OCTET_LENGTH
						WHEN NUMERIC_SCALE = 0 or NUMERIC_SCALE is null
							THEN NUMERIC_PRECISION
						WHEN NUMERIC_SCALE > 0
							THEN NUMERIC_PRECISION || ',' || NUMERIC_SCALE
						ELSE
							NUMERIC_PRECISION
					END USING utf8 ) AS USE_LENGTH ,
				COLUMN_DEFAULT AS DATA_DEFAULT,
		    (CASE IS_NULLABLE WHEN 'NO' THEN '1' ELSE '' END) AS NOT_NULL,
			'0' AS KBCLM, COLUMN_COMMENT AS BIKO, '' AS RENDERER,'' AS EDITOR,'' AS DBTYPE,
			'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from INFORMATION_SCHEMA.COLUMNS
		where table_schema=database()
		<og:where startKey="and">
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}'" />
		</og:where>
		order by TABLE_NAME,ORDINAL_POSITION
	</og:query>

	<!-- とりあえずは、TPM 専用の処理とします。 -->
	<og:equals val1="{@SYSTEM_ID}" val2="TPM">
		<og:tableFilter classId="BIKOSET" />
	</og:equals>
</og:equals>

<!-- DERBY 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="DERBY">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select B.TABLENAME as TABLE_NAME,A.COLUMNNAME AS CLM,A.COLUMNNUMBER AS SEQNO,
				A.COLUMNNAME AS NAME_JA,
				A.COLUMNDATATYPE AS CLS_NAME,
				'' as VIEW_LENGTH ,
				0 AS USE_LENGTH ,
				A.COLUMNDEFAULT AS DATA_DEFAULT,
				(CASE WHEN INSTR( A.COLUMNDATATYPE , 'NOT NULL' ) = 0 THEN '' ELSE '1' END) AS NOT_NULL,
				'0' AS KBCLM, '' AS BIKO, '' AS RENDERER,'' AS EDITOR,'' AS DBTYPE,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from SYS.SYSCOLUMNS A left outer join SYS.SYSTABLES B
			on A.REFERENCEID = B.TABLEID
			left outer join SYS.SYSSCHEMAS C
				on B.SCHEMAID = C.SCHEMAID
		where B.TABLETYPE = 'T'
		<og:where startKey="and">
			<og:and value = "B.TABLENAME like '{@TABLE_NAME}'" />
		</og:where>
		order by B.TABLENAME,A.COLUMNNUMBER
	</og:query>
</og:equals>

<!-- POSTGRES,ORACLE,FIREBIRD,MYSQL 以外の場合 -->
<og:equals val1="POSTGRES,ORACLE,FIREBIRD,MYSQL" val2="{@DBF.NAME @DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2020}" val1="{@DBF.NAME @DBID}" />
</og:equals>

<!-- NAME_JA にリソースを適用します。 -->
<og:equals val1="{@USE_RESOURCE}" val2="true">
	<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},CLM,NAME_JA" />
</og:equals>
