<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" >
<!--
	<script>
		window.onload = function() {
			// ダブルクリックでズームリセット
			$('#chart1').dblclick(function(){
				window.chart_chart1.resetZoom();
			});
		}
	</script>
-->
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query maxRowCount="0">
--	select substr(DYSET,1,8) as CDATE ,
	select SYSTEM_ID,USERID,substr(DYSET,1,8) as CDATE ,
			USED_TIME,CNT_ACCESS,CNT_READ,TM_TOTAL_QUERY
--			abs(MOD(DBMS_RANDOM.RANDOM(),1000))  as NUM ,
--			abs(MOD(DBMS_RANDOM.RANDOM(),1000))  as NUM2
	from GE15
	order by DYSET,SYSTEM_ID,USERID
</og:query>

<og:tableFilter classId="SKIPROW" selectedAll="true"
	keys="GROUP_KEY,DT_SKIP,VAL_CLMS"
	vals='"SYSTEM_ID,USERID",36,"USED_TIME,CNT_ACCESS,CNT_READ,TM_TOTAL_QUERY"'
/>

<og:text>{@DB.COUNT}</og:text>

<!-- idとonClickでズームリセットを実装。チャートのオブジェクト名はchart_[id名] -->
<og:jsChart
	id				= "chart1"
	chartType		= "{@chartType}"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	labelColumn		= "CDATE"
	title			= "{@title}"
	useDragZoom		= "true"
	debug			= "{@debug}"
>

	<c:forTokens items="USED_TIME,CNT_ACCESS,CNT_READ,TM_TOTAL_QUERY" delims="," var="C_KEY" >
		<og:jsChartData
			chartColumn	= "{@C_KEY}"
			ylabel		= "{@ylabel}"
			type		= "{@type}"
			label		= "{@C_KEY}"
		/>
	</c:forTokens>
</og:jsChart>

<pre>
DragZoom処理を使用 します。
これは、chartjs-plugin-zoom.js を使用します。
右クリックで範囲指定で、zoom処理、CTRLボタンを押しながら、右クリックで移動(pan)します。
ダブルクリックで元の状態に戻します。
useDragZoom と同時指定した場合は、useZoom が優先されます。
</pre>

<ul>
  <li>zoom:{drag:{enabled:true,borderColor:'rgb(54,162,235)',borderWidth:1,backgroundColor:'rgba(54,162,235,0.3)'},},</li>
  <li>pan:{mode:'xy',enabled:true,modifierKey: 'ctrl',},</li>
  <li>canvasをクリックでzoomリセット	</li>
</ul>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
