<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query command="NEW">
	SELECT	 ENAME as LABELS
			,SAL   as VAL1
			,COMM  as VAL2
			,JOB
	FROM BONUS
	order by 1
</og:query>

<og:jsChart
	chartType			= "{@chartType}"
	height				= "{@height}"
	width				= "{@width}"
	minLabelWidth		= "{@minLabelWidth}"

	labelColumn			= "LABELS"
	plugins				= "{@plugins}"

	title				= "{@chartTitle}"
	titlePosition		= "{@titlePosition}"
	legendDisplay		= "{@legendDisplay}"
	legendPosition		= "{@legendPosition}"
	usePointStyle		= "{@usePointStyle}"

	indexAxis			= "{@indexAxis}"
	barWidthPer			= "{@barWidthPer}"
	animation			= "{@animation}"

	optOptions			= "{@optOptions}"
	optPlugins			= "{@optPlugins}"
	optTooltip			= "{@optTooltip}"
	optLegend			= "{@optLegend}"

	markValues			= "{@markValues}"
	markColors			= "{@markColors}"
	markLbls			= "{@markLbls}"
	markAdjust			= "{@markAdjust}"

	xmarkValues			= "{@xmarkValues}"
	xmarkColors			= "{@xmarkColors}"
	markWidth			= "{@markWidth}"
	markDash			= "{@markDash}"
	markFontSize		= "{@markFontSize}"

	useZoom				= "{@useZoom}"
	useDragZoom			= "{@useDragZoom}"
	useZeroDataOmit		= "{@useZeroDataOmit}"
	useRenderer			= "{@useRenderer}"
	valueQuot			= "{@valueQuot}"
	sortColumn			= "{@sortColumn}"
	varColumns			= "{@varColumns}"

	xscaleType			= "{@xscaleType}"
	xlabel				= "{@xlabel}"
	xposition			= "{@xposition}"

	xscaleCallback		= "function(val, index){return this.getLabelForValue(val) + ' さん';}"

	xbeginAtZero		= "{@xbeginAtZero}"
	xmax				= "{@xmax}"
	xmin				= "{@xmin}"
	xstepSize			= "{@xstepSize}"

	optAxis				= "{@optAxis}"
	optTicks			= "{@optTicks}"
	optTitle			= "{@optTitle}"
	optGrid				= "{@optGrid}"

	timeUnit			= "{@timeUnit}"
	timeUnitStepSize	= "{@timeUnitStepSize}"
	timeParser			= "{@timeParser}"
	timeLblFormat		= "{@timeLblFormat}"
	tooltipFormat		= "{@tooltipFormat}"
	debug				= "{@debug}"
>
	<og:jsChartData
		chartColumn			= "VAL1"
		label				= "{@label}"
		type				= "{@type}"
		spanGaps			= "{@spanGaps}"

		useAxis				= "{@useAxis}"
		fill				= "{@fill}"
		tension				= "{@tension}"
		hidden				= "{@hidden}"

		borderColor			= "{@borderColor}"
		borderWidth			= "{@borderWidth}"
		borderDash			= "{@borderDash}"
		backgroundColor		= "{@backgroundColor}"

		pointStyle			= "{@pointStyle}"
		pointRadius			= "{@pointRadius}"
		showLine			= "{@showLine}"
		pointBGColor		= "{@pointBGColor}"

		position			= "{@position}"
		scaleType			= "{@scaleType}"
		categoryList		= "{@categoryList}"
		ylabel				= "{@ylabel}"
		beginAtZero			= "{@beginAtZero}"
		grace				= "{@grace}"
		max					= "{@max}"
		min					= "{@min}"
		fontColor			= "{@fontColor}"
		stepSize			= "{@stepSize}"
		gridColor			= "{@gridColor}"
		scaleCallback		= "function(val, index){return val.toLocaleString() + '円';}"

		optDataset			= "{@optDataset}"
		optAxis				= "{@yoptAxis}"
		optTicks			= "{@yoptTicks}"
		optTitle			= "{@yoptTitle}"
		optGrid				= "{@yoptGrid}"
		debug				= "{@debug}"
	/>
</og:jsChart>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
