<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" >
	<script src="{@SYS.JSP}/GF7312/sample5_script.js?v={@SYS.START_TIME}" ><!-- --></script>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

左のチャートをクリックする事で、右のチャートのデータをajax経由で持ってきて更新します。

<!-- onClick のURLの引数チェック -->
<og:text>
  <table>
	<tr><td>chartTitle</td><td>=</td><td>{@chartTitle}</td></tr>
	<tr><td>markValues</td><td>=</td><td>{@markValues}</td></tr>
	<tr><td>sample</td><td>=</td><td>{@sample}</td></tr>
  </table>
</og:text>

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query>
	SELECT	 DEPTNO
			,DNAME as LABELS
			,(select sum(SAL) from emp where emp.deptno = dept.deptno) as SAL
	FROM DEPT
	order by 1
</og:query>

<!--
	<script>
		// Chart.plugins.register で、登録すると、すべてのチャートに適用されます。
		Chart.plugins.register( chartLabelPin );
	</script>
-->

<div style="float:left;">
	<og:jsChart
		id				= "MainChart"
		chartType		= "pie"
		height			= "{@height}"
		width			= "{@width}"
		minLabelWidth	= "{@minLabelWidth}"
		labelColumn		= "LABELS"
		title			= "{@chartTitle}"
		plugins			= "chartLabelPlugin"
		onClick			= "updatechart(event,obj,'SubChart')"
		debug			= "{@debug}"
	>
		<og:jsChartData
			chartColumn		= "SAL"
		/>
	</og:jsChart>
</div>

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query scope="request" tableId="tbl2">
	SELECT	 JOB as LABELS
			,sum(SAL) as SAL , max(EMPNO) as EMPNO , max(ENAME) as ENAME
	FROM emp
	group by job
	order by 1
</og:query>

<og:value command="SET" key="JSONDATA">
{"command":"NEW","chartTitle":"$LBL","markValues":"$VAL","debug":"{@debug}","sample":"sample5"}
</og:value>

<og:jsChart
	id				= "SubChart"
	chartType		= "bar"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	labelColumn		= "LABELS"
	legendDisplay	= "false"
	optOptions		= ""
	onClick			= "chartLink(event,obj,'{@GUI.KEY}','index.jsp',{@JSONDATA});"
	plugins			= "chartLabelPlugin"
	scope			= "request"
	tableId			= "tbl2"
	debug			= "{@debug}"
>
	<og:jsChartData
		chartColumn		= "SAL"
		max				= "10000"
		min				= "{@min}"
	/>
	<og:jsChartData
		chartColumn		= "EMPNO"
	/>
</og:jsChart>

<br/><pre>
onClick属性を使用する際には、複数のﾂｰﾙﾁｯﾌﾟを設定した場合は正常に動作しません。
※optOptions属性のinteraction項目に mode:'index' を指定した場合等
</pre>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
