/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractDBType;

/**
 * パスワード情報など、重要な情報のハッシュコード(MD5)を扱う為の、カラム属性を定義します。
 *
 * パスワード情報など、重要な情報のハッシュコードに、MD5 があります。このクラスは、
 * MessageDigestにより、MD5 でハッシュした文字を作成します。
 * 値としては、標準の X と同じ半角文字列「 c &lt; 0x20 || c &gt; 0x7e 以外」でのみ
 * 処理することが出来ます。
 *
 * タイプチェックとして、以下の条件を判定します。
 * ・文字列長は、Byte換算での文字数との比較
 * ・半角文字列チェック「 c &lt; 0x20 || c &gt; 0x7e 以外」エラー
 * ・文字パラメータの 正規表現チェック
 * ・クロスサイトスクリプティングチェック
 *
 * @og.group データ属性
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class DBType_MD5 extends AbstractDBType {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "8.1.2.0 (2022/03/10)" ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public DBType_MD5() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * String引数の文字列を＋１した文字列を返します。
	 * ※ このクラスでは実装されていません。
	 *
	 * @param	value	String引数の文字列
	 * @throws UnsupportedOperationException このクラスを実行すると、必ず発生します。
	 *
	 * @return  String引数の文字列を＋１した文字列
	 */
	@Override
	public String valueAdd( final String value ) {
		final String errMsg = "このメソッドは、このクラスからは使用できません。";
		throw new UnsupportedOperationException( errMsg );
	}

	/**
	 * MessageDigestにより、MD5 でハッシュした文字を返します。
	 *
	 * MD5で、１５Byteのバイトに変換されますが、ここでは、マイナス時には,
	 * 符号を反転させて、１６進数で文字列に変換しています。
	 * よって、このメソッドで変換した文字でのみ突き合わせて正しいかどうかを
	 * 判断してください。
	 *
	 * @og.rev 3.3.3.0 (2003/07/09) 前後のスペースを取り除いておく。
	 * @og.rev 3.3.3.1 (2003/07/18) 後ろスペースを取り除く。(StringUtil#rTrim)
	 * @og.rev 5.2.2.0 (2010/11/01) util.StringUtil から security.HybsCryptography へ移動
	 * @og.rev 8.1.2.0 (2022/03/10) getMD5 ﾒｿｯﾄﾞを getHash ﾒｿｯﾄﾞに変更
	 *
	 * @param	value	(一般に編集データとして登録されたデータ)
	 *
	 * @return  修正後の文字列(一般にデータベースに登録するデータ)
	 */
	@Override
	public String valueSet( final String value ) {
//		return HybsCryptography.getMD5( StringUtil.rTrim( value ) );	// 5.2.2.0 (2010/11/01) クラス変更 8.1.2.0 (2022/03/10) Modify
		return HybsCryptography.getHash( "MD5", StringUtil.rTrim( value ) );
	}
}
