/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

/**
 * TableFilter_SEQUENCE_ORACLE は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。
 *
 * ※ 他のデータベースと同じ形で扱いたいため、用意したクラスですが、内容は、TableFilter_SEQUENCE と同じです。
 *
 * ここでは、シーケンス一覧の検索結果より、GF09 のシーケンス定義テーブルから
 * 必要な情報を取得し、シーケンス作成スクリプトを作成します。
 *
 * この処理を実行するには、DBTableModelのカラムとして、
 *  SEQNAME,INCREBY,STARTVAL,MINVAL,MAXVAL,FGCYCLE,SUCACHE
 * が必要です。
 *
 * ※Firebirdに対して生成されるスクリプトでは、INCREBY,STARTVAL,MINVAL,MAXVAL,FGCYCLE,SUCACHEは無視されます。
 *
 * @og.rev 6.5.0.0 (2016/09/30) 新規作成
 *
 * @version  6.5.0.0  2016/09/13
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.8,
 */
public class TableFilter_SEQUENCE_ORACLE extends TableFilter_SEQUENCE {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.9.7.0 (2018/05/14)" ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.9.7.0 (2018/05/14) PMD Each class should declare at least one constructor
	 */
	public TableFilter_SEQUENCE_ORACLE() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
}
