/********************************************************************************************/
/* javaDBに対して、関数を拡張します。														*/
/*																							*/
/* 【概要】 																				*/
/*	 javaDB に、特殊系の関数を登録します。													*/
/*	 これは、JavaDBが、数値⇔文字列の自動変換が出来ないための対応が、主です。				*/
/*																							*/
/* 【方法】																					*/
/*	 １．Java関数のソースは、org.opengion.fukurou.db.Functions に定義します。				*/
/*	 ２．apps/endorsedX.0 フォルダに、ogJavaFunction.jar ファイルをコピーします。			*/
/*	 ３．JavaDB から、上記クラスが見えるようにします。										*/
/*		 具体的には、apps\jdk9u01\db\bin\startNetworkServer.bat (JavaDB 起動スクリプト)に	*/
/*		 set CLASSPATH=%OG_CLASSPATH%; を追記します。										*/
/*		 OG_CLASSPATH は、Tomcat起動用に、uap\bin\const.bat に定義済みです。				*/
/*		 これで、apps/endorsedX.0 フォルダが見える環境になります。							*/
/*	 ４．JavaDBに対して、FUNCTION を定義します。											*/
/********************************************************************************************/

/********************************************************************************************/
/* 文字列を連結します。																		*/
/*																							*/
/* 文字列が、NULL の場合は、ゼロ文字列として扱います。										*/
/* 引数がどちらも NULL の場合は、ゼロ文字列が戻されます。									*/
/* これは、ORACLEとの互換性を考慮した関数です。												*/
/* ORACLE は、NULLとゼロ文字列を同等にNULLとして扱うため、									*/
/* COALESCE( VAL1,'' ) で、VAL1がNULLか、ゼロ文字列の場合は、NULLが返されます。				*/
/* NULLを含むWHERE条件で、WHERE COALESCE( VAL1,'' ) = COALESCE( VAL2,'' )					*/
/* としても、一致しないため、WHERE COALESCE( VAL1,'x' ) = COALESCE( VAL2,'x' )				*/
/* とする必要がありますが、VAL1が、実際の 'x' で、VAL2がNULLの場合もマッチします。			*/
/* CONCAT関数を作成して、ORACLEと同じSQL文での比較ができるようにしておきます。				*/
/* 8.0.0.0 (2021/09/30)																		*/
/********************************************************************************************/
DROP FUNCTION CONCAT;

CREATE FUNCTION CONCAT ( VAL1 VARCHAR(1000) , VAL2 VARCHAR(1000) )
RETURNS VARCHAR(2000)
AS
BEGIN
	RETURN	COALESCE(VAL1,'') || COALESCE(VAL2,'');
END;
