<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" >
	<!-- 8.4.1.1 (2023/02/24) headタグ内に移動 -->
	<style>
		table.layout , .layout td, .layout th {
			border: 1px black solid;
			border-collapse: collapse;
		}
	</style>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6020"
	title	= "表示・編種別"
	date	= "2014/11/25"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<table class="layout" >
<tr>
	<og:column name="TEXT"		renderer="LABEL"	lbl="EDITOR.TEXT"								writable="false" />
	<og:column name="NUMBER"	renderer="NUMBER"	lbl="RENDERER.NUMBER"							writable="false" />
	<og:column name="PASSWD"	renderer="PASSWD"	lbl="RENDERER.PASSWD"							writable="false" />
</tr>
<tr>
	<og:column name="MENU"		renderer="MENU"		lbl="RENDERER.MENU"								writable="false" codeName="LANG" />
	<og:column name="DBMENU"	renderer="DBLABEL"	lbl="RENDERER.DBLABEL"							writable="false"
		param="select EMPNO , ENAME , DEPTNO from EMP order by DEPTNO,EMPNO"
	/>
	<og:column name="DATALIST1"	renderer="LABEL"	lbl="{@LBL.EDITOR.DATALIST}1"					writable="false" />
	<og:column name="DATALIST2"	renderer="LABEL"	lbl="{@LBL.EDITOR.DATALIST}2"					writable="false" />
</tr>
<tr>
	<og:column name="NUMMENU"	renderer="NUMBER"	lbl="EDITOR.NUMMENU"							writable="false" />
	<og:column name="YMDMENU"	renderer="YMD"		lbl="EDITOR.YMDMENU"							writable="false" />
	<og:column name="HMMENU"	renderer="HM"		lbl="EDITOR.HMMENU"								writable="false" />
	<og:column name="KVMENU"	renderer="LABEL"	lbl="EDITOR.KVMENU"								writable="false" />
</tr>
<tr>
	<og:column name="TEXTAREA"	renderer="TEXTAREA"	lbl="RENDERER.TEXTAREA"							writable="false" />
	<!-- xssCheck は、BODY にのみ有効で、value の自動設定も止めるため、useRequestValue="false" も必要 -->
	<og:column name="HTMLAREA"	renderer="HTMLPRE"	lbl="EDITOR.HTMLAREA"							writable="false" useRequestValue="false" xssCheck="false" >{@HTMLAREA}</og:column>
	<og:column name="AUTOAREA"	renderer="AUTOAREA"	lbl="RENDERER.AUTOAREA"							writable="false" />
</tr>
<tr>
	<og:column name="HTML"		renderer="HTML"		lbl="RENDERER.HTML"								writable="false" />
	<og:column name="HM"		renderer="HM"		lbl="RENDERER.HM"								writable="false" />
	<og:column name="YM"		renderer="YM"		lbl="RENDERER.YM"								writable="false" />
	<og:column name="WRITABLE"	renderer="WRITABLE"	lbl="RENDERER.WRITABLE"							writable="false" />
</tr>
<tr>
	<og:column name="YMD"		renderer="YMD"		lbl="RENDERER.YMD"								writable="false" />
	<og:column name="YMD2"		renderer="YMD"		lbl="EDITOR.YMD2"								writable="false" />
	<og:column name="YMDH"		renderer="YMDH"		lbl="RENDERER.YMDH"								writable="false" />
	<og:column name="COLUMN"	renderer="COLUMN"	lbl="RENDERER.COLUMN"	value="LANG"			writable="false" />
</tr>
<tr>
	<og:column name="RADIO"		renderer="RADIO"	lbl="RENDERER.RADIO"							writable="false" codeName="LANG" />
	<og:column name="CHBOX"		renderer="CHBOX"	lbl="RENDERER.CHBOX"							writable="false"				 />
	<!-- {@SUMR.XXX} は、マルチバリューに対して、数値の場合は加算し、文字列の場合は、カンマ記号で連結します。 -->
	<og:column name="CHBOX2"	renderer="CHBOX2"	lbl="EDITOR.CHBOX2"		value="{@SUMR.CHBOX2}"	writable="false" codeName="LANG" />
</tr>
<tr>
	<og:column name="CRYPT"		renderer="CRYPT"	lbl="RENDERER.CRYPT"							writable="false" />
	<og:column name="UPLOAD"	renderer="LABEL"	lbl="EDITOR.UPLOAD"								writable="false" />
</tr>
<tr>
	<og:column name="DBRADIO"	renderer="DBLABEL"	lbl="EDITOR.DBRADIO"							writable="false"
		param="select CLM,SNAME from GEA08 where system_id='**' and lang='ja' and clm like 'LANG.%'"
	/>
	<og:column name="HIDDEN"	renderer="LABEL"		lbl="EDITOR.HIDDEN"							writable="false" />
	<og:column name="DECIMAL"	renderer="DECIMAL"		lbl="RENDERER.DECIMAL"						writable="false" />
</tr>
<tr>
	<og:column name="COLOR"		renderer="COLOR"		lbl="RENDERER.COLOR"						writable="false" />
	<og:column name="QUERY"		renderer="QUERY"		lbl="RENDERER.QUERY"						writable="false"
		param="select ENAME , DEPTNO from EMP order by DEPTNO,EMPNO"
	/>
</tr>
<tr>
	<og:column name="BIT_BOX"	renderer="BITBOX"		lbl="BIT_BOX"	colspan="7"	value="{@SUMR.BIT_BOX}"	writable="false" />
</tr>
</table>

<hr />
<!-- テスト的に、以下のデータを作成します。 -->
<!-- 社員番号(EMPNO) が、偶数の場合、SAL をマイナスします。 -->
<!-- 部門番号(DEPTNO) が、10:￥ , 20:＄ , 30:€ の通貨を与えます。 -->
<!-- SALがｵﾘｼﾞﾅﾙ、SAL1,SAL2,SAL3,SAL4 がテストカラム -->
<og:query command="NEW">
	SELECT	  A.EMPNO
			, A.ENAME
			, A.MGR
			, to_char( to_date(A.HIREDATE) , 'YYYYMMDD' ) as HIREDATE
			, SAL
			, case when MOD(A.EMPNO,2)=0 then -A.SAL else A.SAL end as SAL1
			, case when MOD(A.EMPNO,2)=0 then -A.SAL else A.SAL end as SAL2
			, case when MOD(A.EMPNO,2)=0 then -A.SAL else A.SAL end
						|| ':' || CASE A.DEPTNO WHEN 10 THEN '￥' WHEN 20 THEN '＄' WHEN 30 THEN '€' ELSE '¤' END as SAL3
			, case when MOD(A.EMPNO,2)=0 then -A.SAL else A.SAL end as SAL4
			, A.DEPTNO
	FROM EMP A
	order by A.EMPNO
</og:query>

<og:columnEditor column="HIREDATE"	renderer="DATE"		/>
<og:columnEditor column="SAL1"		renderer="NUMBER"	dbType="S9" />	<!-- 単純に、数値型として表示 -->
<og:columnEditor column="SAL2"		renderer="MONEY"	dbType="S9" />	<!-- マネー型 標準 -->
<og:columnEditor column="SAL3"		renderer="MONEY"	dbType="S9" />	<!-- マネー型に、通貨の混在指定 -->
<og:columnEditor column="SAL4"		renderer="DECIMAL"	dbType="S9" />	<!-- 10進小数対応。数値型との比較用 -->

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="NEW">
	<og:columnMarker column="SAL3" onMark="[DEPTNO]" markList="10" useFormatDeco="true">	<!-- 修飾なし -->
		[$SAL3]
	</og:columnMarker>
	<og:columnMarker column="SAL3" onMark="[DEPTNO]" markList="20" useFormatDeco="true">	<!-- 色付け ＋ 2桁指定 -->
		<span style="background-color:#ccff00">[$SAL3 2]</span>
	</og:columnMarker>
	<og:columnMarker column="SAL3" onMark="[DEPTNO]" markList="30" useFormatDeco="true">	<!-- 斜体文字 ＋ 4桁指定 -->
		<i>[$SAL3 4]</i>
	</og:columnMarker>
	<og:columnMarker column="HIREDATE" useFormatDeco="true">								<!-- 日付型のﾌｫｰﾏｯﾄ指定 -->
		<span style="background-color:#ccff00">[$HIREDATE MM/dd(EEE)]</span>
	</og:columnMarker>
	<og:columnMarker column="SAL4" onMark="[DEPTNO]" markList="20" useFormatDeco="true">	<!-- 10進小数のﾌｫｰﾏｯﾄ指定 -->
		<span style="background-color:#ffcc00">[$SAL4 ￥#,###.00;￥▲#]</span>
	</og:columnMarker>
</og:viewMarker>

<!-- formﾀｸﾞでﾘｸｴｽﾄﾌｨｰﾙﾄﾞを囲います｡ -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="SAL1,SAL2,SAL3,SAL4" />
		<og:submit  action="MODIFY"  noWritable="EMPNO,SAL1,SAL2,SAL3,SAL4"  />
		<og:submit  action="DELETE"  columnWritable="null" />
	<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command      = "{@command}"
		noDisplay    = "{@extDisplay}"
		checked      = "{@checked}"
		startNo      = "{@startNo}"
		pageSize     = "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
