<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:ｴﾝｼﾞﾝｻﾝﾌﾟﾙ"
	pgid	= "GF6240"
	title	= "IOr連携"
	date	= "2021/11/30"
	author	= "LEE.M"
	text	= "IOr検索／登録"
	version	= "001"
/>

<!-- ﾜｰﾆﾝｸﾞﾒｯｾｰｼﾞです。ここでは、登録完了のﾒｯｾｰｼﾞを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力ﾁｪｯｸ -->
<og:columnCheck command="{@command}" columns="*" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- ﾃﾞｰﾀ取得を要求します。 -->
<og:iorQuery
	url				= "{@urlSel}"
	proxyHost		= "{@proxyHost}"
	proxyPort		= "{@proxyPort}"
	authURL			= "{@authURL}"
	authUserPass	= "{@userId}:{@password}"
	appliName		= "{@report_name}"
	saveFile		= "{@SAVE_FILE}"
	loadFile		= "{@LOAD_FILE}"
	debug			= "{@debug}"
	>
	<!-- 取得項目 -->
	<og:iorParam key="select_cols"	value="{@SEL}" />

	<!-- 条件(LIKE) -->
	<og:iorParam key="where_lk"	value="{'TANTO':'{@TANTO1}','TANI':'{@TANI}','NMSYA':'{@NMSYA}'}" />
	<!-- 条件(NOT LIKE) -->
	<og:iorParam key="where_notlk"	value="{'TANTO':'{@TANTO2}'}" />

	<!-- 条件(IN) -->
	<og:iorParam key="where_in"	value="{'TANTO':'{@TANTO3}'}" />
	<!-- 条件(NOT IN) -->
	<og:iorParam key="where_notin"	value="{'TANTO':'{@TANTO4}'}" />

	<!-- 条件(≧) -->
	<og:iorParam key="where_ge"	value="{'DYNYSY':'{@DYNYSY1}'}" />
	<!-- 条件(≦) -->
	<og:iorParam key="where_le"	value="{'DYNYSY':'{@DYNYSY2}'}" />
	<!-- 条件(＞) -->
	<og:iorParam key="where_gt"	value="{'DYNYSY':'{@DYNYSY3}'}" />
	<!-- 条件(＜) -->
	<og:iorParam key="where_lt"	value="{'DYNYSY':'{@DYNYSY4}'}" />

	<!-- 集計項目 -->
	<og:iorParam key="group_by"	value="{@GRP}" />
	<!-- 表示順 -->
	<og:iorParam key="order_by"	value="{@ORD}" />
</og:iorQuery>

<!-- formﾀｸﾞでﾘｸｴｽﾄﾌｨｰﾙﾄﾞを囲います。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。 -->

	<og:writeCheck caseKey="{@process}" caseVal="selupd" >
		<og:submit action="COPY"   columnWritable="*" />
		<og:submit action="MODIFY" columnWritable="SUNYSY,RIYU,TANTO,NMSYA" />
		<og:submit action="DELETE" columnWritable="" />
		<!-- (ﾃﾞﾊﾞｯｸ用)実行結果をﾌｧｲﾙに保存した場合は、ﾌｧｲﾙにﾘﾝｸを付けます。 -->
		<og:link lbl="{@SAVE_FILE}" href="{@SYS.JSP}/fileDownload" caseNN="{@SAVE_FILE}" caseNull="{@LOAD_FILE}"
				keys="file,name,useLocal" vals="{@SYS.FILE_URL}/{@SAVE_FILE},{@SAVE_FILE},true" />
	<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		checked			= "{@checked}"
		startNo			= "{@startNo}"
		pageSize		= "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
