<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6410"
	title	= "動的ﾌﾟﾙﾀﾞｳﾝ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select CLM,LANG,KBSAKU,SYSTEM_ID,
				NAME_JA,LABEL_NAME,COMMENTS,FGJ,DYUPD DYSTART3, DYUPD DYTO
		from GF41
	<og:where>
		<og:and value = "FGJ		in	('0','1')"			/>
		<og:and value = "SYSTEM_ID	=	'{@SYSTEM_ID}'"		/>
		<og:and value = "LANG		=	'{@LANG}'"			/>
		<og:and value = "CLM		like '{@CLM}'"			/>
		<og:and value = "LABEL_NAME	like '{@LABEL_NAME}'"	/>
		<og:and value = "KBSAKU		=	'{@KBSAKU}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor column="LANG" must="true" />
<og:columnEditor column="CLM"  must="true" size="20" />
<!-- 動的カラムの設定例 -->
<!-- {@xxx}と書くと同じ行のxxxのカラムの値が取得される。 -->
<!-- 読み込み後に1度changeイベントが発行される。 -->
<!-- eventColumn では、eventColumnMaker.jsp で、param のSQL文が必要です。 -->
<og:columnEditor columns="KBSAKU" eventColumn="LANG" addNoValue="false" param="SELECT * FROM DUAL" />

<og:columnEditor columns="COMMENTS" eventColumn="KBSAKU" addNoValue="false" renderer="DBMENU" editor="DBMENU"
	param="SELECT EMPNO,ENAME from EMP WHERE DEPTNO like '%{@KBSAKU}' || '0'" />
<og:columnEditor columns="NAME_JA" eventColumn="CLM,LANG" addNoValue="false"
	param="SELECT NAME_JA as VALUE from GF41 where CLM='{@CLM}' and LANG='{@LANG}'" />
<og:columnEditor columns="LABEL_NAME" eventColumn="CLM,LANG" addNoValue="false"
	param="SELECT LABEL_NAME as LABEL_NAME from GF41 where CLM='{@CLM}' and LANG='{@LANG}'" />

<og:columnEditor columns="DYTO" eventColumn="DYSTART3" useDateFeed="false" useRealTimeCheck="false"
	param="SELECT SUBSTRB('$1',1,8) as YMD FROM DUAL" />

<!-- ２重押し防止 oneClick()関数は、useAjaxSubmit='true' 使用時には使えません。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="COPY"    noWritable="null"  />
	<og:submit  action="MODIFY"  noWritable="CLM" />
	<og:submit  action="DELETE"  columnWritable="null" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable"
	command      = "{@command}"
	noDisplay    = "FGJ"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
