<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6470"
	title	= "DBコピー "
	date	= "2018/01/17"
	author	= "Kazuhiko.Hasegawa"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" dbid="{@FROM_DBID}">
		select {@names}
		from    {@table}
	<og:where>
		<og:and value = "{@where}" quotCheck="false"	/>
	</og:where>
	<og:appear startKey="order by" value="{@orderBy}" defaultVal="SYSTEM_ID,CLM,LANG" />
</og:query>

<form method="POST" action="forward.jsp" target="RESULT">
	<!-- 登録、取消、リセットボタンと、EXCEL(CSV)変更リンクを作成します。 -->
	<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
	<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit  action="ENTRY" />
		<og:submit  action="RESET" />
	<br />
	</og:writeCheck>

	<!-- 入力画面を表示します。 -->
	<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		noWritable		= "{@noWritable}"
		columnWritable	= "{@columnWritable}"
		checked			= "{@checked}"
		startNo			= "{@startNo}"
		pageSize		= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
