<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query>
	SELECT USED_TIME,CNT_ACCESS,DYLOGIN	FROM GE15
	where DYLOGIN &gt;= '{@DATE.YMD M-1}'
	order by DYLOGIN
</og:query>

<!--
	※ 日付フォーマットを指定して、useRenderer="true" で解析させる場合
	<og:columnEditor column="DYLOGIN" renderer="DATE" param="yyyy-MM-dd HH:mm:ss" />

	og:jsChart の属性
		useRenderer = "true"

	※ 日付フォーマットを指定せずに、timeParser で、ﾌｫｰﾏｯﾄを指定する場合
	og:jsChart の属性
		timeParser = "yyyyMMddHHmmss"
-->

<!--
	※ xscaleType="linear" の場合、xmin、xmax が必要 ？
	<og:value command="SETTBL" action="ALL_MAX_MIN" />

	og:jsChart の属性
		xmin = "{@MIN.DYLOGIN}"
		xmax = "{@MAX.DYLOGIN}"
-->

<og:jsChart
	chartType		= "{@chartType}"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	xscaleType		= "time"
	labelColumn		= "DYLOGIN"
	timeParser		= "yyyyMMddHHmmss"
	title			= "{@chartTitle}"
	debug			= "{@debug}"
>
	<og:jsChartData
		chartColumn		= "USED_TIME"
		label			= "USED_TIME"
	/>
</og:jsChart>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
