<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9340"
	title	= "標準(Java)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM"
>
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ
		from GF41
		where FGJ         in  ('0','1')
		and   SYSTEM_ID   = '{@SYSTEM_ID}'
		and   LANG        = '{@LANG}'
		and   CLM         = '{@CLM}'
</og:query>

<!-- {@DB.COUNT} で、query実行結果の件数を取得できます。-->
<!-- 下記の例では、件数が 0 件ならば、追加処理を行うメッセージを出しています。-->
<og:equals val1="{@DB.COUNT}" val2="0" >
	<og:message lbl="MSG0044" comment="追加処理を行います。" /><br />
</og:equals>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 -->
<!-- 以下は、must属性を true にして、初期値（設定されていない場合）検索条件の値をセットしています。 -->
<og:columnEditor column="SYSTEM_ID" must="true" defaultVal="{@SYSTEM_ID}" />
<og:columnEditor column="LANG"      must="true" defaultVal="{@LANG}"      />
<og:columnEditor column="CLM"       must="true" defaultVal="{@CLM}"       />

<!-- ２重押し防止 oneClick()関数は、useAjaxSubmit='true' 使用時には使えません。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消ボタンを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="ENTRY" />
	<og:submit  action="RESET" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<!-- viewFormType="HTMLEntry" で、エントリー形式の画面を作成します。 -->
<og:view
	viewFormType = "HTMLEntry"
	command    = "{@command}"
	noDisplay  = "FGJ"
	noWritable = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
>
<!-- HTMLEntry で使用される画面レイアウトです。 -->
<!-- [カラム名]で、ラベルと値のセットを、表示します。tdタグ ２個分です。 -->
<!-- [#カラム名]で、カラムのラベルを、tdタグなしで表示します。 -->
<!-- [$カラム名]で、カラムの値(テキストフィールド)を、tdタグなしで表示します。 -->
<table>
  <tr>
	[SYSTEM_ID]		[LANG]		[KBSAKU]
  </tr>
  <tr>
	<td>[#CLM]       </td><td colspan="3">[$CLM]       </td>
  </tr>
  <tr>
	<td>[#NAME_JA]   </td><td colspan="5">[$NAME_JA]   </td>
  </tr>
  <tr>
	<td>[#LABEL_NAME]</td><td colspan="3">[$LABEL_NAME]</td>
  </tr>
</table>
</og:view>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
