/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.common;

import org.opengion.fukurou.util.Cleanable;

/**
 * ﾕｰｻﾞｰ情報(UserInfo)のｻﾏﾘｰ情報のみﾊﾝﾄﾞﾘﾝｸﾞする為のｲﾝﾀｰﾌｪｰｽです。
 * ﾊﾟｯｹｰｼﾞ間依存を減らす為に、新規作成しています。
 * よって、resource/UserInfo の部分ﾒｿｯﾄﾞのみをｻﾎﾟｰﾄしていると考えてください。
 *
 * @og.rev 4.0.0.0 (2005/08/31) 新規作成
 * @og.group ﾛｸﾞｲﾝ制御
 *
 * @version	4.0
 * @author	Kazuhiko Hasegawa
 * @since	JDK5.0,
 */
public interface UserSummary extends Comparable<UserSummary> , Cleanable {

	/**
	 * ﾕｰｻﾞｰﾛｸﾞｲﾝ時刻を取得します。
	 *
	 * @return	ﾕｰｻﾞｰﾛｸﾞｲﾝ時刻
	 */
	long getLoginTime() ;

	/**
	 * ﾕｰｻﾞｰのﾛｸﾞｲﾝIPｱﾄﾞﾚｽを取得します。
	 *
	 * @return	IPｱﾄﾞﾚｽ
	 */
	String getIPAddress() ;

	/**
	 * ﾕｰｻﾞｰを返します。
	 *
	 * @return	ﾕｰｻﾞｰ
	 */
	String getUserID() ;

	/**
	 * ﾕｰｻﾞｰ情報ﾛｹｰﾙ(言語)を返します。
	 *
	 * @return	ﾛｹｰﾙ(言語)
	 */
	String getLang() ;

	/**
	 * ﾕｰｻﾞｰ情報 名称(日本語)を返します。
	 *
	 * @return	名称(日本語)
	 */
	String getJname() ;

	/**
	 * ﾕｰｻﾞｰ情報 ﾛｰﾙ(役割)を取得します。
	 *
	 * @return	ﾛｰﾙ(役割)
	 */
	String getRoles() ;

	/**
	 * ｵﾌﾞｼﾞｪｸﾄの識別子として、ﾕｰｻﾞｰ情報を返します。
	 *
	 * @return	ﾕｰｻﾞｰ情報
	 */
	String getInfo() ;

	/**
	 * ﾕｰｻﾞｰ情報の属性文字列を取得します。
	 *
	 * @param	key	ｷｰ
	 * @return	属性文字列
	 * @see	org.opengion.hayabusa.resource.UserInfo#getAttribute( String )
	 */
	String getAttribute( final String key ) ;

}
