/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.servlet;

import org.opengion.fukurou.system.OgRuntimeException ;		// 6.4.2.0 (2016/01/29)
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.servlet.multipart.MultipartParser;
import org.opengion.hayabusa.servlet.multipart.Part;
import org.opengion.hayabusa.servlet.multipart.FilePart;
import org.opengion.hayabusa.servlet.multipart.ParamPart;
import org.opengion.fukurou.util.ZipArchive;				// 6.0.0.0 (2014/04/11) zip 対応

import org.opengion.fukurou.model.FileOperation;			// 8.0.0.0 (2021/09/30)
import org.opengion.hayabusa.io.HybsFileOperationFactory;	// 8.0.0.0 (2021/09/30)

import java.io.File;
import java.io.IOException;
// import java.io.FileNotFoundException;					// 6.9.0.1 (2018/02/05)
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;			// 6.4.3.1 (2016/02/12) refactoring

import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.Random ;
import java.util.concurrent.atomic.AtomicInteger;			// 5.5.2.6 (2012/05/25) findbugs対応
import jakarta.servlet.http.HttpServletRequest;

/**
 * ﾌｧｲﾙをｻｰﾊﾞｰにｱｯﾌﾟﾛｰﾄﾞする場合に使用されるﾏﾙﾁﾊﾟｰﾄ処理ｻｰﾌﾞﾚｯﾄです｡
 *
 * 通常のﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ時の､form で使用する､enctype="multipart/form-data"
 * を指定した場合の､他のﾘｸｴｽﾄ情報も､取り出すことが可能です｡
 *
 * ﾌｧｲﾙをｱｯﾌﾟﾛｰﾄﾞ後に､指定のﾌｧｲﾙ名に変更する機能があります｡
 * file 登録ﾀﾞｲｱﾛｸﾞで指定した name に､"_NEW" という名称を付けたﾘｸｴｽﾄ値を
 * ﾌｧｲﾙのｱｯﾌﾟﾛｰﾄﾞと同時に送信することで､この名前にﾌｧｲﾙを付け替えます｡
 * また､ｱｯﾌﾟﾛｰﾄﾞ後のﾌｧｲﾙ名は､name 指定の名称で､取り出せます｡
 * ｸﾗｲｱﾝﾄから登録したｵﾘｼﾞﾅﾙのﾌｧｲﾙ名は､name に､"_ORG" という名称
 * で取り出すことが可能です｡
 *
 * maxPostSize : 最大転送ｻｲｽﾞ(Byte)を指定します｡ 0,またはﾏｲﾅｽで無制限です｡
 * useBackup   : ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ時に､すでに同名のﾌｧｲﾙが存在した場合に､
 *               ﾊﾞｯｸｱｯﾌﾟ処理(renameTo)するかどうか[true/false]を指定します(初期値:false)
 *
 * ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ時に､ｱｯﾌﾟﾛｰﾄﾞ先に､同名のﾌｧｲﾙが存在した場合は､既存機能は､そのまま
 * 置き換えていましたが､簡易ﾊﾞｰｼﾞｮﾝｱｯﾌﾟ機能として､useBackup="true" を指定すると､既存のﾌｧｲﾙを
 * ﾘﾈｰﾑして､ﾊﾞｯｸｱｯﾌﾟﾌｧｲﾙを作成します｡
 * ﾊﾞｯｸｱｯﾌﾟﾌｧｲﾙは､ｱｯﾌﾟﾛｰﾄﾞﾌｫﾙﾀﾞを基準として､_backup/ﾌｧｲﾙ名.拡張子_処理時刻のlong値.拡張子 になります｡
 * ｵﾘｼﾞﾅﾙのﾌｧｲﾙ名（拡張子付）を残したまま､"_処理時刻のlong値" を追加し､さらに､ｵﾘｼﾞﾅﾙの拡張子を追加します｡
 * ﾊﾞｯｸｱｯﾌﾟﾌｧｲﾙの形式は指定できません｡
 *
 * 5.7.1.2 (2013/12/20) zip 対応
 * filename 属性に､".zip" の拡張子のﾌｧｲﾙ名を指定した場合は､ｱｯﾌﾟﾛｰﾄﾞされた一連のﾌｧｲﾙを
 * ZIP圧縮します｡これは､ｱｯﾌﾟﾛｰﾄﾞ後の処理になります｡
 * ZIP圧縮のｵﾘｼﾞﾅﾙﾌｧｲﾙは､そのまま残ります｡
 * なお､ZIPﾌｧｲﾙは､useBackup属性を true に設定しても､無関係に､上書きされます｡
 *
 * 8.0.1.0 (2021/10/29) storageType → storage ､bucketName → bucket に変更
 * ×  storage  (初期値：ｼｽﾃﾑﾘｿｰｽのCLOUD_TARGET) → 廃止
 * ×  bucket   (初期値：ｼｽﾃﾑﾘｿｰｽのCLOUD_BUCKET) → 廃止
 *   useLocal (初期値：false)
 *
 * @og.rev 5.10.9.0 (2019/03/01) oota ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ対応を追加｡(Fileｸﾗｽを拡張)
 * @og.group その他機能
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public final class MultipartRequest {
	private static AtomicInteger dumyNewFileCnt = new AtomicInteger(1);		// 5.5.2.6 (2012/05/25) findbugs対応

	// 5.6.5.3 (2013/06/28) ｱｯﾌﾟﾛｰﾄﾞ時のﾀﾞﾐｰﾌｧｲﾙ名をもう少しだけﾗﾝﾀﾞﾑにする｡
	// 6.3.9.0 (2015/11/06) Variables should start with a lowercase character(PMD)
	private static final String RANDOM_KEY = new Random().nextInt( Integer.MAX_VALUE ) + "_" ;

	/** 6.4.3.1 (2016/02/12) PMD refactoring. TreeMap → ConcurrentSkipListMap に置き換え｡ */
	private final Map<String,List<String>> paramMap	= new ConcurrentSkipListMap<>();	// 6.4.3.1 (2016/02/12) ｿｰﾄします｡

	// 5.7.1.1 (2013/12/13) HTML5 ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞの複数選択（multiple）対応
	private final List<UploadedFile> files				= new ArrayList<>();			// 5.7.1.1 (2013/12/13) HTML5対応

	/**
	 * MultipartRequest ｵﾌﾞｼﾞｪｸﾄを構築します｡
	 *
	 * 引数として､ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ時の保存ﾌｫﾙﾀﾞ､最大ｻｲｽﾞ､ｴﾝｺｰﾄﾞ､
	 * 新しいﾌｧｲﾙ名などを指定できます｡新しいﾌｧｲﾙ名は､ｱｯﾌﾟﾛｰﾄﾞされる
	 * ﾌｧｲﾙが一つだけの場合に使用できます｡複数のﾌｧｲﾙを同時に変更したい
	 * 場合は､ｱｯﾌﾟﾛｰﾄﾞﾙｰﾙにのっとり､ﾘｸｴｽﾄﾊﾟﾗﾒｰﾀで指定してください｡
	 *
	 * HTML5 では､ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ時に､multiple 属性（inputﾀｸﾞのtype="file"）を
	 * 付ける事で､ﾌｧｲﾙを複数選択できます｡
	 * その場合は､inputのname属性は､一つなので､_NEW による名前の書き換えはできません｡
	 *
	 * @og.rev 3.8.1.3A (2006/01/30) 新ﾌｧｲﾙ名にｵﾘｼﾞﾅﾙﾌｧｲﾙ名の拡張子をｾｯﾄします
	 * @og.rev 4.0.0.0 (2007/11/28) ﾒｿｯﾄﾞの戻り値をﾁｪｯｸします｡
	 * @og.rev 5.5.2.6 (2012/05/25) findbugs対応｡staticﾌｨｰﾙﾄﾞへの書き込みに､AtomicInteger を利用します｡
	 * @og.rev 5.6.5.3 (2013/06/28) useBackup引数追加
	 * @og.rev 5.7.1.1 (2013/12/13) HTML5 ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞの複数選択（multiple）対応
	 * @og.rev 5.7.1.2 (2013/12/20) zip 対応
	 * @og.rev 5.7.4.3 (2014/03/28) zip 対応復活｡inputFilename のﾘｸｴｽﾄ変数処理追加
	 * @og.rev 6.0.2.4 (2014/10/17) useBackup 修正｡_PFX(接頭辞) , _SFX(接尾辞) 機能を追加｡ﾌｧｲﾙ名にﾌｫﾙﾀﾞ指定可
	 * @og.rev 6.4.3.1 (2016/02/12) PMD refactoring. HashMap → ConcurrentHashMap に置き換え｡
	 * @og.rev 5.9.25.0 (2017/10/06) ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ利用処理追加
	 * @og.rev 6.9.0.1 (2018/02/05) ﾌｧｲﾙをｾｰﾌﾞするﾃﾞｨﾚｸﾄﾘは､必要な場合のみ､作成します｡
	 * @og.rev 5.10.9.0 (2019/03/01) ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ対応を追加｡
	 * @og.rev 8.0.0.2 (2021/10/15) ﾛｰｶﾙﾌｧｲﾙとｸﾗｳﾄﾞﾌｧｲﾙ間の移動
	 * @og.rev 8.0.1.0 (2021/10/29) useLocal 属性を追加｡storageType , bucketName 削除
	 *
	 * @param	request	HttpServletRequestｵﾌﾞｼﾞｪｸﾄ
	 * @param	saveDirectory	ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞがあった場合の保存ﾌｫﾙﾀﾞ名
	 * @param	maxPostSize		ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ時の最大ﾌｧｲﾙｻｲｽﾞ(Byte)0,またはﾏｲﾅｽで無制限
	 * @param	encoding		ﾌｧｲﾙのｴﾝｺｰﾄﾞ
	 * @param	inputFilename	ｱｯﾌﾟﾛｰﾄﾞされたﾌｧｲﾙの新しい名前
	 * @param	useBackup		ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ時に､ﾊﾞｯｸｱｯﾌﾟ処理するかどうか[true/false/rename]を指定
	 * @param	fileURL			ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ用のURL
//	 * @param	storage			ｸﾗｳﾄﾞﾌﾟﾗｸﾞｲﾝ名(ﾛｰｶﾙﾌｧｲﾙを強制する場合は､LOCAL を指定する)
//	 * @param	bucket			ﾊﾞｹｯﾄ名(ﾛｰｶﾙﾌｧｲﾙを強制する場合は､LOCAL を指定する)
	 * @param	useLocal		強制的にﾛｰｶﾙﾌｧｲﾙを使用する場合､true にｾｯﾄします｡
	 * @throws IOException 入出力ｴﾗｰが発生したとき
	 * @throws IllegalArgumentException ｾｰﾌﾞﾃﾞｨﾚｸﾄﾘ に関係するｴﾗｰ
	 */
	public MultipartRequest(final HttpServletRequest request,
							final String	saveDirectory,
							final int		maxPostSize,
							final String	encoding,
							final String	inputFilename,
							final String	useBackup,								// 6.0.2.4 (2014/10/17) true/false/rename
//							final String	fileURL) throws IOException,IllegalArgumentException {		// (2017/10/06) 追加
							final String	fileURL,
//							final String	storage,
//							final String	bucket ) throws IOException,IllegalArgumentException {		// 5.10.9.0 (2019/03/01) ADD
							final boolean	useLocal ) throws IOException,IllegalArgumentException {	// 8.0.1.0 (2021/10/29)

		if( request == null ) {
			throw new IllegalArgumentException("request cannot be null");
		}

//		// 6.9.0.1 (2018/02/05) ﾌｧｲﾙをｾｰﾌﾞするﾃﾞｨﾚｸﾄﾘは､必要な場合のみ､作成します｡
//		if( saveDirectory == null ) {
//			throw new IllegalArgumentException("saveDirectory cannot be null");
//		}
//		// 5.5.2.6 (2012/05/25) 0,またはﾏｲﾅｽで無制限
//		// Save the dir
//		final File dir = new File(saveDirectory);
//
//		// Check saveDirectory is truly a directory
//		if( !dir.isDirectory() ) {
//			throw new IllegalArgumentException("Not a directory: " + saveDirectory);
//		}
//
//		// Check saveDirectory is writable
//		if( !dir.canWrite() ) {
//			throw new IllegalArgumentException("Not writable: " + saveDirectory);
//		}

		// Parse the incoming multipart, storing files in the dir provided,
		// and populate the meta objects which describe what we found
		final MultipartParser parser = new MultipartParser(request, maxPostSize);
		if( encoding != null ) {
			parser.setEncoding(encoding);
		}

//		// 2017/10/06 ADD ｼｽﾃﾑﾘｿｰｽにｸﾗｳﾄﾞｽﾄﾚｰｼﾞ利用が登録されている場合は､ｸﾗｳﾄﾞｽﾄﾚｰｼﾞを利用する
//		final String storage = HybsSystem.sys( "CLOUD_TARGET");
//		final boolean useStorage = storage != null && storage.length() > 0 ;

//		File dir  = null;
		// Save the dir
		// 5.10.9.0 (2019/03/01) ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ対応 oota tmp
		// File dir = new File(saveDirectory);
		// 8.0.0.2 (2021/10/15) ﾛｰｶﾙﾌｧｲﾙとｸﾗｳﾄﾞﾌｧｲﾙ間の移動
		// 8.0.1.0 (2021/10/29) storageType , bucketName 削除
//		final FileOperation dir = HybsFileOperationFactory.create(storageType, bucketName, saveDirectory);
//		final FileOperation dir = HybsFileOperationFactory.createDir(storage, bucket, saveDirectory);
		final FileOperation dir = HybsFileOperationFactory.createDir(useLocal, saveDirectory);
		// 5.10.9.0 (2019/03/01) if条件を追加｡ﾁｪｯｸはﾛｰｶﾙｽﾄﾚｰｼﾞの場合のみ行います｡ oota tmp
//		if(dir.isLocal()) {
//		if( !dir.isCloud() ) {
//			// ｾｰﾌﾞﾃﾞｨﾚｸﾄﾘ 作成
//			if( ! dir.exists() && ! dir.mkdirs() ) {
//				throw new IllegalArgumentException( "Not make directory: " + saveDirectory );
//			}
//
//			// Check saveDirectory is truly a directory
//			if(!dir.isDirectory()) {
//				throw new IllegalArgumentException("Not a directory: " + saveDirectory);
//			}
//
//			// Check saveDirectory is writable
//			if(!dir.canWrite()) {
//				throw new IllegalArgumentException("Not writable: " + saveDirectory);
//			}
//		}

		// 5.7.1.1 (2013/12/13) HTML5 ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞの複数選択（multiple）対応
		Part part;
		while( (part = parser.readNextPart()) != null ) {
			final String name = part.getName();
			if( part.isParam() && part instanceof ParamPart ) {
				final ParamPart paramPart = (ParamPart)part;
				final String value = paramPart.getStringValue();
				// 6.4.3.1 (2016/02/12) ConcurrentMap 系は､key,val ともに not null 制限です｡
				List<String> existingValues = paramMap.get(name);
				if( existingValues == null ) {
					existingValues = new ArrayList<>();
					paramMap.put(name, existingValues);
				}
				existingValues.add(value);
			}
			else if( part.isFile() && part instanceof FilePart ) {
				final FilePart filePart = (FilePart)part;
				final String orgName = filePart.getFilename();		// 5.7.1.1 (2013/12/13) 判りやすいように変数名変更
				if( orgName != null ) {
					// 5.7.1.1 (2013/12/13) HTML5 ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞの複数選択（multiple）対応
					// 同一 name で､複数ﾌｧｲﾙを扱う必要があります｡
					// 3.8.1.2 (2005/12/19) 仮ﾌｧｲﾙでｾｰﾌﾞする｡
					// 5.6.5.3 (2013/06/28) ｱｯﾌﾟﾛｰﾄﾞ時のﾀﾞﾐｰﾌｧｲﾙ名をもう少しだけﾗﾝﾀﾞﾑにする｡
					final String uniqKey = RANDOM_KEY + dumyNewFileCnt.getAndIncrement() ;
					filePart.setFilename( uniqKey );
					// 標準のﾌｧｲﾙ書き込み 2017/10/06 DELETE ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ利用判定を追加

					// ﾌｧｲﾙ書き込み
					// 5.10.9.0 (2019/03/01) ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ対応｡oota tmp
					// 8.0.1.0 (2021/10/29) storageType , bucketName 削除
//					filePart.writeTo(dir);
//					filePart.writeTo(dir, storage, bucket);
					filePart.writeTo(dir, useLocal);

//					if( useStorage ){
//						// ｸﾗｳﾄﾞｽﾄﾚｰｼﾞにｱｯﾌﾟﾛｰﾄﾞ
//						filePart.writeToCloud( storage, fileURL, request.getSession(true) );
//					}else{
//	//					if( dir == null ) { dir = makeDirs( saveDirectory ); }		// 6.9.0.1 (2018/02/05)
//						// 標準のﾌｧｲﾙ書き込み
//						filePart.writeTo(dir);
//					}

					// 5.7.1.1 (2013/12/13) HTML5 ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞの複数選択（multiple）対応
					files.add( new UploadedFile(
											uniqKey,		// 5.7.1.1 (2013/12/13) 順番変更
											dir.toString(),
											name,			// 5.7.1.1 (2013/12/13) 項目追加
											orgName,
											filePart.getContentType()));
				}
			}
			else {
				final String errMsg = "Partｵﾌﾞｼﾞｪｸﾄが､ParamPartでもFilePartでもありません｡"
							+ " class=[" + part.getClass() + "]";
				throw new OgRuntimeException( errMsg );
			}
		}

		// 5.7.4.3 (2014/03/28) inputFilename は､ﾘｸｴｽﾄ変数が使えるようにします｡
		final String filename = getReqParamFileName( inputFilename ) ;

		// 3.5.6.5 (2004/08/09) 登録後にﾌｧｲﾙをﾘﾈｰﾑします｡
		// 5.7.1.1 (2013/12/13) HTML5 ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞの複数選択（multiple）対応
		final int size = files.size();

		// 5.7.1.2 (2013/12/20) zip 対応
		// 5.9.25.0 (2017/10/06) FileをString型に変更
		final String[] tgtFiles = new String[size];
		final boolean isZip = filename != null && filename.endsWith( ".zip" ) ;

		for( int i=0; i<size; i++ ) {
			final UploadedFile upFile = files.get(i);
			final String name = upFile.getName();		// 5.7.1.1 (2013/12/13)

			String newName = isZip ? null : filename ;
			String prefix = null ;				// 6.0.2.4 (2014/10/17) _PFX(接頭辞) , _SFX(接尾辞) 機能を追加
			String sufix  = null ;				// 6.0.2.4 (2014/10/17) _PFX(接頭辞) , _SFX(接尾辞) 機能を追加
			if( newName == null && name != null ) {
				final int adrs = name.lastIndexOf( HybsSystem.JOINT_STRING );	// ｶﾗﾑ__行番号 の __ の位置
				// 6.0.2.4 (2014/10/17) _PFX(接頭辞) , _SFX(接尾辞) 機能を追加
				if( adrs < 0 ) {
					newName = getParameter( name + "_NEW" );
					prefix  = getParameter( name + "_PFX" );
					sufix   = getParameter( name + "_SFX" );
				}
				else {
					final String name1 = name.substring( 0,adrs );
					final String name2 = name.substring( adrs );
					newName = getParameter( name1 + "_NEW" + name2 );
					prefix  = getParameter( name1 + "_PFX" + name2 );
					sufix   = getParameter( name1 + "_SFX" + name2 );
				}
			}

			// 5.7.1.1 (2013/12/13) UploadedFile 内で処理するように変更
			// 5.9.25.0 (2017/10/06) MODIFY fileURLとsessionを追加
			// 5.10.9.0 (2019/03/01) ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ対応｡sessionは不要になったため除去｡ ootat tmp
			// 8.0.1.0 (2021/10/29) storageType , bucketName 削除
//			tgtFiles[i] = upFile.renameTo( newName,prefix,sufix,useBackup,fileURL,request.getSession(true) );
//			tgtFiles[i] = upFile.renameTo( newName,prefix,sufix,useBackup,fileURL, storage, bucket);
			tgtFiles[i] = upFile.renameTo( newName,prefix,sufix,useBackup,fileURL, useLocal);
		}
		// 5.7.1.2 (2013/12/20) zip 対応
		// 6.0.0.0 (2014/04/11) 一旦保留にしていましたが､復活します｡
//		if( isZip && !useStorage ) {
		if( isZip && (useLocal || !dir.isCloud()) ) {
			final File zipFile = new File( saveDirectory,filename );
			// 5.9.25.0 (2017/10/06) tgtFiles が､String型に変更されたため
			final File[] files = new File[tgtFiles.length];
			for( int i=0; i<tgtFiles.length; i++ ) {
				files[i] = new File( tgtFiles[i] );
			}
			ZipArchive.compress( files,zipFile );
		}
	}

	/**
	 * ﾘｸｴｽﾄﾊﾟﾗﾒｰﾀの名前配列を取得します｡
	 *
	 * @return	ﾘｸｴｽﾄﾊﾟﾗﾒｰﾀの名前配列
	 * @og.rtnNotNull
	 */
	public String[] getParameterNames() {
		final Set<String> keyset = paramMap.keySet();
		return keyset.toArray( new String[keyset.size()] );
	}

	/**
	 * ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞされたﾌｧｲﾙ群のﾌｧｲﾙ配列を取得します｡
	 *
	 * @og.rev 5.7.1.1 (2013/12/13) HTML5 ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞの複数選択（multiple）対応
	 *
	 * @return	ｱｯﾌﾟﾛｰﾄﾞされたﾌｧｲﾙ群
	 * @og.rtnNotNull
	 */
	public UploadedFile[] getUploadedFile() {
		return files.toArray( new UploadedFile[files.size()] );
	}

	/**
	 * 指定の名前のﾘｸｴｽﾄﾊﾟﾗﾒｰﾀの値を取得します｡
	 *
	 * 複数存在する場合は､一番最後の値を返します｡
	 *
	 * @param	name	ﾘｸｴｽﾄﾊﾟﾗﾒｰﾀ名
	 *
	 * @return	ﾊﾟﾗﾒｰﾀの値
	 */
	public String getParameter( final String name ) {
		final List<String> values = paramMap.get(name);

		// 6.4.1.1 (2016/01/16) PMD refactoring. A method should have only one exit point, and that should be the last statement in the method
		return values == null || values.isEmpty() ? null : values.get( values.size() - 1 );
	}

	/**
	 * 指定の名前のﾘｸｴｽﾄﾊﾟﾗﾒｰﾀの値を配列型式で取得します｡
	 *
	 * @og.rev 5.3.2.0 (2011/02/01) 新規作成
	 * @og.rev 6.3.9.1 (2015/11/27) null ではなく長さが0の配列を返すことを検討する(findbugs)｡
	 *
	 * @param	name	ﾘｸｴｽﾄﾊﾟﾗﾒｰﾀ名
	 *
	 * @return	ﾊﾟﾗﾒｰﾀの値配列(存在しない場合は､長さ０の配列を返します)
	 * @og.rtnNotNull
	 */
	public String[] getParameters( final String name ) {
		final List<String> values = paramMap.get(name);
		return values == null || values.isEmpty()
					? new String[0]
					: values.toArray( new String[values.size()] );
	}

	/**
	 * 指定の名前のﾘｸｴｽﾄﾊﾟﾗﾒｰﾀの値を配列(int)型式で取得します｡
	 *
	 * @og.rev 5.3.2.0 (2011/02/01) 新規作成
	 * @og.rev 5.3.6.0 (2011/06/01) 配列値が""の場合にNumberFormatExceptionが発生するﾊﾞｸﾞを修正
	 * @og.rev 6.3.9.1 (2015/11/27) null ではなく長さが0の配列を返すことを検討する(findbugs)｡
	 *
	 * @param	name	ﾘｸｴｽﾄﾊﾟﾗﾒｰﾀ名
	 *
	 * @return	ﾊﾟﾗﾒｰﾀの値配列(存在しない場合は､長さ０の配列を返します)
	 * @og.rtnNotNull
	 */
	public int[] getIntParameters( final String name ) {
		final List<String> values = paramMap.get(name);

		return values == null || values.isEmpty()
					? new int[0]
					: values.stream()
							.filter( str -> str != null && !str.isEmpty() )		// 条件
							.mapToInt( Integer::parseInt )						// 変換 String → int
							.toArray();											// int[] 配列
	}

	/**
	 * 指定の名前の ﾌｧｲﾙ名のﾘｸｴｽﾄ変数処理を行います｡
	 *
	 * filename 属性のみ､{&#064;XXXX} のﾘｸｴｽﾄ変数が使えるようにします｡
	 *
	 * @og.rev 5.7.4.3 (2014/03/28) 新規追加
	 *
	 * @param	fname	ﾌｧｲﾙ名
	 * @return	ﾘｸｴｽﾄ変数を処理したﾌｧｲﾙ名
	 */
	private String getReqParamFileName( final String fname ) {

		String rtn = fname ;
		if( fname != null ) {
			final StringBuilder filename = new StringBuilder( fname ) ;
			int st = filename.indexOf( "{@" );
			while( st >= 0 ) {
				final int ed = filename.indexOf( "}",st );
				if( ed < 0 ) {
					final String errMsg = "{@XXXX} の対応関係が取れていません｡"
								+ " filename=[" + fname + "]";
					throw new OgRuntimeException( errMsg );
				}
				final String key = filename.substring( st+2,ed );		// "}" は切り出し対象外にする｡
				final String val = getParameter( key );
				filename.replace( st,ed+1,val );				// "}" を含めて置換したいので､ed+1
				// 次の "{@" を探す｡開始は置換文字数が不明なので､st から始める｡
				st = filename.indexOf( "{@",st );
			}
			rtn = filename.toString();
		}
		return rtn ;
	}

//	/**
//	 * 指定のﾃﾞｨﾚｸﾄﾘが無ければ作成します｡
//	 *
//	 * @og.rev 6.9.0.1 (2018/02/05) ﾌｧｲﾙをｾｰﾌﾞするﾃﾞｨﾚｸﾄﾘは､必要な場合のみ､作成します｡
//	 * @og.rev 8.0.0.0 (2021/09/30) ｸﾗｳﾄﾞ対応のため､
//	 *
//	 * @param	saveDir	ﾃﾞｨﾚｸﾄﾘ名
//	 * @return	ｾｰﾌﾞ可能なﾃﾞｨﾚｸﾄﾘ
//	 * @throws	IllegalArgumentException	ｾｰﾌﾞﾃﾞｨﾚｸﾄﾘ に関係するｴﾗｰ(無理から)
//	 */
//	private File makeDirs( final String saveDir ) throws IllegalArgumentException {
//		// ｾｰﾌﾞﾃﾞｨﾚｸﾄﾘの名前ﾁｪｯｸ
//		if( saveDir == null ) {
//			throw new IllegalArgumentException( "saveDir cannot be null" );
//		}
//
//		// ｾｰﾌﾞﾃﾞｨﾚｸﾄﾘのｵﾌﾞｼﾞｪｸﾄ
//		final File dir = new File( saveDir );
//
//		// ｾｰﾌﾞﾃﾞｨﾚｸﾄﾘ 作成
//		if( ! dir.exists() && ! dir.mkdirs() ) {
//			throw new IllegalArgumentException( "Not make directory: " + saveDir );
//		}
//
//		// ﾃﾞｨﾚｸﾄﾘでなければ､ｴﾗｰ
//		if( !dir.isDirectory() ) {
//			throw new IllegalArgumentException( "Not a directory: " + saveDir );
//		}
//
//		// 書込みできなければ､ｴﾗｰ
//		if( !dir.canWrite() ) {
//			throw new IllegalArgumentException( "Not writable: " + saveDir );
//		}
//
//		return dir;
//	}
}
