
/**
 * <pre>
 * このﾄﾞｷｭﾒﾝﾄは、ﾌﾟﾗｸﾞｲﾝ類を集めた『はやぶさplugin』の API 仕様です。
 *
 * plugin には、【calendar】、【column】、【daemon】、【develop】、【io】、【query】、【table】、【view】
 * があり、各ｶｽﾀﾑﾀｸﾞの属性でｷｰﾜｰﾄﾞを指定する事で、使用します。
 *
 * plugin の導入ﾒｶﾆｽﾞﾑは特殊(※)で、ｸﾗｽ名が、ｲﾝﾀｰﾌｪｰｽ_ｷｰﾜｰﾄﾞ.java
 * というｸﾗｽﾌｧｲﾙを、plugIn というｸﾗｽﾊﾟｽから、起動時に読み込んで、
 * ｼｽﾃﾑ設定ﾌｧｲﾙ(GE12)にﾛｰﾄﾞします。
 * 本体は、ｼｽﾃﾑ設定ﾌｧｲﾙのｷｰと正式ｸﾗｽ名(ﾊﾟｯｹｰｼﾞ付きｸﾗｽ名)から、
 * 実際のｸﾗｽを起動します。
 *
 * よって、初期設定と同じｷｰﾜｰﾄﾞでﾌﾟﾗｸﾞｲﾝをｵｰﾊﾞｰﾛｰﾄﾞする場合は、Tomcat等の
 * ｱﾌﾟﾘｹｰｼｮﾝｻｰﾊﾞｰのｵｰﾊﾞｰﾛｰﾄﾞﾒｶﾆｽﾞﾑを利用して、読み込み優先順位を
 * あげる必要があります。
 * Tomcatでいうと、WEB-INF の lib と classes では、classes の方がｸﾗｽﾛｰﾄﾞの
 * 優先順位が高いので、標準plugin を lib に、ｶｽﾀﾑplugin を classes に配置する
 * ことで、ﾌﾟﾗｸﾞｲﾝをｵｰﾊﾞｰﾛｰﾄﾞを実現してください。
 *
 * ただし、起動後、ｼｽﾃﾑ設定ﾌｧｲﾙ(GE12) を書き換える事で、任意のｸﾗｽを
 * ｵｰﾊﾞｰﾛｰﾄﾞすることが可能ですので、先のｸﾗｽﾛｰﾀﾞｰでは解決できないｹｰｽ
 * では、こちらの方式を使用してください。
 *
 * ※ plugin の導入ﾒｶﾆｽﾞﾑ
 * plugin の導入ﾒｶﾆｽﾞﾑでは、Eclipseの採用している 
 * <a href="https://www.osgi.org/" target="_blank" >OSGi(Open Service Gataway Initiative)</a>
 * と、Tomcatの採用している
 * <a href="https://docs.oracle.com/javase/jp/1.5.0/guide/jmx/index.html" target="_blank" >
 * JMX(Java Management Extensions)</a>
 * が有名です。
 *
 * 現ﾊﾞｰｼﾞｮﾝでは、それぞれのﾌﾟﾗｸﾞｲﾝは独立したﾌﾟﾛｸﾞﾗﾑではなく、あくまで
 * 内部再利用を行う為の機構の為、簡易的な方法で、実装しています。
 * 
 *    org.opengion.plugin.calendar (classes)
 *       → org.opengion.fukurou.util                          classes
 *       → org.opengion.hayabusa.common                       classes
 *       → org.opengion.hayabusa.resource                     classes
 *    org.opengion.plugin.column (classes)
 *       → org.opengion.fukurou.db                            classes
 *       → org.opengion.fukurou.model                         classes
 *       → org.opengion.fukurou.security                      classes
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.util                          classes
 *       → org.opengion.hayabusa.common                       classes
 *       → org.opengion.hayabusa.db                           classes
 *       → org.opengion.hayabusa.resource                     classes
 *    org.opengion.plugin.daemon (classes)
 *       → org.opengion.fukurou.db                            classes
 *       → org.opengion.fukurou.mail                          classes
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.transfer                      classes
 *       → org.opengion.fukurou.util                          classes
 *       → org.opengion.hayabusa.common                       classes
 *       → org.opengion.hayabusa.mail                         classes
 *       → org.opengion.hayabusa.report                       classes
 *       → org.opengion.hayabusa.report2                      classes
 *    org.opengion.plugin.io (classes)
 *       → org.opengion.fukurou.model                         classes
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.util                          classes
 *       → org.opengion.hayabusa.common                       classes
 *       → org.opengion.hayabusa.db                           classes
 *       → org.opengion.hayabusa.io                           classes
 *    org.opengion.plugin.query (classes)
 *       → org.opengion.fukurou.model                         classes
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.util                          classes
 *       → org.opengion.hayabusa.common                       classes
 *       → org.opengion.hayabusa.db                           classes
 *    org.opengion.plugin.report (classes)
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.util                          classes
 *       → org.opengion.hayabusa.common                       classes
 *       → org.opengion.hayabusa.db                           classes
 *       → org.opengion.hayabusa.report                       classes
 *    org.opengion.plugin.table (classes)
 *       → org.opengion.fukurou.db                            classes
 *       → org.opengion.fukurou.model                         classes
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.util                          classes
 *       → org.opengion.hayabusa.common                       classes
 *       → org.opengion.hayabusa.db                           classes
 *       → org.opengion.hayabusa.report2                      classes
 *       → org.opengion.hayabusa.resource                     classes
 *    org.opengion.plugin.view (classes)
 *       → org.opengion.fukurou.model                         classes
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.util                          classes
 *       → org.opengion.hayabusa.common                       classes
 *       → org.opengion.hayabusa.db                           classes
 *       → org.opengion.hayabusa.html                         classes
 *       → org.opengion.hayabusa.resource                     classes
 * </pre>
 */

package org.opengion.plugin;
