/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

import org.opengion.fukurou.system.OgBuilder ;				// 6.4.4.1 (2016/03/18)

/**
 * TableFilter_SEQUENCE_FIREBIRD は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。
 *
 * ここでは、シーケンス一覧の検索結果より、GF09 のシーケンス定義テーブルから
 * 必要な情報を取得し、シーケンス作成スクリプトを作成します。
 *
 * この処理を実行するには、DBTableModelのカラムとして、
 *  SEQNAME,INCREBY,STARTVAL,MINVAL,MAXVAL,FGCYCLE,SUCACHE
 * が必要です。
 *
 * ※Firebirdに対して生成されるスクリプトでは、INCREBY,STARTVAL,MINVAL,MAXVAL,FGCYCLE,SUCACHEは無視されます。
 *
 * @og.rev 5.1.9.0 (2010/08/01) DB定義DB・シーケンス定義追加
 * @version  0.9.0  2010/08/01
 * @author   Hiroki Nakamura
 * @since    JDK1.1,
 */
public class TableFilter_SEQUENCE_FIREBIRD extends TableFilter_SEQUENCE {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.4.4.1 (2016/03/18)" ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public TableFilter_SEQUENCE_FIREBIRD() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * シーケンス作成の処理を実行します。
	 *
	 * @og.rev 6.0.2.3 (2014/10/10) isXml で、CR + EXEC_END_TAG のキャッシュ(execEndTag)を利用します。
	 * @og.rev 6.4.4.1 (2016/03/18) StringBuilderの代わりに、OgBuilderを使用する。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	シーケンス作成
	 * @og.rtnNotNull
	 */
	@Override
	protected String makeLineList( final int[] clmNo,final String[] data ) {
		final String execSeqSQL = "SELECT COUNT(*) FROM RDB$GENERATORS WHERE RDB$GENERATOR_NAME=UPPER('" ;

		return new OgBuilder()
//				.appendIfCR( isXml , EXEC_START_TAG )
//				.append( "CREATE SEQUENCE " , data[clmNo[SEQNAME]] )
				.appendIfCR( isXml , EXEC_EXISTS_0_TAG )		//  EXISTS_0 判定は、XML の場合のみ。
				.appendIfCR( isXml , execSeqSQL , data[clmNo[SEQNAME]] , "');" )
				.append( "CREATE SEQUENCE "     , data[clmNo[SEQNAME]] )
				.append( execEndTag )
				.toString();
	}
}
