/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.cloud;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.opengion.cloud.CloudFileOperation;
import org.opengion.cloud.FileOperationInfo;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class FileOperation_AWS
extends CloudFileOperation {
    private static final long serialVersionUID = 5108020190201L;
    private static final String PLUGIN = "AWS";
    private final AmazonS3 amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false))).build();

    public FileOperation_AWS(String string, String string2) {
        super(StringUtil.nval((String)string, (String)HybsSystem.sys((String)"CLOUD_BUCKET")), string2);
        try {
            if (!this.amazonS3.doesBucketExistV2(this.conBucket)) {
                this.amazonS3.createBucket(this.conBucket);
            }
        }
        catch (AmazonS3Exception amazonS3Exception) {
            String string3 = new StringBuilder(200).append("IAM\uff9b\uff70\uff99\u306b\u3088\u308b\u8a8d\u8a3c\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002").append(HybsConst.CR).append(string2).toString();
            throw new HybsSystemException(string3, (Throwable)amazonS3Exception);
        }
    }

    @Override
    public void write(File file) throws IOException {
        try {
            this.amazonS3.putObject(this.conBucket, this.conPath, file);
        }
        catch (Throwable throwable) {
            String string = new StringBuilder(200).append("AWS\uff8a\uff9e\uff79\uff6f\uff84\u306b(File)\u66f8\u304d\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002").append(HybsConst.CR).append(this.conPath).toString();
            throw new IOException(string, throwable);
        }
    }

    @Override
    public void write(InputStream inputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            byte[] byArray = this.toByteArray(inputStream);
            objectMetadata.setContentLength((long)byArray.length);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.conBucket, this.conPath, (InputStream)byteArrayInputStream, objectMetadata);
            this.amazonS3.putObject(putObjectRequest);
        }
        catch (Throwable throwable) {
            try {
                String string = new StringBuilder(200).append("AWS\uff8a\uff9e\uff79\uff6f\uff84\u306b(InputStream)\u66f8\u304d\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002").append(HybsConst.CR).append(this.conPath).toString();
                throw new IOException(string, throwable);
            }
            catch (Throwable throwable2) {
                Closer.ioClose(byteArrayInputStream);
                throw throwable2;
            }
        }
        Closer.ioClose((Closeable)byteArrayInputStream);
    }

    @Override
    public InputStream read() throws FileNotFoundException {
        S3Object s3Object = null;
        try {
            s3Object = this.amazonS3.getObject(this.conBucket, this.conPath);
        }
        catch (Throwable throwable) {
            String string = new StringBuilder(200).append("AWS\uff8a\uff9e\uff79\uff6f\uff84\u304b\u3089\u8aad\u307f\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002").append(HybsConst.CR).append(this.conPath).append(HybsConst.CR).append(throwable.getMessage()).toString();
            throw new FileNotFoundException(string);
        }
        return s3Object.getObjectContent();
    }

    @Override
    public boolean delete() {
        boolean bl = false;
        try {
            if (this.isFile()) {
                this.amazonS3.deleteObject(this.conBucket, this.conPath);
            } else if (this.isDirectory()) {
                ObjectListing objectListing = this.amazonS3.listObjects(this.conBucket, this.conPath);
                List list = objectListing.getObjectSummaries();
                for (S3ObjectSummary s3ObjectSummary : list) {
                    this.amazonS3.deleteObject(this.conBucket, s3ObjectSummary.getKey());
                }
            }
            bl = true;
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
        }
        return bl;
    }

    @Override
    public boolean copy(String string) {
        boolean bl = false;
        try {
            this.amazonS3.copyObject(this.conBucket, this.conPath, this.conBucket, string);
            bl = true;
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
        }
        return bl;
    }

    @Override
    public long length() {
        long l = 0L;
        try {
            ObjectMetadata objectMetadata = this.amazonS3.getObjectMetadata(this.conBucket, this.conPath);
            l = objectMetadata.getContentLength();
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
        }
        return l;
    }

    @Override
    public long lastModified() {
        long l = 0L;
        try {
            ObjectMetadata objectMetadata = this.amazonS3.getObjectMetadata(this.conBucket, this.conPath);
            l = objectMetadata.getLastModified().getTime();
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
        }
        return l;
    }

    @Override
    public boolean isFile() {
        boolean bl = false;
        if (!this.isDirectory()) {
            bl = this.amazonS3.doesObjectExist(this.conBucket, this.conPath);
        }
        return bl;
    }

    @Override
    public boolean isDirectory() {
        if (StringUtil.isEmpty((CharSequence[])new CharSequence[]{this.conPath})) {
            return true;
        }
        ObjectListing objectListing = this.amazonS3.listObjects(this.conBucket, this.setDirTail(this.conPath));
        List list = objectListing.getObjectSummaries();
        return !list.isEmpty();
    }

    @Override
    public File[] listFiles(FileFilter fileFilter) {
        Object object;
        String string;
        Object object22;
        if (!this.exists()) {
            return new FileOperationInfo[0];
        }
        String string2 = this.conPath;
        if (this.isDirectory()) {
            string2 = this.setDirTail(this.conPath);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request().withBucketName(this.conBucket).withPrefix(string2).withDelimiter("/");
        ListObjectsV2Result listObjectsV2Result = this.amazonS3.listObjectsV2(listObjectsV2Request);
        List list = listObjectsV2Result.getObjectSummaries();
        for (Object object22 : list) {
            string = object22.getKey();
            object = new FileOperationInfo(PLUGIN, this.conBucket, string);
            ((FileOperationInfo)((Object)object)).setLastModifiedValue(object22.getLastModified().getTime());
            ((FileOperationInfo)((Object)object)).setFile(true);
            ((FileOperationInfo)((Object)object)).setSize(object22.getSize());
            arrayList.add((File)object);
        }
        List list2 = listObjectsV2Result.getCommonPrefixes();
        object22 = list2.iterator();
        while (object22.hasNext()) {
            string = (String)object22.next();
            object = StringUtil.rTrim((String)string, (char)'/');
            FileOperationInfo fileOperationInfo = new FileOperationInfo(PLUGIN, this.conBucket, (String)object);
            fileOperationInfo.setDirectory(true);
            arrayList.add((File)((Object)fileOperationInfo));
        }
        return this.filter(arrayList, fileFilter);
    }

    public FileOperation getParentFile() {
        return new FileOperation_AWS(this.conBucket, this.getParent());
    }
}

