/*
 * OpenI2CRADIO
 * Internal eeprom Handler
 * Copyright (C) 2013-06-13 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef EEPROM_H
#define	EEPROM_H

#ifdef	__cplusplus
extern "C" {
#endif
/*
 * Basic IO routine for EEPROM.
 */
extern unsigned char eeprom_readbyte(unsigned int offset);
extern unsigned char eeprom_writebyte(unsigned int offset, unsigned char data);
/*
 * Calc checksum.
 */
extern unsigned int calcsum_byte(unsigned int seed, unsigned char byte);
extern unsigned char checksum_eeprom(unsigned int seed, unsigned int offset, unsigned int bytes);
/*
 * Format EEPROM.
 */
extern unsigned int format_eeprom(unsigned int start, unsigned int bytes);
/*
 * Read/Write with checksum.
 */
extern unsigned int readword_eeprom(unsigned int p, unsigned int *sum);
extern unsigned char readbyte_eeprom(unsigned int p, unsigned int *sum);
extern unsigned int writeword_eeprom(unsigned int p, unsigned int *sum, unsigned int word);
extern unsigned int writebyte_eeprom(unsigned int p, unsigned int *sum, unsigned char b);


#ifdef	__cplusplus
}
#endif

#endif	/* EEPROM_H */

