/*
 * 쐬: 2004/08/05
 *
 */
package openolap.viewer.chart;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;

import openolap.viewer.Axis;
import openolap.viewer.AxisMember;
import openolap.viewer.CellData;
import openolap.viewer.Col;
import openolap.viewer.Dimension;
import openolap.viewer.DimensionMember;
import openolap.viewer.Measure;
import openolap.viewer.MeasureMember;
import openolap.viewer.Report;
import openolap.viewer.Row;
import openolap.viewer.XMLConverter;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.common.ChartMessages;
import openolap.viewer.common.StringUtil;
import openolap.viewer.common.TimeDimensionInfo;
import openolap.viewer.controller.RequestHelper;
import openolap.viewer.dao.CellDataDAO;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.manager.CellDataManager;

import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * JFreeChartpXMLhLg𐶐NX
 */
public class ChartXMLCreator {

	// ********** CX^Xϐ **********

	private Connection conn = null;

	/** true ̏ꍇAV[YW[쐬ł邱ƂBXMLo͏̍ŌɃW[zuʒu̕AKvłB */
	private boolean creatingMultiSiriesChart = false;

	/** ChartType */
	private String chartType = null;

	/** |[g̃W[zuꏊ
	 *@ W[zuʒủړ́AReportƂƂ̏ꏊ擾łȂ̂ŁAɂ炩߉ێ */
	String originalMeasureEdgePosition = null;

	// ********** static \bh **********
	/**
	 * ^ꂽ`[g^Cv`[giSeries𕡐`[gjłꍇA
	 * trueԂAȊȌꍇfalseԂ
	 * @param chartType `[g^Cv
	 */
	static public boolean checkIsMultiChart(String chartType) {
		
		if (("VerticalMultiBar".equals(chartType)) ||
			 ("HorizontalMultiBar".equals(chartType)) ||
			 ("VerticalMulti3D_Bar".equals(chartType)) ||
			 ("HorizontalMulti3D_Bar".equals(chartType)) ||
			 ("MultiLine".equals(chartType)) ||
			 ("MultiArea".equals(chartType)) ||
			 ("MultiPie".equals(chartType)) ) {
			
			return true;		
		 } else {
			return false;
		 }
	}

	/**
	 * `[gXML̃t@CpX߂B
	 * @param helper RequestHelper
	 * @return `[gXML̃t@CpX
	 */
	static public String getChartXMLFilePath(RequestHelper helper) {

		// `[g^Cv擾
		String dirPath = helper.getRequest().getSession().getServletContext().getRealPath("/");
		String fileName = "spread/chart_kind.xml";
	
		return dirPath + "/" + fileName;

	}

	// ********** \bh **********

	/**
	 * `[gIDɑΉ`[g(XML^O)擾
	 * `[gIDƂNAnꂽꍇ́A`[gXMLŃftHgtrueł`[gvf̖̂߂B
	 * @param chartXMLFile `[gi[XMLt@C̃pX
	 * @param chartID
	 * @return `[g
	 */
	public String chartIdToName(String chartXMLFile, String chartID) {

		XMLConverter xmlConverter = new XMLConverter();
		Document doc = xmlConverter.readFile(chartXMLFile);

		Node chartNode = null;
		if ("NA".equals(chartID)) {
			chartNode = xmlConverter.selectSingleNode(doc, "//*[@default='true']");			
		} else {
			chartNode = xmlConverter.selectSingleNode(doc, "//*[@id=" + chartID + "]");			
		}

		return chartNode.getNodeName();

	}
	
	/**
	 * `[g(XML^O)ɑΉ`[gID(id)擾
	 * @param chartXMLFile `[gi[XMLt@C̃pX
	 * @param chartName
	 * @return `[gID
	 */
	public String chartNameToId(String chartXMLFile, String chartName) {

		String chartID = null;

		XMLConverter xmlConverter = new XMLConverter();
		Document doc = xmlConverter.readFile(chartXMLFile);
		Node chartNode = doc.getElementsByTagName(chartName).item(0);			

		chartID = chartNode.getAttributes().getNamedItem("id").getNodeValue();

		return chartID;

	}


	/**
	 * JFreeChartpXMLhLg
	 */
	public Document createXML(RequestHelper helper, CommonSettings commonSettings) {
		
		// Connection ̎擾
		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		this.conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
											  (String)helper.getRequest().getSession().getAttribute("searchPathName"));


		// sEɔzuꂽSDimensionIuWFNgDimensionMemberIuWFNgZbg
		Report report = (Report)helper.getRequest().getSession().getAttribute("report");
		try {
			report.setSelectedCOLROWDimensionMembers(helper,report,this.conn);
		} catch (SQLException e1) {
			e1.printStackTrace();
		}

		// `[g^CvZbg
		this.setChartTypeFromRequest(helper);


		// ReportO
		// ESeriesADataSet̍쐬ΏۂH i  creatingMultiSiriesChartXVj
		// E|[g̎zuύXKvH
		//   W[ɔzuĂ镡`[g(Series`[g)̏ꍇ
		//   W[sɔzuĂԂɒuXMLsȂ
		// E~Ot̏ꍇAŏ̍ŝ݂\ΏۂƂ
		Measure measure = report.getMeasure(); 								// W[
		this.originalMeasureEdgePosition = report.getThisAxisPosition(measure);	// W[̔zuĂGbW|WV
		int measureHieIndex = 0;											// W[̃W[GbWłIndex
		if ((originalMeasureEdgePosition.equals(Constants.Col)) || (originalMeasureEdgePosition.equals(Constants.Row))) { 

			if (ChartXMLCreator.checkIsMultiChart(this.chartType)) { // `[g

				if (originalMeasureEdgePosition.equals(Constants.Col)) { // W[ɔzuĂ
					this.creatingMultiSiriesChart = true;
					measureHieIndex  = report.getHieIndex(measure);
					report.deleteAxis(Constants.MeasureID);								// W[GbW牼폜
					report.getEdgeByType(Constants.Row).getAxisList().add(measure);		// W[sGbW̖ɉǉ
				}
			}			
		}
		// ~Ot̏ꍇAŏ̍ŝ݂\ΏۂƂ
		if ( (this.chartType == "Pie") || (this.chartType == "Pie_3D") ) {
			setFirstRowOnly(helper);
		}

		// XML
		Document doc = new XmlDocument();

			// XMLiChartInfo(Seriesm[hсA̔z̃m[hȊO)Zbgj
			this.addChartInfo(helper, commonSettings, doc);

			try {

				// XMLiSeries m[hсA̔z̃m[hZbgj
				this.addSeriesList(helper, commonSettings, doc);

				// XMLiDataSetm[hсA̔z̃m[hZbgj
				this.addDataSetList(helper, commonSettings, doc);

				// 쐬XMLo͗p̈ꎞI
//				XMLConverter xmlConverter = new XMLConverter();
//				String xmlString = xmlConverter.toXMLText(doc);
//				System.out.println("`[gp XMLo   from ChartXMLCreator ==============================");
//				System.out.println(xmlString);

			} catch (SQLException e) {
				e.printStackTrace();
			} catch (Exception e) { 
				e.printStackTrace();
			} finally {
				// Connection ̊J
				if(this.conn != null){
					try {
						this.conn.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
			}

		// Report㏈
		// E|[g̎zuύXsȂꂽꍇA̔zuɖ߂
		if (this.creatingMultiSiriesChart) {

				report.deleteAxis(Constants.MeasureID);															// W[sGbW폜
				report.getEdgeByType(originalMeasureEdgePosition).getAxisList().add(measureHieIndex, measure);	// W[GbWɒǉ
		}

		return doc;

	}

	// ********** private\bh **********

	/**
	 *  `[g^Cvݒ肷
	 * @param helper
	 */
	private void setChartTypeFromRequest(RequestHelper helper) {

		// NCAgvꂽ`[gID
		String chartID = helper.getRequest().getParameter("chartID");

		// `[gIDA`[g^Cv擾
		String dirPath = helper.getRequest().getSession().getServletContext().getRealPath("/");
		String fileName = "spread/chart_kind.xml";

		XMLConverter xmlConverter = new XMLConverter();
		Document doc = xmlConverter.readFile(dirPath + "/" + fileName);

		Node chartNode = null;
		if ("NA".equals(chartID)) {
			chartNode = xmlConverter.selectSingleNode(doc, "//*[@default='true']");			
		} else {
			chartNode = xmlConverter.selectSingleNode(doc, "//*[@id=" + chartID + "]");			
		}

		
		this.setChartType(chartNode.getNodeName());
		
	}


	/**
	 *  XMLiChartInfo(Seriesm[hсA̔z̃m[hȊO)Zbgj
	 * @param helper
	 * @param commonSettings
	 * @param doc JFreeChartpXML
	 */
	private void addChartInfo(RequestHelper helper, CommonSettings commonSettings, Document doc) {

		Report report = (Report)helper.getRequest().getSession().getAttribute("report");

		Element element = null;
		Node node = null;
		Text text = null;

		// XMLi[g(Chart)m[hj
		element = doc.createElement("Chart");
		Node root = doc.appendChild(element);
		
		// XMLiChartInfom[hj
		element = doc.createElement("ChartInfo");
		Node chartInfo = root.appendChild(element);

			// XMLiTitlem[hђliTextm[hjj
			element = doc.createElement("Title");
			node = chartInfo.appendChild(element);
			text = doc.createTextNode(report.getReportName());
			node.appendChild(text);
	
			// XMLiTitleColorm[hђliTextm[hjj
			element = doc.createElement("TitleColor");
			node = chartInfo.appendChild(element);
			text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartTitleColor")); //$NON-NLS-1$
			node.appendChild(text);
			
			// XMLiTypem[hђliTextm[hjj
			element = doc.createElement("Type");
			node = chartInfo.appendChild(element);
			text = doc.createTextNode(this.chartType);
			node.appendChild(text);

			// XMLiFontm[hj
			element = doc.createElement("Font");
			Node font = chartInfo.appendChild(element);
				
				// XMLiFontNamem[hђliTextm[hjj
				element = doc.createElement("FontName");
				node = font.appendChild(element);
				text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartFontName")); //$NON-NLS-1$
				node.appendChild(text);
		
				// XMLiFontStylem[hђliTextm[hjj
				element = doc.createElement("FontStyle");
				node = font.appendChild(element);
				text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartFontStyle")); //$NON-NLS-1$
				node.appendChild(text);

				// XMLiFontSizem[hђliTextm[hjj
				element = doc.createElement("FontSize");
				node = font.appendChild(element);
				text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartFontSize")); //$NON-NLS-1$
				node.appendChild(text);

			// XMLiChartSizem[hj
			element = doc.createElement("ChartSize");
			Node chartSize = chartInfo.appendChild(element);
			
				// XMLiChartHeightm[hђliTextm[hjj
				element = doc.createElement("ChartHeight");
				node = chartSize.appendChild(element);
				String chartHeight = helper.getRequest().getParameter("chartHeight");
				text = doc.createTextNode(chartHeight);
				node.appendChild(text);
	
				// XMLiChartWidthm[hђliTextm[hjj
				element = doc.createElement("ChartWidth");
				node = chartSize.appendChild(element);
				String chartWidth = helper.getRequest().getParameter("chartWidth");
				text = doc.createTextNode(chartWidth);
				node.appendChild(text);

			// XMLiChartBGColorm[hђliTextm[hjj
			element = doc.createElement("ChartBGColor");
			node = chartInfo.appendChild(element);
			text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartBGColor")); //$NON-NLS-1$
			node.appendChild(text);
	
			// XMLiPlotBGColorm[hђliTextm[hjj
			element = doc.createElement("PlotBGColor");
			node = chartInfo.appendChild(element);
			text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartPlotBGColor")); //$NON-NLS-1$
			node.appendChild(text);
	
			// XMLimultiPiePlotBGColorm[hђliTextm[hjj
			element = doc.createElement("MultiPiePlotBGColor"); //$NON-NLS-1$
			node = chartInfo.appendChild(element);
			text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartMultiPiePlotBGColor")); //$NON-NLS-1$
			node.appendChild(text);
	
			// XMLiLegendPositionm[hђliTextm[hjj
			element = doc.createElement("LegendPosition");
			node = chartInfo.appendChild(element);
			text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartLegendPosition")); //$NON-NLS-1$
			node.appendChild(text);
	
			// XMLihasToolTipm[hђliTextm[hjj
			element = doc.createElement("hasToolTip");
			node = chartInfo.appendChild(element);
			text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartHasToolTip")); //$NON-NLS-1$
			node.appendChild(text);
	
			// XMLihasPieLabelm[hђliTextm[hjj
			element = doc.createElement("hasPieLabel");
			node = chartInfo.appendChild(element);
			text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartHasPieLabel")); //$NON-NLS-1$
			node.appendChild(text);
	
			// XMLiCategorym[hj
			element = doc.createElement("Category");
			Node category = chartInfo.appendChild(element);

				// XMLiLabel̒l擾j
				String labelName = "";
				ArrayList colAxisList = report.getEdgeByType(Constants.Col).getAxisList();

				//   Col̐[v
				Iterator it = colAxisList.iterator();
				int i = 0;
				while (it.hasNext()) {
					if (i > 0) {
						labelName += "_";
					}
					labelName += ((Axis)it.next()).getName();
					i++;
				}

				
				// XMLiLabelm[hђliTextm[hjj
				element = doc.createElement("Label");
				node = category.appendChild(element);
				text = doc.createTextNode(labelName);
				node.appendChild(text);

				// XMLiLabelColorm[hђliTextm[hjj
				element = doc.createElement("LabelColor");
				node = category.appendChild(element);
				text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartCategoryLabelColor")); //$NON-NLS-1$
				node.appendChild(text);

	}


	/**
	 * JFreeChartpXMLhLgDataSetm[hсA̔z̃m[hZbg
	 */
	private void addSeriesList(RequestHelper helper, CommonSettings commonSettings, Document doc) throws SQLException {
		
		int i = 0;

		// m[h쏈p ݒ
		Element element = null;
		Element root = doc.getDocumentElement();
		Node chartInfo = root.getElementsByTagName("ChartInfo").item(0);
		
		Node node = null;
		Text text = null;

		// |[gIuWFNg擾
		Report report = (Report) helper.getRequest().getSession().getAttribute("report");		
		
		// XMLiSeriesListm[hj
		element = doc.createElement("SeriesList");
		Node seriesList = chartInfo.appendChild(element);

			
			ArrayList measureMemberList = null;
			// W[s܂͗ɂA`[g(Series`[g)łꍇAW[o[Series𐶐
			if ( (ChartXMLCreator.checkIsMultiChart(this.chartType)) && 
			      ( (this.originalMeasureEdgePosition.equals(Constants.Col)) || ((this.originalMeasureEdgePosition.equals(Constants.Row))) )) {

					measureMemberList = report.getMeasure().getAxisMemberList();

			// ȊȌꍇ́ASeries̓ftHgőIĂ郁W[o[̈
			} else {
				measureMemberList = new ArrayList();
				measureMemberList.add(report.getMeasure().getDefaultMember(this.conn));

			}

			Iterator it = measureMemberList.iterator();
			while (it.hasNext()) {
				
				// XMLiSeriesm[hj
				element = doc.createElement("Series");
				Node series = seriesList.appendChild(element);
					
					String measureName = ((MeasureMember) it.next()).getMeasureName();
					
					// XMLiLabelm[hђliTextm[hjj
					element = doc.createElement("Label");
					node = series.appendChild(element);
					text = doc.createTextNode(measureName);
					node.appendChild(text);
	
					// XMLiLabelColorm[hђliTextm[hjj
					element = doc.createElement("LabelColor");
					node = series.appendChild(element);
					text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartSeriesLabelColor")); //$NON-NLS-1$
					node.appendChild(text);

					// XMLiisAutoRangeEnablem[hђliTextm[hjj
					element = doc.createElement("isAutoRangeEnable");
					node = series.appendChild(element);
					text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartIsAutoRangeEnable")); //$NON-NLS-1$
					node.appendChild(text);


					// XMLiMaxRangem[hђliTextm[hjj
					element = doc.createElement("MaxRange");
					node = series.appendChild(element);
					text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartMaxRange")); //$NON-NLS-1$
					node.appendChild(text);
		
					// XMLiMinRangem[hђliTextm[hjj
					element = doc.createElement("MinRange");
					node = series.appendChild(element);
					text = doc.createTextNode(ChartMessages.getString("ChartXMLCreator.ChartMinRange")); //$NON-NLS-1$
					node.appendChild(text);
				
			}
		
	}

	/**
	 * JFreeChartpXMLhLgDataSetm[hсA̔z̃m[hZbg
	 */
	private void addDataSetList(RequestHelper helper, CommonSettings commonSettings, Document doc) throws SQLException {

		int i = 0;

		// m[h쏈p ݒ
		Element element = null;
		Element root = doc.getDocumentElement();
		
		Node node = null;
		Text text = null;

		// |[gIuWFNg擾
		Report report = (Report) helper.getRequest().getSession().getAttribute("report");

		// GbW
		Col col = (Col) report.getEdgeByType(Constants.Col);
		Row row = (Row) report.getEdgeByType(Constants.Row);
			
		// GbW̎Xg
		ArrayList colAxesList = col.getAxisList();
		ArrayList rowAxesList = row.getAxisList();
		ArrayList pageAxesList = report.getEdgeByType(Constants.Page).getAxisList();		

		// Zf[^擾
		// il̃tH[}bgƂĒPʂ݂̂낦鏑gpAsEEy[WŃ\[gSQL^CvwBj
		ArrayList cellDataList = CellDataManager.selectCellDatas(helper, this.conn, false, CellDataDAO.sortedSQLTypeString);


		// XMLiDataSetListm[hj
		element = doc.createElement("DataSetList");
		Node dataSetList = root.appendChild(element);

		Measure measure = report.getMeasure();
		ArrayList targetMeasures = null;
		
		// W[s܂͗ɂA`[g(Series`[g)łꍇAW[o[DataSet𐶐
		if ( (ChartXMLCreator.checkIsMultiChart(this.chartType)) && 
			  ( (this.originalMeasureEdgePosition.equals(Constants.Col)) || ((this.originalMeasureEdgePosition.equals(Constants.Row))) )) {
			targetMeasures = new ArrayList(measure.getAxisMemberList());
		// ȊȌꍇ́ADataSet͈
		} else {
			targetMeasures = new ArrayList();
			targetMeasures.add(measure.getDefaultMember(this.conn));
		}

		// ŕ\̃o̐߂B
//		String viewColIndexKeyString = helper.getRequest().getParameter("viewColIndexKey_hidden");
//		ArrayList viewColIndexKeyList = StringUtil.splitString(viewColIndexKeyString,",");
//		int viewColNumber = viewColIndexKeyList.size();
		

		// W[oPʂDataSetvf쐬
		Iterator meaIt = targetMeasures.iterator();
		while (meaIt.hasNext()) {
			MeasureMember measureMember = (MeasureMember) meaIt.next();
	
			// XMLiDataSetm[hj
			element = doc.createElement("DataSet");
			Node dataSet = dataSetList.appendChild(element);
	
	
			// Spread\̃ZPʂŁADatavfDataSetɒǉ
			// ȂAقȂ郁W[ȍꍇ͒ǉȂB
			// iFsalesW[oɑΉDataSet쐬̏ꍇAseles̃Z͒ǉ邪Acost̃Z͊܂߂ȂBj
			Iterator it = cellDataList.iterator();

			while (it.hasNext()) {

				CellData cellData = (CellData) it.next();
				
				// W[s܂͗ɂA`[g(Series`[g)łꍇ
				// DataSet̓W[ɍ쐬邪AcellData쐬̃W[ȊÕf[^łꍇ́Ao͂Ȃ
				if ( (ChartXMLCreator.checkIsMultiChart(this.chartType)) && 
					  ( (this.originalMeasureEdgePosition.equals(Constants.Col)) || ((this.originalMeasureEdgePosition.equals(Constants.Row))) )) {

					if (!measureMember.getUniqueName().equals(cellData.getMeasureMemberUniqueName()) ) {
						continue;
					}
				}			
				
				// XMLiDatam[hj
				element = doc.createElement("Data");
				Node data = dataSet.appendChild(element);
	
					// ZɑΉẽo[IDі̂̑gݍ킹擾
					LinkedHashMap colRowAxisIDMemKeys = new LinkedHashMap();
					colRowAxisIDMemKeys.putAll(cellData.getColCoordinates().getAxisIdMemKeyMap());
					colRowAxisIDMemKeys.putAll(cellData.getRowCoordinates().getAxisIdMemKeyMap());

					// ZɑΉe񎲂̃o[IDі̂̑gݍ킹擾
					// iȉꍇ́AeiIDі̂gݍ킹Bj
					String axisMemberIDs = "";
					String axisMemberNames = "";
					for (i = 0; i < colAxesList.size(); i++) {
						Axis axis = (Axis) colAxesList.get(i);
	
						if (i != 0) {
							axisMemberIDs += "_";
							axisMemberNames += "_";
						}

						// o[ID擾
						String memberKey = (String)colRowAxisIDMemKeys.get(Integer.valueOf(axis.getId()));
						axisMemberIDs += memberKey;

						// o[̂擾(Ԏ̏ꍇFOl[AȊȌꍇ̓V[gl[Ol[̂ǂ炩w肳Ă)
						AxisMember axisMember = axis.getAxisMemberByUniqueName(memberKey);
						String axisMemberName = axisMember.getSpecifiedDisplayName(axis);
						if (axis instanceof Dimension) {
							if (((Dimension)axis).isTimeDimension()) {
								if("selectedName".equals(ChartMessages.getString("ChartXMLCreator.ChartTimeDimMemberNameType"))) {
									axisMemberName = ((DimensionMember)axisMember).getSpecifiedDisplayName(axis);
								} else if ("UniqueName".equals(ChartMessages.getString("ChartXMLCreator.ChartTimeDimMemberNameType"))) {
									axisMemberName = TimeDimensionInfo.timekeyToName(axisMember.getUniqueName());										
								}
							}
						}
						axisMemberNames += axisMemberName;

					}
					
	
					// XMLiCategoryAxisCodem[hђliTextm[hjj
					element = doc.createElement("CategoryAxisCode");
					node = data.appendChild(element);
					text = doc.createTextNode(axisMemberIDs);
					node.appendChild(text);
				
					// XMLiCategoryAxisNamem[hђliTextm[hjj
					element = doc.createElement("CategoryAxisName");
					node = data.appendChild(element);
					text = doc.createTextNode(axisMemberNames);
					node.appendChild(text);
	
					// ZɑΉes̃o[IDі̂擾
					// iȉꍇ́AeiIDі̂gݍ킹Bj
					axisMemberIDs = "";
					axisMemberNames = "";
					for (i = 0; i < rowAxesList.size(); i++) {
						Axis axis = (Axis) rowAxesList.get(i);
	
						if (i != 0) {
							axisMemberIDs   += "_";
							axisMemberNames += "_";
						}

						// o[ID擾
						String memberKey = (String)colRowAxisIDMemKeys.get(Integer.valueOf(axis.getId()));
						axisMemberIDs += memberKey;

						// o[̂擾(Ԏ̏ꍇFOl[AȊȌꍇ̓V[gl[Ol[̂ǂ炩w肳Ă)
						AxisMember axisMember = axis.getAxisMemberByUniqueName(memberKey);
						String axisMemberName = axisMember.getSpecifiedDisplayName(axis);
						if (axis instanceof Dimension) {
							if (((Dimension)axis).isTimeDimension()) {
								if("selectedName".equals(ChartMessages.getString("ChartXMLCreator.ChartTimeDimMemberNameType"))) {
									axisMemberName = ((DimensionMember)axisMember).getSpecifiedDisplayName(axis);
								} else if ("UniqueName".equals(ChartMessages.getString("ChartXMLCreator.ChartTimeDimMemberNameType"))) {
									axisMemberName = TimeDimensionInfo.timekeyToName(axisMember.getUniqueName());										
								}
							} 
						}
						axisMemberNames += axisMemberName;

					}
	
					// XMLiValueAxisCodem[hђliTextm[hjj
					element = doc.createElement("ValueAxisCode");
					node = data.appendChild(element);
					text = doc.createTextNode(axisMemberIDs);
					node.appendChild(text);
	
					// XMLiValueAxisNamem[hђliTextm[hjj
					element = doc.createElement("ValueAxisName");
					node = data.appendChild(element);
					text = doc.createTextNode(axisMemberNames);
					node.appendChild(text);
					
					// XMLiValuem[hђliTextm[hjj
					element = doc.createElement("Value");
					node = data.appendChild(element);
					text = doc.createTextNode(cellData.getValue());
					node.appendChild(text);				

			}

		}

	}


	/**
	 * ~Ot̏ꍇAŏ̍ŝ݂\ΏۂƂ
	 * iZbVviewRowXKeyList_hiddenAviewRowIndexKey_hiddenAŏ̍sIndex,Keŷ݂Ƃj
	 */
	private void setFirstRowOnly(RequestHelper helper) {
		
		String viewRowIndexKeyList = (String)helper.getRequest().getSession().getAttribute("viewRowIndexKey_hidden");
		ArrayList viewRowIndexKeyString  = StringUtil.splitString(viewRowIndexKeyList, ","); // viewRowIndexKeyStringF̔z(ex:u0:0;;v)	
		
		ArrayList viewRow0IndexKey = StringUtil.splitString((String)viewRowIndexKeyString.get(0),":");
		String viewRow0Index       = (String)viewRow0IndexKey.get(0); // ŏ̍s̃CfbNX
		String viewRow0KeysString  = (String)viewRow0IndexKey.get(1); // ŏ̍s̃o[L[̃Xgiex:u0;;vj
		
		ArrayList viewRow0KeysList = StringUtil.splitString(viewRow0KeysString,";"); // ŏ̍s̃o[L[̔z

		// viewRowIndexKey_hidden ŏ̍ŝ݂̏ōXV
		helper.getRequest().getSession().setAttribute("viewRowIndexKey_hidden", viewRowIndexKeyString.get(0));
		
		// viewRowXKeyList_hidden ŏ̍ŝ݂̏ōXV
		for(int i=0; i<viewRow0KeysList.size(); i++) {
			helper.getRequest().getSession().setAttribute("viewRow"+i+"KeyList_hidden", viewRow0KeysList.get(i));
		}
		
	}


	// *** setter ***
	
	private void setChartType(String chartType) {
		this.chartType = chartType;
	}

	// *** getter ***
	private String getChartType() {
		return this.chartType;
	}


}
