/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFDisplaySelecterBodyCommand.java
 *  Fw肳ꂽIuWFNgɎo[ZbgAZN^{fB[t[\y[WdispatchNXłB
 *
 *  쐬: 2004/01/09
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.ServletException;

import openolap.viewer.Dimension;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionMemberDAO;

/**
 *  NXFDisplaySelecterBodyCommand<br>
 *  Fw肳ꂽIuWFNgɎo[ZbgAZN^{fB[t[\y[WdispatchNXłB
 */
public class DisplaySelecterBodyCommand implements Command {

	// ********** CX^Xϐ **********

	/** RequestHelperIuWFNg */
	private RequestHelper requestHelper = null;

	// ********** \bh **********

	/**
	 * "dimNumber"p[^[ŗ^ꂽIDfBV̏ꍇA<br>
	 * IuWFNgɎo[ZbgAZN^{fB[t[\y[WdispatchB<br>
	 * W[̏ꍇ́AɃZN^{fB[\y[WdispatchB
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

			this.requestHelper = helper;
			Report report = (Report) this.requestHelper.getRequest().getSession().getAttribute("report");

			// fBV̏ꍇAo[擾iW[̏ꍇReportIuWFNgɎ擾ς݁j
			String AxisID = this.requestHelper.getRequest().getParameter("dimNumber");
			if(!AxisID.equals(Constants.MeasureID)) {
				Dimension dim = (Dimension) report.getAxisByID(AxisID);
	
				Connection conn = null;
				DAOFactory daoFactory = DAOFactory.getDAOFactory();
				conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
												(String)helper.getRequest().getSession().getAttribute("searchPathName"));
	
				try {
					DimensionMemberDAO dimMemberDAO =  daoFactory.getDimensionMemberDAO(conn);
					ArrayList dimMemberList = dimMemberDAO.selectDimensionMembers(dim,		// o擾fBV
																				  null,	// short_nameɂiݏ
																				  null,	// long_nameɂiݏ
																				  null, 	// xɂi
																				  null);	// ΏۃL[Xg
					dim.setAxisMemberList(dimMemberList);
				} catch (SQLException e) {
					e.printStackTrace();
				} catch (Exception e) { 
					e.printStackTrace();
				} finally {
					if(conn != null){
						try {
							conn.close();
						} catch (SQLException e) {
							e.printStackTrace();
						}
					}
				}
			}
			return "/spread/SelecterBody.jsp";
	}
}
