/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFGetReportInfoCommand.java
 *  F|[gXML`ŏo͂NXłB
 *
 *  쐬: 2004/01/09
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import openolap.viewer.Axis;
import openolap.viewer.AxisLevel;
import openolap.viewer.Dimension;
import openolap.viewer.Edge;
import openolap.viewer.Measure;
import openolap.viewer.MeasureMember;
import openolap.viewer.Report;
import openolap.viewer.Security;
import openolap.viewer.User;
import openolap.viewer.chart.ChartXMLCreator;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.CommonUtils;
import openolap.viewer.common.StringUtil;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionMemberDAO;

/**
 *  NXFGetReportInfoCommand<br>
 *  F|[gXML`ŏo͂NXłB
 */
public class GetReportInfoCommand implements Command {

	// ********** CX^Xϐ **********

	/** RequestHelperIuWFNg */
	private RequestHelper requestHelper = null;

	// ********** \bh **********

	/**
	 * |[gXML`ŏo͂܂B<br>
	 * JSPdispatchs킸ɒXMLo͂邽߁Anull߂B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return null
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

			this.requestHelper = helper;
			HttpServletRequest request = this.requestHelper.getRequest();
			HttpSession session = this.requestHelper.getRequest().getSession();

			Report report = (Report) session.getAttribute("report");
			User user = (User) session.getAttribute("user");

			Connection conn = null;
			DAOFactory daoFactory = DAOFactory.getDAOFactory();
			conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
											(String)helper.getRequest().getSession().getAttribute("searchPathName"));

			try {

				// XMLo
				this.outputXML(helper, report, user, conn);

			} catch (SQLException e) {
				e.printStackTrace();
			} catch (Exception e) { 
				e.printStackTrace();
			} finally {
				if(conn != null){
					try {
						conn.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
			}

			return null;

	}

	// ********** private \bh **********

	/**
	 * ftHgo[L[null̏ꍇA"NA"ɕϊB
	 * @param defaultMemKey ftHgo[L[
	 * @return ftHgo[L[
	 */
	private String changeDefaultMemberKey(String defaultMemKey) {
		if(defaultMemKey == null) { 
			return "NA";
		} else {
			return defaultMemKey;
		}
	}

	/**
	 * |[gXML`ŏo͂܂B
	 * @param helper RequestHelperIuWFNg
	 * @param report |[gIuWFNg
	 * @param user [U[IuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception IOException ɗO
	 * @exception SQLException |[g擾ɗO
	 */
	private void outputXML(RequestHelper helper, Report report, User user, Connection conn) throws IOException, SQLException {

		this.requestHelper.getResponse().setContentType("text/xml; charset=Shift_JIS");
		PrintWriter out = this.requestHelper.getResponse().getWriter();

		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		DimensionMemberDAO dimMemberDAO = daoFactory.getDimensionMemberDAO(conn);

		// o͊Jn
		out.println("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
		out.println("<root>");
			out.println("<OlapInfo>");
				out.println("<ReportInfo>");
					out.println("<Report>");
						out.println("<ReportID>");
							out.println(report.getReportID());
						out.println("</ReportID>");
						out.println("<ReportName>");
							out.println(report.getReportName());
						out.println("</ReportName>");
						out.println("<isNewReport>");
							out.println(CommonUtils.boolToFLG(report.isNewReport()));
						out.println("</isNewReport>");
						out.println("<displayScreenType>");		// ʕX^C
							out.println(report.getDisplayScreenType());	// (0:Sʕ\i\jA1:Sʕ\iOtjA2:ci\AOt))
						out.println("</displayScreenType>");
						out.println("<currentChartID>");		// \̃OtID
							ChartXMLCreator chartXMLCreator = new ChartXMLCreator();
							String chartID = null;
							if("NA".equals(report.getCurrentChart())){
								chartID = report.getCurrentChart();
							} else {
								chartID = chartXMLCreator.chartNameToId(ChartXMLCreator.getChartXMLFilePath(helper), report.getCurrentChart());
							}
							out.println(chartID);
						out.println("</currentChartID>");
						out.println("<colorType>");		// Fݒ̃^Cvi1FhԂA2FnCCgj
							out.println(report.getColorType());
						out.println("</colorType>");
					out.println("</Report>");
				out.println("</ReportInfo>");
				out.println("<CubeInfo>");
					out.println("<Cube>");
						out.println("<CubeName>");
							out.println(report.getCube().getCubeName());
						out.println("</CubeName>");
					out.println("</Cube>");
				out.println("</CubeInfo>");

			out.println("<AxesInfo>");


			// ̔zuꏊo

			Iterator edgeIt = report.getEdgeList().iterator();
			while (edgeIt.hasNext()) {
				Edge edge = (Edge) edgeIt.next();
				Iterator axisIt = edge.getAxisList().iterator();
				out.println(StringUtil.addStartTAGMark(edge.getPosition()));
				while (axisIt.hasNext()) {
					Axis axis = (Axis) axisIt.next();
					out.println("<HierarchyID>" + axis.getId()  + "</HierarchyID>");
				}
				out.println(StringUtil.addEndTAGMark(edge.getPosition()));
			}

			// AxisID̏ŏo
			ArrayList axisList = report.getAxisOrderByID();
			Iterator axisIt = axisList.iterator();
			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();

				out.println("<HierarchyInfo name=\"" + axis.getName() + "\" id=\""+ axis.getId() +"\">");
				out.println("<DefaultMemberKey>"+ changeDefaultMemberKey(axis.getDefaultMemberKey()) +"</DefaultMemberKey>");
				out.println("<Comment>" + StringUtil.changeNullToEmpty(axis.getComment()) + "</Comment>");

				// o[̕\^Cvo
				String displayMemberNameType = null;
				if(axis instanceof Dimension) {
					displayMemberNameType = dimMemberDAO.transferMemberDisplayTypeFromModelToXML(((Dimension)axis).getDispMemberNameType());
				} else {
					displayMemberNameType = dimMemberDAO.transferMemberDisplayTypeFromModelToXML(Dimension.DISP_SHORT_NAME);
				}
				out.println("<DisplayMemberType>" + displayMemberNameType + "</DisplayMemberType>");
					
				Iterator levelIt = axis.getAxisLevelList().iterator();
				while (levelIt.hasNext()) {
					AxisLevel axisLevel = (AxisLevel) levelIt.next();
					out.println("<Level>");
						out.println("<LNum>");
							out.println(axisLevel.getLevelNumber());
						out.println("</LNum>");
						out.println("<LName>");
							out.println(axisLevel.getName());
						out.println("</LName>");
						out.println("<Comment>");
							out.println(StringUtil.changeNullToEmpty(axisLevel.getComment()));
						out.println("</Comment>");
					out.println("</Level>");
				}
				out.println("</HierarchyInfo>");

			}

			out.println("</AxesInfo>");
		out.println("</OlapInfo>");

		// [Uo
		out.println("<UserInfo>");
			out.println("<UserName>");
				out.println(user.getName());
			out.println("</UserName>");
			out.println("<isAdmin>");
				out.println(CommonUtils.boolToFLG(user.isAdmin()));
			out.println("</isAdmin>");
			out.println("<isPersonalReportSavable>");
				out.println(CommonUtils.boolToFLG(user.isPersonalReportSavable()));
			out.println("</isPersonalReportSavable>");
			out.println("<isThisReportExportable>");
					Security security = (Security)helper.getRequest().getSession().getAttribute("security");
					out.println(CommonUtils.boolToFLG(security.isReportExportable()));
			out.println("</isThisReportExportable>");
			out.print("<exportType>");
				out.print(user.getExportFileType());
			out.println("</exportType>");
		out.println("</UserInfo>");

		// oo
		out.println("<Axes>");

			// fBVoo
			dimMemberDAO.outputDimensionMemberAsXML(report,out);

			// W[o
			Measure measure = report.getMeasure();
			Iterator meaMemIt = measure.getAxisMemberList().iterator();
			out.println("<Members name=\"" + measure.getName() + "\" id=\"" + measure.getId() +  "\">");

			while (meaMemIt.hasNext()) {
				MeasureMember measureMember = (MeasureMember) meaMemIt.next();

				if(!measureMember.isSelected()) {	// ZN^ŕ\ΏۊOƂĂ郁o͏o͂Ȃ
					continue;
				}

				out.println("<Member id=\"" + measureMember.getId() + "\">");
				out.println("    <UName>" + measureMember.getUniqueName() + "</UName>");
				out.println("    <Code>" + measureMember.getMeasureName() + "</Code>");
				out.println("    <Caption>" + measureMember.getMeasureName() + "</Caption>");
				out.println("    <Caption2>" + measureMember.getMeasureName() + "</Caption2>");
				out.println("    <LNum>1</LNum>");
				out.println("    <isDrilled>false</isDrilled>");
				out.println("    <isLeaf>true</isLeaf>");
				out.println("</Member>");

			}
			out.println("</Members>");

		out.println("</Axes>");
		out.println("</root>");
	}

}
