/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFInitializeStatus.java
 *  FAvP[V̏sNXłB
 *
 *  쐬: 2004/01/12
 */
package openolap.viewer.controller;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import openolap.viewer.common.CommonSettings;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.MeasureMemberTypeDAO;

/**
 *  NXFInitializeStatus<br>
 *  FAvP[V̏sNXłB
 */
public class InitializeStatus {

	/**
	 * AvP[V̏sAʐݒServletContext֓o^B
	 * @param context ServletContextIuWFNg
	 */
	public static void initApStatus(HttpServletRequest request, ServletContext context) {

		Connection conn = null;

		if ( context.getAttribute("apCommonSettings") == null ) {

			DAOFactory daoFactory = DAOFactory.getDAOFactory();
			if (conn == null){
				conn = daoFactory.getConnection((String)request.getSession().getAttribute("connectionPoolName"),
												(String)request.getSession().getAttribute("searchPathName"));
			}

			CommonSettings commonSettings = CommonSettings.getCommonSettings();

			try {
				MeasureMemberTypeDAO measureMemberTypeDAO = daoFactory.getMeasureMemberTypeDAO(conn);
				ArrayList measureMemberTypeList = measureMemberTypeDAO.getMeasureMemberTypeList();

				commonSettings.addMeasureMemberTypeList(measureMemberTypeList);

				// ServletContext֓o^
				context.setAttribute("apCommonSettings", commonSettings);
				
			} catch (SQLException e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					if (conn != null) {
						conn.close();
					}
				} catch (SQLException e1) {
					e1.printStackTrace();
				}
			}
		}
	}
}
