/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFLoginCommand.java
 *  FOCsNXłB
 *
 *  쐬: 2004/01/30
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import openolap.viewer.User;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.UserDAO;

/**
 *  NXFLoginCommand<br>
 *  FOCsNXłB
 */
public class LoginCommand implements Command {

	// ********** CX^Xϐ **********

	/** RequestHelperIuWFNg */
	private RequestHelper requestHelper = null;

	// ********** \bh **********

	/**
	 * OCsB<br>
	 * ^ꂽu[U[vAupX[hvp[^DBɕۑĂrAꍇ̓OCƂB<br>
	 * OCƁA[U[IuWFNgZbVɓo^Auc[ƃz[vʂփ_CNgy[W߂B<br>
	 * OCs̏ꍇ́AOCsXe[^XŃOCy[W߂B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

		String nextPage = null;

		this.requestHelper = helper;
		HttpServletRequest request = this.requestHelper.getRequest();
		HttpSession session = this.requestHelper.getRequest().getSession();

		// [U`FbN
		String userName = request.getParameter("user");
		String password = request.getParameter("password");

		if ( (userName == null) && (password == null) ) {
			return "/jsp/login.jsp";
		}

		// [UF؊Jn
		Connection conn = null;
		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
										(String)helper.getRequest().getSession().getAttribute("searchPathName"));
	
		UserDAO userDAO =  daoFactory.getUserDAO(conn);
		User user = null;
		try {
			user = userDAO.getUser(userName, password);
		} catch (SQLException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				e1.printStackTrace();
			}
		}

		if ( user == null ) {
			nextPage = "/login.jsp";
			request.setAttribute("loginResult", "failed");
		} else {

			// UserIuWFNgSessionɓo^
			request.getSession().setAttribute("user", user);
			nextPage = "/spread/redirectTo.jsp";
			request.setAttribute("redirectTo", "/OpenOLAP.html");
		}

		return nextPage;
	}

}
