/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFRequestHelper.java
 *  FNCAg̃NGXgƏRtNXłB
 *
 *  쐬: 2004/01/05
 */

package openolap.viewer.controller;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *  NXFRegistSelecterInfoCommand
 *  FNCAg̃NGXgƏRtNXłB
 */
public class RequestHelper {

	// ********** CX^Xϐ **********

	/** HttpServletRequestIuWFNg */
	HttpServletRequest request = null;

	/** HttpServletResponseIuWFNg */
	HttpServletResponse response = null;

	/** ServletConfigIuWFNg */
	ServletConfig config = null;

	// ********** RXgN^ **********

	/**
	 * NCAg̃NGXgƏRtIuWFNg𐶐܂B
	 */
	public RequestHelper (HttpServletRequest request, HttpServletResponse response, ServletConfig config) {
		this.request = request;
		this.response = response;
		this.config = config;
	}

	// ********** \bh **********

	/**
	 * ݒ̓o^ӖASpread̍ĕ\sy[W߂B
	 * @return NGXgɑΉ鏈sIuWFNgB
	 */
	public Command getCommand() {

		Command command = null;
		String action = this.request.getParameter("action");

		// OCς݂`FbN
		if ( request.getSession().getAttribute("user") == null) {
			if (!action.equals("login")) {
				return new InvalidateSessionCommand();
			}
		}


		if (action != null){

			// |[g\
			if (action.equals("displayNewReport")) {		//|[g\
				command = new DisplayNewReportCommand();
			} else if (action.equals("getReportHeader")) {	//|[gIuWFNgуwb_
				command = new GetReportHeaderCommand();
			} else if(action.equals("loadClientInitAct")){	//|[g擾R}h擾
															// |[giXMLj̍č쐬Spread\sȂ
															// ^[Qbgt[́Ainfo_area
				command = new LoadClientInitActCommand();
			} else if (action.equals("getReportInfo")){	//|[g(|[gAAo)
				command = new GetReportInfoCommand();
			} else if (action.equals("renewHtmlAct")) {	//NCAgĂ郌|[giXMLjƂɁA
															//HTMLSpread\sȂ

				command = new RenewHtmlActCommand();

			// Fݒ
			} else if (action.equals("loadColorAct")){		//FݒR}h擾
				command = new LoadColorActCommand();
			} else if (action.equals("getColorInfo")){		//Fݒ擾
				command = new GetColorInfoCommand(); 

			// nCCg
			} else if (action.equals("displayHighLight")){	
				command = new DisplayHighLightCommand();
			} else if (action.equals("displayHighLightHeader")){	
				command = new DisplayHighLightHeaderCommand();
			} else if (action.equals("displayHighLightBody")){	
				command = new DisplayHighLightBodyCommand();

			// FݒZbV֓o^
			} else if (action.equals("registColorOnly")) {
				command = new RegistColorOnlyCommand();	

			// |[gւ̃f[^\
			} else if (action.equals("loadDataAct")) {		//|[gւ̃f[^}R}h擾
															//(\AXCXAh_E)
				command = new LoadDataActCommand();
			} else if (action.equals("getDataInfo")) {		//|[g̃f[^̏W擾
				command = new GetDataInfoCommand();

			// ZN^
			} else if (action.equals("displaySelecter")) {			//ZN^[ t[\
				command = new DisplaySelecterCommand();
			} else if (action.equals("displaySelecterHeader")){	//ZN^[ wb_[\
				command = new DisplaySelecterHeaderCommand();
			} else if (action.equals("displaySelecterBody")){		//ZN^[ {fB[\
				command = new DisplaySelecterBodyCommand();
			} else if (action.equals("getAxisMemberInfoByAxisID")) {// oXML擾
				command = new GetAxisMemberInfoByAxisIDCommand();				
			} else if (action.equals("registClientReportStatus")){	//NCAg̃|[gT[o[̃fɔfii͂Ȃj
				command = new RegistSelecterInfoCommand();
			} else if (action.equals("searchDimensionMember")){	//o(ZN^)
				command = new SearchDimensionMemberCommand();

			// |[gۑ
			} else if (action.equals("saveClientReportStatus")){	//NCAg̃|[gi
				command = new SaveClientReportStatusCommand();

			// OC
			} else if (action.equals("login")) {
				command = new LoginCommand();
			
			// OAEg
			} else if (action.equals("logout")) {	// OAEgs
				command = new LogoutCommand();

			// GNX|[g
			} else if (action.equals("exportReport")) {
				command = new ExportReportCommand();
			
			// Ot\
			} else if (action.equals("getChartInfo")) {
				command = new GetChartInfoCommand();
			
			// |[g\sbZ[W	
			} else if (action.equals("getCannotDispReportMSG")) {
				command = new GetCannotDispReportMSGCommand();
			}

		}
		
		return command;

	}


	/**
	 * NCAg瑗MꂽNGXg킷IuWFNg߂B
	 * @return NGXg킷IuWFNg
	 */
	public HttpServletRequest getRequest() {
		return request;
	}

	/**
	 * NCAg֕ԐM郊NGXg킷IuWFNg߂B
	 * @return X|X킷IuWFNgB
	 */
	public HttpServletResponse getResponse() {
		return response;
	}

	/**
	 * Servlet̐ݒ킷IuWFNg߂B
	 * @return Servlet̐ݒ킷IuWFNg
	 */
	public ServletConfig getConfig() {
		return config;
	}

}

