<%@ page language="java"
	contentType="text/xml;charset=Shift_JIS"
	import="java.util.*,java.io.*,openolap.viewer.Report,openolap.viewer.Color"
%><%!
// ********************************************************
// Function
// ********************************************************
	private void outColorInfo( ArrayList colorList, JspWriter out ) throws IOException {

		Iterator colorIt = colorList.iterator();

		while (colorIt.hasNext()) {
			Color color = (Color) colorIt.next();
			out.println("<Color>");

				TreeMap indexTree = color.getAxisIDAndMemberKeyMap();
				Iterator indexIt = indexTree.keySet().iterator();
				out.println("<Coordinates>");
				while (indexIt.hasNext()) {
					Integer axisId = (Integer) indexIt.next();
					out.println("<Axis id='" + axisId + "'>");
						out.println("<Key>" + (String)indexTree.get(axisId) + "</Key>");
					out.println("</Axis>");
				}
				out.println("</Coordinates>");

				// HTMLColor
				out.println("<HTMLColor>");
					out.println(color.getHtmlColor());
				out.println("</HTMLColor>");
			out.println("</Color>");
		}
	
	}

%><%

	Report report = (Report)session.getAttribute("report");
	ArrayList headerColorList = report.getHeaderColorList();
	ArrayList spreadColorList = report.getSpreadColorList();

%><?xml version="1.0" encoding="Shift_JIS"?>
<ColorInfo>
    <HeaderColor>
<%
		outColorInfo(headerColorList, out);
%>
    </HeaderColor>
    <SpreadColor>
<%
		outColorInfo(spreadColorList, out);
%>
    </SpreadColor>
</ColorInfo>
