/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYZToolTipGenerator;
import org.jfree.data.XYZDataset;
import org.jfree.util.ObjectUtils;

public class StandardXYZToolTipGenerator
extends StandardXYToolTipGenerator
implements XYZToolTipGenerator {
    public static final String DEFAULT_TOOL_TIP_FORMAT = "{0}: ({1}, {2}, {3})";
    private NumberFormat zFormat;
    private DateFormat zDateFormat;

    public StandardXYZToolTipGenerator() {
        this(DEFAULT_TOOL_TIP_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public StandardXYZToolTipGenerator(String formatString, NumberFormat xFormat, NumberFormat yFormat, NumberFormat zFormat) {
        super(formatString, xFormat, yFormat);
        if (zFormat == null) {
            throw new IllegalArgumentException("Null 'zFormat' argument.");
        }
        this.zFormat = zFormat;
    }

    public StandardXYZToolTipGenerator(String formatString, DateFormat xFormat, DateFormat yFormat, DateFormat zFormat) {
        super(formatString, xFormat, yFormat);
        if (zFormat == null) {
            throw new IllegalArgumentException("Null 'zFormat' argument.");
        }
        this.zDateFormat = zFormat;
    }

    public NumberFormat getZFormat() {
        return this.zFormat;
    }

    public DateFormat getZDateFormat() {
        return this.zDateFormat;
    }

    public String generateToolTip(XYZDataset data, int series, int item) {
        String result = data.getSeriesName(series) + ": ";
        Number x = data.getXValue(series, item);
        result = result + "x: " + this.getXFormat().format(x);
        Number y = data.getYValue(series, item);
        result = result + "y: " + this.getYFormat().format(y);
        Number z = data.getZValue(series, item);
        result = z != null ? result + ", z: " + this.zFormat.format(z) : result + ", z: null";
        return result;
    }

    protected Object[] createItemArray(XYZDataset dataset, int series, int item) {
        Object[] result = new Object[4];
        result[0] = dataset.getSeriesName(series);
        Number x = dataset.getXValue(series, item);
        DateFormat xf = this.getXDateFormat();
        result[1] = xf != null ? xf.format(x) : this.getXFormat().format(x);
        Number y = dataset.getYValue(series, item);
        DateFormat yf = this.getYDateFormat();
        result[2] = yf != null ? yf.format(y) : this.getYFormat().format(y);
        Number z = dataset.getZValue(series, item);
        result[3] = this.zDateFormat != null ? this.zDateFormat.format(z) : this.zFormat.format(z);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StandardXYZToolTipGenerator && super.equals(obj)) {
            StandardXYZToolTipGenerator generator = (StandardXYZToolTipGenerator)obj;
            boolean b0 = ObjectUtils.equal((Object)this.zFormat, (Object)generator.zFormat);
            boolean b1 = ObjectUtils.equal((Object)this.zDateFormat, (Object)generator.zDateFormat);
            return b0 && b1;
        }
        return false;
    }
}

