/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PieLabelDistributor;
import org.jfree.chart.plot.PieLabelRecord;
import org.jfree.chart.plot.PiePlotState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.PieDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBox;
import org.jfree.text.TextMeasurer;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PaintList;
import org.jfree.util.Rotation;
import org.jfree.util.ShapeUtils;
import org.jfree.util.StrokeList;

public class PiePlot
extends Plot
implements Cloneable,
Serializable {
    public static final double DEFAULT_INTERIOR_GAP = 0.25;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final Paint DEFAULT_LABEL_BACKGROUND_PAINT = new Color(255, 255, 192);
    public static final Paint DEFAULT_LABEL_OUTLINE_PAINT = Color.black;
    public static final Stroke DEFAULT_LABEL_OUTLINE_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_LABEL_SHADOW_PAINT = Color.lightGray;
    public static final double DEFAULT_MINIMUM_ARC_ANGLE_TO_DRAW = 1.0E-5;
    private PieDataset dataset;
    private int pieIndex;
    private double interiorGap;
    private boolean circular;
    private double startAngle;
    private Rotation direction;
    private transient Paint sectionPaint;
    private PaintList sectionPaintList;
    private transient Paint baseSectionPaint;
    private transient Paint sectionOutlinePaint;
    private PaintList sectionOutlinePaintList;
    private transient Paint baseSectionOutlinePaint;
    private transient Stroke sectionOutlineStroke;
    private StrokeList sectionOutlineStrokeList;
    private transient Stroke baseSectionOutlineStroke;
    private transient Paint shadowPaint = Color.gray;
    private double shadowXOffset = 4.0;
    private double shadowYOffset = 4.0;
    private ObjectList explodePercentages;
    private PieSectionLabelGenerator labelGenerator;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient Paint labelBackgroundPaint;
    private transient Paint labelOutlinePaint;
    private transient Stroke labelOutlineStroke;
    private transient Paint labelShadowPaint;
    private double maximumLabelWidth = 0.2;
    private double labelGap = 0.05;
    private double labelLinkMargin = 0.05;
    private transient Paint labelLinkPaint = Color.black;
    private transient Stroke labelLinkStroke = new BasicStroke(0.5f);
    private PieToolTipGenerator toolTipGenerator;
    private PieURLGenerator urlGenerator;
    private boolean ignoreNullValues = false;
    private double minimumArcAngleToDraw;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private static final LogContext LOGGER = Log.createContext((Class)(class$org$jfree$chart$plot$PiePlot == null ? (class$org$jfree$chart$plot$PiePlot = PiePlot.class$("org.jfree.chart.plot.PiePlot")) : class$org$jfree$chart$plot$PiePlot));
    static /* synthetic */ Class class$org$jfree$chart$plot$PiePlot;

    public PiePlot() {
        this(null);
    }

    public PiePlot(PieDataset dataset) {
        this.dataset = dataset;
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        this.pieIndex = 0;
        this.interiorGap = 0.25;
        this.circular = true;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.minimumArcAngleToDraw = 1.0E-5;
        this.sectionPaint = null;
        this.sectionPaintList = new PaintList();
        this.baseSectionPaint = null;
        this.sectionOutlinePaint = null;
        this.sectionOutlinePaintList = new PaintList();
        this.baseSectionOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.sectionOutlineStroke = null;
        this.sectionOutlineStrokeList = new StrokeList();
        this.baseSectionOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.explodePercentages = new ObjectList();
        this.labelGenerator = new StandardPieItemLabelGenerator();
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.labelBackgroundPaint = DEFAULT_LABEL_BACKGROUND_PAINT;
        this.labelOutlinePaint = DEFAULT_LABEL_OUTLINE_PAINT;
        this.labelOutlineStroke = DEFAULT_LABEL_OUTLINE_STROKE;
        this.labelShadowPaint = DEFAULT_LABEL_SHADOW_PAINT;
        this.toolTipGenerator = null;
        this.urlGenerator = null;
    }

    public PieDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(PieDataset dataset) {
        PieDataset existing = this.dataset;
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.dataset = dataset;
        if (dataset != null) {
            this.setDatasetGroup(dataset.getGroup());
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public int getPieIndex() {
        return this.pieIndex;
    }

    public void setPieIndex(int index) {
        this.pieIndex = index;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = direction;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double percent) {
        if (percent < 0.0 || percent > 0.4) {
            throw new IllegalArgumentException("PiePlot.setInteriorGapPercent(double): percentage outside valid range.");
        }
        if (this.interiorGap != percent) {
            this.interiorGap = percent;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean flag) {
        this.setCircular(flag, true);
    }

    public void setCircular(boolean circular, boolean notify) {
        this.circular = circular;
        if (notify) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getSectionPaint() {
        return this.sectionPaint;
    }

    public void setSectionPaint(Paint paint) {
        this.sectionPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionPaint(int section) {
        if (this.sectionPaint != null) {
            return this.sectionPaint;
        }
        Paint result = this.sectionPaintList.getPaint(section);
        if (result == null) {
            DrawingSupplier supplier = this.getDrawingSupplier();
            if (supplier != null) {
                Paint p = supplier.getNextPaint();
                this.sectionPaintList.setPaint(section, p);
                result = p;
            } else {
                result = this.baseSectionPaint;
            }
        }
        return result;
    }

    public void setSectionPaint(int section, Paint paint) {
        this.sectionPaintList.setPaint(section, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSectionPaint() {
        return this.baseSectionPaint;
    }

    public void setBaseSectionPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionOutlinePaint() {
        return this.sectionOutlinePaint;
    }

    public void setSectionOutlinePaint(Paint paint) {
        this.sectionOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionOutlinePaint(int section) {
        if (this.sectionOutlinePaint != null) {
            return this.sectionOutlinePaint;
        }
        Paint result = this.sectionOutlinePaintList.getPaint(section);
        if (result == null) {
            result = this.baseSectionOutlinePaint;
        }
        return result;
    }

    public void setSectionOutlinePaint(int section, Paint paint) {
        this.sectionOutlinePaintList.setPaint(section, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSectionOutlinePaint() {
        return this.baseSectionOutlinePaint;
    }

    public void setBaseSectionOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSectionOutlineStroke() {
        return this.sectionOutlineStroke;
    }

    public void setSectionOutlineStroke(Stroke stroke) {
        this.sectionOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSectionOutlineStroke(int section) {
        if (this.sectionOutlineStroke != null) {
            return this.sectionOutlineStroke;
        }
        Stroke result = this.sectionOutlineStrokeList.getStroke(section);
        if (result == null) {
            result = this.baseSectionOutlineStroke;
        }
        return result;
    }

    public void setSectionOutlineStroke(int section, Stroke stroke) {
        this.sectionOutlineStrokeList.setStroke(section, stroke);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getBaseSectionOutlineStroke() {
        return this.baseSectionOutlineStroke;
    }

    public void setBaseSectionOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSectionOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double offset) {
        this.shadowXOffset = offset;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double offset) {
        this.shadowYOffset = offset;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getExplodePercent(int section) {
        Number percent;
        double result = 0.0;
        if (this.explodePercentages != null && (percent = (Number)this.explodePercentages.get(section)) != null) {
            result = percent.doubleValue();
        }
        return result;
    }

    public void setExplodePercent(int section, double percent) {
        if (this.explodePercentages == null) {
            this.explodePercentages = new ObjectList();
        }
        this.explodePercentages.set(section, (Object)new Double(percent));
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMaximumExplodePercent() {
        double result = 0.0;
        for (int i = 0; i < this.explodePercentages.size(); ++i) {
            Number explode = (Number)this.explodePercentages.get(i);
            if (explode == null) continue;
            result = Math.max(result, explode.doubleValue());
        }
        return result;
    }

    public PieSectionLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(PieSectionLabelGenerator generator) {
        this.labelGenerator = generator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getLabelGap() {
        return this.labelGap;
    }

    public void setLabelGap(double gap) {
        this.labelGap = gap;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMaximumLabelWidth() {
        return this.maximumLabelWidth;
    }

    public void setMaximumLabelWidth(double width) {
        this.maximumLabelWidth = width;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getLabelLinkMargin() {
        return this.labelLinkMargin;
    }

    public void setLabelLinkMargin(double margin) {
        this.labelLinkMargin = margin;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelLinkPaint() {
        return this.labelLinkPaint;
    }

    public void setLabelLinkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelLinkPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getLabelLinkStroke() {
        return this.labelLinkStroke;
    }

    public void setLabelLinkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.labelLinkStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelBackgroundPaint() {
        return this.labelBackgroundPaint;
    }

    public void setLabelBackgroundPaint(Paint paint) {
        this.labelBackgroundPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelOutlinePaint() {
        return this.labelOutlinePaint;
    }

    public void setLabelOutlinePaint(Paint paint) {
        this.labelOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getLabelOutlineStroke() {
        return this.labelOutlineStroke;
    }

    public void setLabelOutlineStroke(Stroke stroke) {
        this.labelOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelShadowPaint() {
        return this.labelShadowPaint;
    }

    public void setLabelShadowPaint(Paint paint) {
        this.labelShadowPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PieToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(PieToolTipGenerator generator) {
        this.toolTipGenerator = generator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PieURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(PieURLGenerator generator) {
        this.urlGenerator = generator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMinimumArcAngleToDraw() {
        return this.minimumArcAngleToDraw;
    }

    public void setMinimumArcAngleToDraw(double angle) {
        this.minimumArcAngleToDraw = angle;
    }

    public boolean getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setIgnoreNullValues(boolean flag) {
        this.ignoreNullValues = flag;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PiePlotState initialise(Graphics2D g2, Rectangle2D plotArea, PiePlot plot, Integer index, PlotRenderingInfo info) {
        PiePlotState state = new PiePlotState(info);
        state.setPassesRequired(2);
        state.setTotal(DatasetUtilities.calculatePieDatasetTotal(plot.getDataset()));
        state.setLatestAngle(plot.getStartAngle());
        return state;
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, PlotState parentState, PlotRenderingInfo info) {
        Insets insets;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entering draw() method, plot area = " + plotArea.toString()));
        }
        if ((insets = this.getInsets()) != null) {
            plotArea.setRect(plotArea.getX() + (double)insets.left, plotArea.getY() + (double)insets.top, plotArea.getWidth() - (double)insets.left - (double)insets.right, plotArea.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (info != null) {
            info.setPlotArea(plotArea);
            info.setDataArea(plotArea);
        }
        this.drawBackground(g2, plotArea);
        this.drawOutline(g2, plotArea);
        Shape savedClip = g2.getClip();
        g2.clip(plotArea);
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            this.drawPie(g2, plotArea, info);
        } else {
            this.drawNoDataMessage(g2, plotArea);
        }
        g2.setClip(savedClip);
        g2.setComposite(originalComposite);
        this.drawOutline(g2, plotArea);
    }

    protected void drawPie(Graphics2D g2, Rectangle2D plotArea, PlotRenderingInfo info) {
        PiePlotState state = this.initialise(g2, plotArea, this, null, info);
        double labelWidth = 0.0;
        if (this.labelGenerator != null) {
            labelWidth = this.labelGap + this.maximumLabelWidth + this.labelLinkMargin;
        }
        double gapHorizontal = plotArea.getWidth() * (this.interiorGap + labelWidth);
        double gapVertical = plotArea.getHeight() * this.interiorGap;
        double linkX = plotArea.getX() + gapHorizontal / 2.0;
        double linkY = plotArea.getY() + gapVertical / 2.0;
        double linkW = plotArea.getWidth() - gapHorizontal;
        double linkH = plotArea.getHeight() - gapVertical;
        if (this.circular) {
            double min = Math.min(linkW, linkH) / 2.0;
            linkX = (linkX + linkX + linkW) / 2.0 - min;
            linkY = (linkY + linkY + linkH) / 2.0 - min;
            linkW = 2.0 * min;
            linkH = 2.0 * min;
        }
        Rectangle2D.Double linkArea = new Rectangle2D.Double(linkX, linkY, linkW, linkH);
        state.setLinkArea(linkArea);
        double hh = ((RectangularShape)linkArea).getWidth() * this.labelLinkMargin;
        double vv = ((RectangularShape)linkArea).getHeight() * this.labelLinkMargin;
        Rectangle2D.Double explodeArea = new Rectangle2D.Double(linkX + hh / 2.0, linkY + vv / 2.0, linkW - hh, linkH - vv);
        state.setExplodedPieArea(explodeArea);
        double maximumExplodePercent = this.getMaximumExplodePercent();
        double percent = maximumExplodePercent / (1.0 + maximumExplodePercent);
        double h1 = ((RectangularShape)explodeArea).getWidth() * percent;
        double v1 = ((RectangularShape)explodeArea).getHeight() * percent;
        Rectangle2D.Double pieArea = new Rectangle2D.Double(((RectangularShape)explodeArea).getX() + h1 / 2.0, ((RectangularShape)explodeArea).getY() + v1 / 2.0, ((RectangularShape)explodeArea).getWidth() - h1, ((RectangularShape)explodeArea).getHeight() - v1);
        state.setPieArea(pieArea);
        state.setPieCenterX(pieArea.getCenterX());
        state.setPieCenterY(pieArea.getCenterY());
        state.setPieWRadius(((RectangularShape)pieArea).getWidth() / 2.0);
        state.setPieHRadius(((RectangularShape)pieArea).getHeight() / 2.0);
        if (this.dataset != null && this.dataset.getKeys().size() > 0) {
            List keys = this.dataset.getKeys();
            double totalValue = DatasetUtilities.calculatePieDatasetTotal(this.dataset);
            int passesRequired = state.getPassesRequired();
            for (int pass = 0; pass < passesRequired; ++pass) {
                double runningTotal = 0.0;
                for (int section = 0; section < keys.size(); ++section) {
                    double value;
                    Number n = this.dataset.getValue(section);
                    if (n == null || !((value = n.doubleValue()) > 0.0)) continue;
                    runningTotal += value;
                    this.drawItem(g2, section, explodeArea, state, pass);
                }
            }
            this.drawLabels(g2, keys, totalValue, plotArea, linkArea, state);
        } else {
            this.drawNoDataMessage(g2, plotArea);
        }
    }

    protected void drawItem(Graphics2D g2, int section, Rectangle2D dataArea, PiePlotState state, int currentPass) {
        Number n = this.dataset.getValue(section);
        if (n == null) {
            return;
        }
        double value = n.doubleValue();
        double angle1 = 0.0;
        double angle2 = 0.0;
        if (this.direction == Rotation.CLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 - value / state.getTotal() * 360.0;
        } else if (this.direction == Rotation.ANTICLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 + value / state.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double angle = angle2 - angle1;
        if (Math.abs(angle) > this.getMinimumArcAngleToDraw()) {
            double ep = 0.0;
            double mep = this.getMaximumExplodePercent();
            if (mep > 0.0) {
                ep = this.getExplodePercent(section) / mep;
            }
            Rectangle2D arcBounds = this.getArcBounds(state.getPieArea(), state.getExplodedPieArea(), angle1, angle, ep);
            Arc2D.Double arc = new Arc2D.Double(arcBounds, angle1, angle, 2);
            if (currentPass == 0) {
                if (this.shadowPaint != null) {
                    Shape shadowArc = ShapeUtils.translateShape((Shape)arc, (double)((float)this.shadowXOffset), (double)((float)this.shadowYOffset));
                    g2.setPaint(this.shadowPaint);
                    g2.fill(shadowArc);
                }
            } else if (currentPass == 1) {
                EntityCollection entities;
                Paint paint = this.getSectionPaint(section);
                g2.setPaint(paint);
                g2.fill(arc);
                Paint outlinePaint = this.getSectionOutlinePaint(section);
                Stroke outlineStroke = this.getSectionOutlineStroke(section);
                if (outlinePaint != null && outlineStroke != null) {
                    g2.setPaint(outlinePaint);
                    g2.setStroke(outlineStroke);
                    g2.draw(arc);
                }
                if (state.getInfo() != null && (entities = state.getInfo().getOwner().getEntityCollection()) != null) {
                    Comparable key = this.dataset.getKey(section);
                    String tip = null;
                    if (this.toolTipGenerator != null) {
                        tip = this.toolTipGenerator.generateToolTip(this.dataset, key);
                    }
                    String url = null;
                    if (this.urlGenerator != null) {
                        url = this.urlGenerator.generateURL(this.dataset, key, this.pieIndex);
                    }
                    PieSectionEntity entity = new PieSectionEntity(arc, this.dataset, this.pieIndex, section, key, tip, url);
                    entities.addEntity(entity);
                }
            }
        }
        state.setLatestAngle(angle2);
    }

    protected void drawLabels(Graphics2D g2, List keys, double totalValue, Rectangle2D plotArea, Rectangle2D linkArea, PiePlotState state) {
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        DefaultKeyedValues leftKeys = new DefaultKeyedValues();
        DefaultKeyedValues rightKeys = new DefaultKeyedValues();
        double runningTotal1 = 0.0;
        Iterator iterator1 = keys.iterator();
        while (iterator1.hasNext()) {
            double v;
            Comparable key = (Comparable)iterator1.next();
            Number n = this.dataset.getValue(key);
            if (n == null || !((v = n.doubleValue()) > 0.0)) continue;
            runningTotal1 += v;
            double mid = this.startAngle + this.direction.getFactor() * ((runningTotal1 - v / 2.0) * 360.0) / totalValue;
            if (Math.cos(Math.toRadians(mid)) < 0.0) {
                leftKeys.addValue(key, new Double(mid));
                continue;
            }
            rightKeys.addValue(key, new Double(mid));
        }
        g2.setFont(this.getLabelFont());
        float maxLabelWidth = (float)(this.getMaximumLabelWidth() * plotArea.getWidth());
        if (this.labelGenerator != null) {
            this.drawLeftLabels(leftKeys, g2, plotArea, linkArea, maxLabelWidth, state);
            this.drawRightLabels(rightKeys, g2, plotArea, linkArea, maxLabelWidth, state);
        }
        g2.setComposite(originalComposite);
    }

    protected void drawLeftLabels(KeyedValues leftKeys, Graphics2D g2, Rectangle2D plotArea, Rectangle2D linkArea, float maxLabelWidth, PiePlotState state) {
        int i;
        PieLabelDistributor distributor1 = new PieLabelDistributor(leftKeys.getItemCount());
        double lGap = plotArea.getWidth() * this.labelGap;
        double verticalLinkRadius = state.getLinkArea().getHeight() / 2.0;
        for (i = 0; i < leftKeys.getItemCount(); ++i) {
            String label = this.labelGenerator.generateSectionLabel(this.dataset, leftKeys.getKey(i));
            if (label == null) continue;
            TextBlock block = TextUtilities.createTextBlock((String)label, (Font)this.labelFont, (Paint)this.labelPaint, (float)maxLabelWidth, (TextMeasurer)new G2TextMeasurer(g2));
            TextBox labelBox = new TextBox(block);
            labelBox.setBackgroundPaint(this.labelBackgroundPaint);
            labelBox.setOutlinePaint(this.labelOutlinePaint);
            labelBox.setOutlineStroke(this.labelOutlineStroke);
            labelBox.setShadowPaint(this.labelShadowPaint);
            double theta = Math.toRadians(leftKeys.getValue(i).doubleValue());
            double baseY = state.getPieCenterY() - Math.sin(theta) * verticalLinkRadius;
            double hh = labelBox.getHeight(g2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Label height = " + hh));
            }
            distributor1.addPieLabelRecord(new PieLabelRecord(leftKeys.getKey(i), theta, baseY, labelBox, hh, lGap / 2.0 + lGap / 2.0 * -Math.cos(theta), 0.9 + this.getExplodePercent(this.dataset.getIndex(leftKeys.getKey(i)))));
        }
        distributor1.distributeLabels(plotArea.getMinY(), plotArea.getHeight());
        for (i = 0; i < distributor1.getItemCount(); ++i) {
            this.drawLeftLabel(g2, state, distributor1.getPieLabelRecord(i));
        }
    }

    protected void drawRightLabels(KeyedValues keys, Graphics2D g2, Rectangle2D plotArea, Rectangle2D linkArea, float maxLabelWidth, PiePlotState state) {
        int i;
        PieLabelDistributor distributor2 = new PieLabelDistributor(keys.getItemCount());
        double lGap = plotArea.getWidth() * this.labelGap;
        double verticalLinkRadius = state.getLinkArea().getHeight() / 2.0;
        for (i = 0; i < keys.getItemCount(); ++i) {
            String label = this.labelGenerator.generateSectionLabel(this.dataset, keys.getKey(i));
            if (label == null) continue;
            TextBlock block = TextUtilities.createTextBlock((String)label, (Font)this.labelFont, (Paint)this.labelPaint, (float)maxLabelWidth, (TextMeasurer)new G2TextMeasurer(g2));
            TextBox labelBox = new TextBox(block);
            labelBox.setBackgroundPaint(this.labelBackgroundPaint);
            labelBox.setOutlinePaint(this.labelOutlinePaint);
            labelBox.setOutlineStroke(this.labelOutlineStroke);
            labelBox.setShadowPaint(this.labelShadowPaint);
            double theta = Math.toRadians(keys.getValue(i).doubleValue());
            double baseY = state.getPieCenterY() - Math.sin(theta) * verticalLinkRadius;
            double hh = labelBox.getHeight(g2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Label height = " + hh));
            }
            distributor2.addPieLabelRecord(new PieLabelRecord(keys.getKey(i), theta, baseY, labelBox, hh, lGap / 2.0 + lGap / 2.0 * Math.cos(theta), 0.9 + this.getExplodePercent(this.dataset.getIndex(keys.getKey(i)))));
        }
        distributor2.distributeLabels(linkArea.getMinY(), linkArea.getHeight());
        for (i = 0; i < distributor2.getItemCount(); ++i) {
            this.drawRightLabel(g2, state, distributor2.getPieLabelRecord(i));
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        List keys = null;
        if (this.dataset != null) {
            keys = this.dataset.getKeys();
            int section = 0;
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String label;
                Comparable key = (Comparable)iterator.next();
                Number n = this.dataset.getValue(key);
                if (n == null && this.ignoreNullValues) continue;
                String description = label = key.toString();
                Shape shape = null;
                Paint paint = this.getSectionPaint(section);
                Paint outlinePaint = this.getSectionOutlinePaint(section);
                Stroke stroke = this.getSectionOutlineStroke(section);
                LegendItem item = new LegendItem(label, description, shape, true, paint, stroke, outlinePaint, stroke);
                result.add(item);
                ++section;
            }
        }
        return result;
    }

    public String getPlotType() {
        return localizationResources.getString("Pie_Plot");
    }

    public void zoom(double percent) {
    }

    protected Rectangle2D getArcBounds(Rectangle2D unexploded, Rectangle2D exploded, double angle, double extent, double explodePercent) {
        if (explodePercent == 0.0) {
            return unexploded;
        }
        Arc2D.Double arc1 = new Arc2D.Double(unexploded, angle, extent / 2.0, 0);
        Point2D point1 = arc1.getEndPoint();
        Arc2D.Double arc2 = new Arc2D.Double(exploded, angle, extent / 2.0, 0);
        Point2D point2 = arc2.getEndPoint();
        double deltaX = (point1.getX() - point2.getX()) * explodePercent;
        double deltaY = (point1.getY() - point2.getY()) * explodePercent;
        return new Rectangle2D.Double(unexploded.getX() - deltaX, unexploded.getY() - deltaY, unexploded.getWidth(), unexploded.getHeight());
    }

    protected void drawLeftLabel(Graphics2D g2, PiePlotState state, PieLabelRecord record) {
        double theta = record.getAngle();
        double linkX = state.getPieCenterX() + Math.cos(theta) * state.getPieWRadius() * record.getLinkPercent();
        double linkY = state.getPieCenterY() - Math.sin(theta) * state.getPieHRadius() * record.getLinkPercent();
        double elbowX = state.getPieCenterX() + Math.cos(theta) * state.getLinkArea().getWidth() / 2.0;
        double elbowY = state.getPieCenterY() - Math.sin(theta) * state.getLinkArea().getHeight() / 2.0;
        double anchorX = state.getLinkArea().getMinX();
        double anchorY = elbowY;
        double targetX = anchorX - record.getGap();
        double targetY = record.getAllocatedY();
        g2.setPaint(this.labelLinkPaint);
        g2.setStroke(this.labelLinkStroke);
        g2.draw(new Line2D.Double(linkX, linkY, elbowX, elbowY));
        g2.draw(new Line2D.Double(anchorX, anchorY, elbowX, elbowY));
        g2.draw(new Line2D.Double(anchorX, anchorY, targetX, targetY));
        TextBox tb = record.getLabel();
        tb.draw(g2, (float)targetX, (float)targetY, RectangleAnchor.RIGHT);
    }

    protected void drawRightLabel(Graphics2D g2, PiePlotState state, PieLabelRecord record) {
        double theta = record.getAngle();
        double linkX = state.getPieCenterX() + Math.cos(theta) * state.getPieWRadius() * record.getLinkPercent();
        double linkY = state.getPieCenterY() - Math.sin(theta) * state.getPieHRadius() * record.getLinkPercent();
        double elbowX = state.getPieCenterX() + Math.cos(theta) * state.getLinkArea().getWidth() / 2.0;
        double elbowY = state.getPieCenterY() - Math.sin(theta) * state.getLinkArea().getHeight() / 2.0;
        double anchorX = state.getLinkArea().getMaxX();
        double anchorY = elbowY;
        double targetX = anchorX + record.getGap();
        double targetY = record.getAllocatedY();
        g2.setPaint(this.labelLinkPaint);
        g2.setStroke(this.labelLinkStroke);
        g2.draw(new Line2D.Double(linkX, linkY, elbowX, elbowY));
        g2.draw(new Line2D.Double(anchorX, anchorY, elbowX, elbowY));
        g2.draw(new Line2D.Double(anchorX, anchorY, targetX, targetY));
        TextBox tb = record.getLabel();
        tb.draw(g2, (float)targetX, (float)targetY, RectangleAnchor.LEFT);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PiePlot && super.equals(obj)) {
            PiePlot plot = (PiePlot)obj;
            boolean b0 = this.pieIndex == plot.pieIndex;
            boolean b1 = this.interiorGap == plot.interiorGap;
            boolean b2 = this.circular == plot.circular;
            boolean b3 = this.startAngle == plot.startAngle;
            boolean b4 = this.direction == plot.direction;
            boolean b5 = ObjectUtils.equal((Object)this.sectionPaint, (Object)plot.sectionPaint);
            boolean b6 = ObjectUtils.equal((Object)this.sectionPaintList, (Object)plot.sectionPaintList);
            boolean b7 = ObjectUtils.equal((Object)this.baseSectionPaint, (Object)plot.baseSectionPaint);
            boolean b8 = ObjectUtils.equal((Object)this.sectionOutlinePaint, (Object)plot.sectionOutlinePaint);
            boolean b9 = ObjectUtils.equal((Object)this.sectionOutlinePaintList, (Object)plot.sectionOutlinePaintList);
            boolean b10 = ObjectUtils.equal((Object)this.baseSectionOutlinePaint, (Object)plot.baseSectionOutlinePaint);
            boolean b11 = ObjectUtils.equal((Object)this.sectionOutlineStroke, (Object)plot.sectionOutlineStroke);
            boolean b12 = ObjectUtils.equal((Object)this.sectionOutlineStrokeList, (Object)plot.sectionOutlineStrokeList);
            boolean b13 = ObjectUtils.equal((Object)this.baseSectionOutlineStroke, (Object)plot.baseSectionOutlineStroke);
            boolean b14 = ObjectUtils.equal((Object)this.shadowPaint, (Object)plot.shadowPaint);
            boolean b15 = this.shadowXOffset == plot.shadowXOffset;
            boolean b16 = this.shadowYOffset == plot.shadowYOffset;
            boolean b17 = ObjectUtils.equal((Object)this.explodePercentages, (Object)plot.explodePercentages);
            boolean b18 = ObjectUtils.equal((Object)this.labelGenerator, (Object)plot.labelGenerator);
            boolean b19 = ObjectUtils.equal((Object)this.labelFont, (Object)plot.labelFont);
            boolean b20 = ObjectUtils.equal((Object)this.labelPaint, (Object)plot.labelPaint);
            boolean b21 = ObjectUtils.equal((Object)this.labelBackgroundPaint, (Object)plot.labelBackgroundPaint);
            boolean b22 = ObjectUtils.equal((Object)this.labelOutlinePaint, (Object)plot.labelOutlinePaint);
            boolean b23 = ObjectUtils.equal((Object)this.labelOutlineStroke, (Object)plot.labelOutlineStroke);
            boolean b24 = ObjectUtils.equal((Object)this.labelShadowPaint, (Object)plot.labelShadowPaint);
            boolean b25 = this.maximumLabelWidth == plot.maximumLabelWidth;
            boolean b26 = this.labelGap == plot.labelGap;
            boolean b27 = this.labelLinkMargin == plot.labelLinkMargin;
            boolean b28 = ObjectUtils.equal((Object)this.labelLinkPaint, (Object)plot.labelLinkPaint);
            boolean b29 = ObjectUtils.equal((Object)this.labelLinkStroke, (Object)plot.labelLinkStroke);
            boolean b30 = ObjectUtils.equal((Object)this.toolTipGenerator, (Object)plot.toolTipGenerator);
            boolean b31 = ObjectUtils.equal((Object)this.urlGenerator, (Object)plot.urlGenerator);
            boolean b32 = this.minimumArcAngleToDraw == plot.minimumArcAngleToDraw;
            return b0 && b1 && b2 && b3 && b4 && b5 && b6 && b7 && b8 && b9 && b10 && b11 && b12 && b13 && b14 && b15 && b16 && b17 && b18 && b19 && b20 && b21 && b22 && b23 && b24 && b25 && b26 && b27 && b28 && b29 && b30 && b31 && b32;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PiePlot clone = (PiePlot)super.clone();
        if (clone.dataset != null) {
            clone.dataset.addChangeListener(clone);
        }
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.sectionPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.baseSectionPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.sectionOutlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.baseSectionOutlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.sectionOutlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.baseSectionOutlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.shadowPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.labelPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.labelBackgroundPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.labelOutlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.labelOutlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.labelShadowPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.labelLinkPaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.labelLinkStroke, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.sectionPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.baseSectionPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.sectionOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.baseSectionOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.sectionOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.baseSectionOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.shadowPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.labelPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.labelBackgroundPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.labelOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.labelOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.labelShadowPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.labelLinkPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.labelLinkStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

