/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.Date;
import org.jfree.data.AbstractXYDataset;
import org.jfree.data.HighLowDataset;

public class DefaultHighLowDataset
extends AbstractXYDataset
implements HighLowDataset {
    private String seriesName;
    private Date[] date;
    private Number[] high;
    private Number[] low;
    private Number[] open;
    private Number[] close;
    private Number[] volume;

    public DefaultHighLowDataset(String seriesName, Date[] date, double[] high, double[] low, double[] open, double[] close, double[] volume) {
        this.seriesName = seriesName;
        this.date = date;
        this.high = DefaultHighLowDataset.createNumberArray(high);
        this.low = DefaultHighLowDataset.createNumberArray(low);
        this.open = DefaultHighLowDataset.createNumberArray(open);
        this.close = DefaultHighLowDataset.createNumberArray(close);
        this.volume = DefaultHighLowDataset.createNumberArray(volume);
    }

    public String getSeriesName(int i) {
        return this.seriesName;
    }

    public Number getXValue(int series, int item) {
        return new Long(this.date[item].getTime());
    }

    public Date getXDate(int series, int item) {
        return this.date[item];
    }

    public Number getYValue(int series, int item) {
        return this.getCloseValue(series, item);
    }

    public Number getHighValue(int series, int item) {
        return this.high[item];
    }

    public double getHigh(int series, int item) {
        double result = Double.NaN;
        Number high = this.getHighValue(series, item);
        if (high != null) {
            result = high.doubleValue();
        }
        return result;
    }

    public Number getLowValue(int series, int item) {
        return this.low[item];
    }

    public double getLow(int series, int item) {
        double result = Double.NaN;
        Number low = this.getLowValue(series, item);
        if (low != null) {
            result = low.doubleValue();
        }
        return result;
    }

    public Number getOpenValue(int series, int item) {
        return this.open[item];
    }

    public double getOpen(int series, int item) {
        double result = Double.NaN;
        Number open = this.getOpenValue(series, item);
        if (open != null) {
            result = open.doubleValue();
        }
        return result;
    }

    public Number getCloseValue(int series, int item) {
        return this.close[item];
    }

    public double getClose(int series, int item) {
        double result = Double.NaN;
        Number close = this.getCloseValue(series, item);
        if (close != null) {
            result = close.doubleValue();
        }
        return result;
    }

    public Number getVolumeValue(int series, int item) {
        return this.volume[item];
    }

    public double getVolume(int series, int item) {
        double result = Double.NaN;
        Number volume = this.getVolumeValue(series, item);
        if (volume != null) {
            result = volume.doubleValue();
        }
        return result;
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int series) {
        return this.date.length;
    }

    public static Number[] createNumberArray(double[] data) {
        Number[] result = new Number[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = new Double(data[i]);
        }
        return result;
    }
}

