/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.Arrays;
import java.util.Date;
import org.jfree.data.AbstractXYDataset;
import org.jfree.data.HighLowDataset;
import org.jfree.data.OHLCDataItem;

public class OHLCDataset
extends AbstractXYDataset
implements HighLowDataset {
    private String name;
    private OHLCDataItem[] data;

    public OHLCDataset(String name, OHLCDataItem[] data) {
        this.name = name;
        this.data = data;
    }

    public String getSeriesName(int series) {
        return this.name;
    }

    public Number getXValue(int series, int item) {
        return new Long(this.data[item].getDate().getTime());
    }

    public Date getXDate(int series, int item) {
        return this.data[item].getDate();
    }

    public Number getYValue(int series, int item) {
        return this.getCloseValue(series, item);
    }

    public Number getHighValue(int series, int item) {
        return this.data[item].getHigh();
    }

    public double getHigh(int series, int item) {
        double result = Double.NaN;
        Number high = this.getHighValue(series, item);
        if (high != null) {
            result = high.doubleValue();
        }
        return result;
    }

    public Number getLowValue(int series, int item) {
        return this.data[item].getLow();
    }

    public double getLow(int series, int item) {
        double result = Double.NaN;
        Number low = this.getLowValue(series, item);
        if (low != null) {
            result = low.doubleValue();
        }
        return result;
    }

    public Number getOpenValue(int series, int item) {
        return this.data[item].getOpen();
    }

    public double getOpen(int series, int item) {
        double result = Double.NaN;
        Number open = this.getOpenValue(series, item);
        if (open != null) {
            result = open.doubleValue();
        }
        return result;
    }

    public Number getCloseValue(int series, int item) {
        return this.data[item].getClose();
    }

    public double getClose(int series, int item) {
        double result = Double.NaN;
        Number close = this.getCloseValue(series, item);
        if (close != null) {
            result = close.doubleValue();
        }
        return result;
    }

    public Number getVolumeValue(int series, int item) {
        return this.data[item].getVolume();
    }

    public double getVolume(int series, int item) {
        double result = Double.NaN;
        Number volume = this.getVolumeValue(series, item);
        if (volume != null) {
            result = volume.doubleValue();
        }
        return result;
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int series) {
        return this.data.length;
    }

    public void sortDataByDate() {
        Arrays.sort(this.data);
    }
}

