/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.jfree.data.AbstractIntervalXYDataset;
import org.jfree.data.DomainInfo;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.Range;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimePeriodValue;
import org.jfree.data.time.TimePeriodValues;

public class TimePeriodValuesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
Serializable {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    private List data = new ArrayList();
    private TimePeriodAnchor xPosition = TimePeriodAnchor.MIDDLE;
    private boolean domainIsPointsInTime = true;

    public TimePeriodValuesCollection() {
        this((TimePeriodValues)null);
    }

    public TimePeriodValuesCollection(TimeZone zone) {
        this(null, zone);
    }

    public TimePeriodValuesCollection(TimePeriodValues series) {
        if (series != null) {
            this.data.add(series);
            series.addChangeListener(this);
        }
    }

    public TimePeriodValuesCollection(TimePeriodValues series, TimeZone zone) {
        this(series);
    }

    public int getPosition() {
        TimePeriodAnchor anchor = this.getXPosition();
        if (anchor == TimePeriodAnchor.START) {
            return 0;
        }
        if (anchor == TimePeriodAnchor.MIDDLE) {
            return 1;
        }
        if (anchor == TimePeriodAnchor.END) {
            return 2;
        }
        return 1;
    }

    public void setPosition(int position) {
        if (position == 0) {
            this.setXPosition(TimePeriodAnchor.START);
        } else if (position == 1) {
            this.setXPosition(TimePeriodAnchor.MIDDLE);
        } else if (position == 2) {
            this.setXPosition(TimePeriodAnchor.END);
        }
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor position) {
        this.xPosition = position;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean flag) {
        this.domainIsPointsInTime = flag;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public TimePeriodValues getSeries(int series) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("TimePeriodValuesCollection.getSeries(...): index outside valid range.");
        }
        TimePeriodValues ts = (TimePeriodValues)this.data.get(series);
        return ts;
    }

    public String getSeriesName(int series) {
        return this.getSeries(series).getName();
    }

    public void addSeries(TimePeriodValues series) {
        if (series == null) {
            throw new IllegalArgumentException("TimePeriodValuesCollection.addSeries(...): cannot add null series.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(TimePeriodValues series) {
        if (series == null) {
            throw new IllegalArgumentException("TimePeriodValuesCollection.addSeries(...): cannot add null series.");
        }
        this.data.remove(series);
        series.removeChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int index) {
        TimePeriodValues series = this.getSeries(index);
        if (series != null) {
            this.removeSeries(series);
        }
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public Number getXValue(int series, int item) {
        TimePeriodValues ts = (TimePeriodValues)this.data.get(series);
        TimePeriodValue dp = ts.getDataItem(item);
        TimePeriod period = dp.getPeriod();
        return new Long(this.getX(period));
    }

    private long getX(TimePeriod period) {
        if (this.xPosition == TimePeriodAnchor.START) {
            return period.getStart().getTime();
        }
        if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            return period.getStart().getTime() / 2L + period.getEnd().getTime() / 2L;
        }
        if (this.xPosition == TimePeriodAnchor.END) {
            return period.getEnd().getTime();
        }
        throw new IllegalStateException("TimePeriodValuesCollection.getX(...).");
    }

    public Number getStartXValue(int series, int item) {
        TimePeriodValues ts = (TimePeriodValues)this.data.get(series);
        TimePeriodValue dp = ts.getDataItem(item);
        return new Long(dp.getPeriod().getStart().getTime());
    }

    public Number getEndXValue(int series, int item) {
        TimePeriodValues ts = (TimePeriodValues)this.data.get(series);
        TimePeriodValue dp = ts.getDataItem(item);
        return new Long(dp.getPeriod().getEnd().getTime());
    }

    public Number getYValue(int series, int item) {
        TimePeriodValues ts = (TimePeriodValues)this.data.get(series);
        TimePeriodValue dp = ts.getDataItem(item);
        return dp.getValue();
    }

    public Number getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getMinimumDomainValue() {
        Range r = this.getDomainRange();
        return new Double(r.getLowerBound());
    }

    public Number getMaximumDomainValue() {
        Range r = this.getDomainRange();
        return new Double(r.getUpperBound());
    }

    public Range getDomainRange() {
        Range result = null;
        Range temp = null;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TimePeriodValues series = (TimePeriodValues)iterator.next();
            int count = series.getItemCount();
            if (count <= 0) continue;
            TimePeriod start = series.getTimePeriod(series.getMinStartIndex());
            TimePeriod end = series.getTimePeriod(series.getMaxEndIndex());
            if (this.domainIsPointsInTime) {
                if (this.xPosition == TimePeriodAnchor.START) {
                    TimePeriod maxStart = series.getTimePeriod(series.getMaxStartIndex());
                    temp = new Range(start.getStart().getTime(), maxStart.getStart().getTime());
                } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
                    TimePeriod minMiddle = series.getTimePeriod(series.getMinMiddleIndex());
                    long s1 = minMiddle.getStart().getTime();
                    long e1 = minMiddle.getEnd().getTime();
                    TimePeriod maxMiddle = series.getTimePeriod(series.getMaxMiddleIndex());
                    long s2 = maxMiddle.getStart().getTime();
                    long e2 = maxMiddle.getEnd().getTime();
                    temp = new Range(s1 + (e1 - s1) / 2L, s2 + (e2 - s2) / 2L);
                } else if (this.xPosition == TimePeriodAnchor.END) {
                    TimePeriod minEnd = series.getTimePeriod(series.getMinEndIndex());
                    temp = new Range(minEnd.getEnd().getTime(), end.getEnd().getTime());
                }
            } else {
                temp = new Range(start.getStart().getTime(), end.getEnd().getTime());
            }
            result = Range.combine(result, temp);
        }
        return result;
    }
}

