/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFGetAxisMemberInfoByAxisIDCommand.java
 *  Fw肳ꂽfBVƂ̃o[̏XML`ŏo͂NXłB
 *
 *  쐬: 2004/02/13
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.NamingException;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;

import openolap.viewer.Axis;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionMemberDAO;

/**
 *  NXFGetAxisMemberInfoByAxisIDCommand<br>
 *  Fw肳ꂽfBVƂ̃o[̏XML`ŏo͂NXłB
 */
public class GetAxisMemberInfoByAxisIDCommand implements Command {

	// ********** CX^Xϐ **********

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(GetReportInfoCommand.class.getName());


	// ********** \bh **********

	/**
	 * w肳ꂽfBVƂ̃o[̏XML`ŐB<br>
	 * JSPdispatchs킸ɒXMLo͂邽߁Anull߂B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return null
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 * @exception SQLException ɗO
	 * @exception NamingException ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException, SQLException, NamingException {

		Report report = (Report) helper.getRequest().getSession().getAttribute("report");
		String targetAxisID = (String) helper.getRequest().getParameter("axisID");
		if(Constants.MeasureID.equals(targetAxisID)) {	// oXMLȂ̂ŁAW[ł邱Ƃ͂肦Ȃ
			throw new IllegalArgumentException();
		}

		Axis axis = report.getAxisByID(targetAxisID);

		Connection conn = null;
		DAOFactory daoFactory = DAOFactory.getDAOFactory();

		try {
			conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
											(String)helper.getRequest().getSession().getAttribute("searchPathName"));
	
			StringBuffer axisMemberXML = new StringBuffer(512);
	
			// XML 
			axisMemberXML.append("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");				// XML wb_
			DimensionMemberDAO dimMemberDAO =  daoFactory.getDimensionMemberDAO(conn);
			axisMemberXML.append(dimMemberDAO.getDimensionMemberXML(report, axis , false));	// fBVo[XgXML

			// XML o͏
			helper.getResponse().setContentType("text/xml; charset=Shift_JIS");
			PrintWriter out = helper.getResponse().getWriter();

			// o
			out.println(axisMemberXML.toString());
				if(log.isInfoEnabled()) {	// Oo
					log.info("XML(selected axisInfo)F\n" + axisMemberXML.toString());
				}

		} catch (SQLException e) {
			throw e;
		} finally {
			if(conn != null){
				try {
					conn.close();
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return null;
	}

}
