/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFGetReportHeaderCommand.java
 *  F|[gIuWFNg쐬SessionɕۑA|[gwb_[t[\y[WdispatchNXłB
 *
 *  쐬: 2004/02/15
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import openolap.viewer.Report;
import openolap.viewer.Security;
import openolap.viewer.User;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Messages;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.ReportDAO;
import openolap.viewer.dao.SecurityDAO;

/**
 *  NXFGetReportHeaderCommand<br>
 *  F|[gIuWFNg쐬SessionɕۑA|[gwb_[t[\y[WdispatchNXłB
 */
public class GetReportHeaderCommand implements Command {

	/**
	 * |[gIuWFNg쐬SessionɕۑA|[gwb_[t[\y[Wdispatch܂B<br>
	 * "cubeSeq"p[^^ꂽꍇAL[uƂɐVKɃ|[gIuWFNg쐬܂B<br>
	 * "seqId"p[^^ꂽꍇÃ|[gƂɃ|[gIuWFNg쐬܂B<br>
	 * p[^^ĂȂASessionɊreportIuWFNg݂ꍇAs܂B<br>
	 * p[^^ĂȂASessionreportIuWFNg݂ȂꍇAIllegalStateExceptionthrowB<br>
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 * @exception NamingException ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException, SQLException, NamingException {

			HttpServletRequest request = helper.getRequest();
			HttpSession session = helper.getRequest().getSession();

			String cubeSeq = request.getParameter("cubeSeq");
			String reportId = request.getParameter("seqId");

			if((cubeSeq == null) && (reportId == null) && (session.getAttribute("report") == null) ) { throw new IllegalStateException(); }
			if((cubeSeq != null) && (reportId != null)) { throw new IllegalStateException(); }

			Connection conn = null;
			DAOFactory daoFactory = DAOFactory.getDAOFactory();
			conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
											(String)helper.getRequest().getSession().getAttribute("searchPathName"));

			Report report = null;
			User user = (User)session.getAttribute("user");
			
			
			try {
				// ReportZbV֓o^
				ReportDAO reportDAO = daoFactory.getReportDAO(conn);
				if(request.getParameter("cubeSeq") != null) { // L[uɑ΂\v

					// VK|[g쐬iCubeQƁj́A{\EGNX|[g\ȃZLeBIuWFNg쐬AZbVɕۑB
					Security security = new Security(Boolean.TRUE.booleanValue(),Boolean.TRUE.booleanValue());
					session.setAttribute("security", security);

					// ReportZbV֓o^
					report = reportDAO.getInitialReport(cubeSeq, user.getUserID(), commonSettings);
					session.setAttribute("report",report);

				} else if (request.getParameter("seqId") !=null) { // |[gɑ΂\v

					// |[g̃ZLeBZbVɕۑ
					SecurityDAO securityDAO = daoFactory.getSecurityDAO(conn);
					Security security = securityDAO.getSecurity(user.getUserID(),reportId);

					session.setAttribute("security", security);
					if(security.isReportViewable()) { // |[g̉{Ƃ̂݁A|[gIuWFNg𐶐
						report = reportDAO.getExistingReport(reportId, helper, commonSettings);

						// L[u݂Ȃ
						if(report == null) {
							String errorMessage = Messages.getString("GetReportHeaderCommand.cubeNotExistMSG"); //$NON-NLS-1$
							helper.getRequest().setAttribute("errorMessage", errorMessage);
						}

						session.setAttribute("report",report);

					}

				} else {
					if (session.getAttribute("report") != null) {
						report = (Report) session.getAttribute("report");
					} else {
						throw new IllegalStateException();
					}
				}
			} catch (SQLException e) {
				throw e;
			}  finally {
				if(conn != null){
					try {
						conn.close();
					} catch (SQLException e) {
						throw e;
					}
				}
			}

		return "/spread/spreadHeader.jsp";
	}

}
