/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresCubeDAO.java
 *  FL[uIuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/08
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.log4j.Logger;

import openolap.viewer.Cube;

/**
 *  NXFPostgresCubeDAO<br>
 *  FL[uIuWFNg̉iǗNXłB
 */
public class PostgresCubeDAO implements CubeDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(PostgresCubeDAO.class.getName());

	// ********** RXgN^ **********

	/**
	 * L[uIuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresCubeDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * t@Nge[u߂B
	 * @param cubeSeq L[ũV[PXԍ
	 * @return t@Nge[u
	 */
	public String getFactTableName(String cubeSeq) {
		String factTableName = "v_CUBE_" + cubeSeq;
		return factTableName;
	}

	/**
	 * L[uV[PXԍƂɃL[uIuWFNg߂B
	 * @param cubeSeq L[ũV[PXԍ
	 * @return L[uIuWFNg
	 * @exception SQLException ɗO
	 */
	public Cube getCubeByID(String cubeSeq) throws SQLException {
		String cubeName = this.getCubeName(cubeSeq);
		Cube cube = new Cube(	cubeSeq,					// cubeSeq
								cubeName);					// cubeName
		return cube;
	}

	/**
	 * L[uV[PXԍƂɃL[u߂B
	 * @param cubeSeq L[ũV[PXԍ
	 * @return L[u
	 * @exception SQLException ɗO
	 */
	public String getCubeName(String cubeSeq) throws SQLException {

		String cubeName = null;

		String SQL = "";
		Statement stmt = null;
		ResultSet rs = null;
		SQL =   "";
		SQL +=	" select ";
		SQL +=	"    NAME ";
		SQL +=	" from ";
		SQL +=	"    oo_cube ";
		SQL +=	" where ";
		SQL +=	"    cube_seq = " + cubeSeq;

		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select axis members)F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);

			while ( rs.next() ) {
				cubeName = rs.getString("NAME");
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		if(log.isDebugEnabled()) {
			log.debug("cubeName:" + cubeName);
		}

		return cubeName;
	}

}
