/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresDimensionDAO.java
 *  FfBVIuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/06
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import openolap.viewer.AxisLevel;
import openolap.viewer.Dimension;
import openolap.viewer.Report;
import openolap.viewer.common.Messages;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;

/**
 *  NXFPostgresDimensionDAO<br>
 *  FfBVIuWFNg̉iǗNXłB
 */
public class PostgresDimensionDAO implements DimensionDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(PostgresDimensionDAO.class.getName());

	// ********** RXgN^ **********

	/**
	 * fBVIuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresDimensionDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * f[^\[X̃fBV̕e[u߂B
	 * @param dimSeq fBVV[PXԍ
	 * @param partSeq fBṼp[cԍ
	 * @return DB̕e[u
	 */
	public String getDimensionTableName(String dimSeq, String partSeq) throws IllegalArgumentException {
		if ((dimSeq == null) || (partSeq == null) ) { throw new IllegalArgumentException();}
		if ((dimSeq == "") || (partSeq == "") ) { throw new IllegalArgumentException();}

		return "oo_dim_" + dimSeq + "_" + partSeq;
	}

	/**
	 * fBVIuWFNg̃Xg߂B
	 * @param cubeSeq L[uV[PXԍ
	 * @return fBVIuWFNg̃Xg
	 * @exception SQLException ɗO
	 */
	public ArrayList selectDimensions(String cubeSeq) throws SQLException {

		ArrayList dimensionList = new ArrayList();
		Dimension dim = null;
		String SQL = "";
		Statement stmt = null;
		ResultSet rs = null;

		String timeDimDispName = Messages.getString("PostgresDimensionDAO.timeDimDispName"); //$NON-NLS-1$
		SQL =   "";
		SQL +=	" select ";
		SQL +=	"    distinct coalesce(d.name,'" + timeDimDispName + "') as name, ";
		SQL +=	"    c.time_dim_flg, ";
		SQL +=	"    d.total_flg, ";
		SQL +=	"    c.DIMENSION_SEQ, ";
		SQL +=	"    CASE WHEN c.PART_SEQ=0 THEN 1 ";
		SQL +=	"         ELSE c.PART_SEQ ";
		SQL +=	"    END, ";
		SQL +=	"    coalesce(d.COMMENT,'') as COMMENT, ";
		SQL +=	"    c.DIM_NO ";
		SQL +=	" from ";
		SQL +=	"    oo_info_dim c left outer join ";
		SQL +=  "    (select dimension_seq,name,total_flg,comment from oo_dimension union select time_seq,name,total_flg,comment from oo_time) d ";
		SQL +=  "    on (c.dimension_seq=d.dimension_seq) ";
		SQL +=	" where c.cube_seq=" + cubeSeq;
		SQL +=	" order by DIM_NO";

		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select dimensions )F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);

			int i=0;
			while ( rs.next() ) {

				// ԎǂAvlݒ
				boolean timeDimFLG = false; // Ԏǂ
				boolean hasTotalFLG = false;// vl
				if ( rs.getString("time_dim_flg").equals("1") ) {		// ԃfBV
					if ( i != 0 ){ throw new IllegalStateException();} //(Ԏ͕KԍŏɂȂ)
					timeDimFLG = true;
					hasTotalFLG = hasTimeDimhaveTotal(cubeSeq, rs.getString("DIMENSION_SEQ"));
				} else {												// ԃfBVȊÕfBV

					if ( rs.getString("total_flg").equals("1") ) {		// vl
						hasTotalFLG = true;	
					}
				}

				dim = new Dimension(Integer.toString(i+1),							// ID
										rs.getString("name"), 						// name
										rs.getString("COMMENT"), 					// comment
										new ArrayList(), 							// isUsedSelecter
										null, 										// isTimeDim
										false, 									// hasTotal
										false, 									// Dimension seq
										timeDimFLG, hasTotalFLG, rs.getString("DIMENSION_SEQ"), rs.getString("PART_SEQ"));	// part seq

//System.out.println(rs.getString("name") + "," + rs.getString("time_dim_flg") + "," + rs.getString("COMMENT"));
//System.out.println(timeDimFLG + "," + hasTotalFLG);
//System.out.println(rs.getString("DIMENSION_SEQ") + "," + rs.getString("PART_SEQ"));

				// Dimension IuWFNg AxisLevel IuWFNgǉ
				DAOFactory daoFactory = DAOFactory.getDAOFactory();
				AxisLevelDAO axisLevelDAO = daoFactory.getAxisLevelDAO(this.conn);		
				Iterator it = axisLevelDAO.selectAxisLevels(cubeSeq,dim).iterator();
				while (it.hasNext()) {
					AxisLevel axisLevel = (AxisLevel) it.next();
					dim.addAxisLevelList(axisLevel);
				}

				dimensionList.add(dim);
				i++;
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return dimensionList;
	}

	/**
	 * fBṼo[̕\^CvXVB
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒ킷IuWFNg
	 */
	public void registDimensionMemberDispType(RequestHelper helper, CommonSettings commonSettings) {
		
		HttpServletRequest request = helper.getRequest();
		String dimMemDispTypes = (String)request.getParameter("dimMemDispTypes");		
		Report report = (Report)helper.getRequest().getSession().getAttribute("report");

		ArrayList dimIDDispTypePairList = StringUtil.splitString(dimMemDispTypes,",");
		Iterator it = dimIDDispTypePairList.iterator();
		while (it.hasNext()) {
			String dimIDDispTypePair = (String) it.next();
			ArrayList dimIDDispTypeList = StringUtil.splitString(dimIDDispTypePair,":");

			String dimID =(String)dimIDDispTypeList.get(0);				// ID
			String dispMemberType = (String) dimIDDispTypeList.get(1);	// o[\̃^Cv

			if( (!Dimension.DISP_LONG_NAME.equals(dispMemberType)) && 		// 擾llǂmF
			     (!Dimension.DISP_SHORT_NAME.equals(dispMemberType) )) {
				throw new IllegalArgumentException();
			}

			Dimension dim = (Dimension) report.getAxisByID(dimID);
			dim.setDispMemberNameType(dispMemberType);

		}

	}

	// ********** private\bh **********

	/**
	 * ԃfBVvlH
	 * @param cubeSeq L[uV[PXԍ
	 * @param dimensionSeq L[uV[PXԍ
	 * @return ԃfBVvlꍇtrueAȂꍇfalse߂
	 * @exception SQLException ɗO
	 */
	private boolean hasTimeDimhaveTotal(String cubeSeq, String dimensionSeq) throws SQLException {
		boolean hasTotalFLG = false;

		Statement stmt = null;
		ResultSet rs = null;
		String SQL = "";
		SQL =   "";
		SQL +=	"select ";
		SQL +=	"  distinct total_flg ";
		SQL +=	"from ";
		SQL +=	"  oo_time ";
		SQL +=	"where ";
		SQL +=	"  time_seq=" + dimensionSeq;

		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select timeDim has total flg )F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);
			while ( rs.next() ) {

				// vl
				if ( rs.getString("total_flg") != null ) {
					if ( rs.getString("total_flg").equals("1") ) {
						hasTotalFLG = true;
					}
				}
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		if(log.isDebugEnabled()) {
			log.debug("time dimension hasTotalFlg?F\n" + hasTotalFLG);
		}

		return hasTotalFLG;
	}

}
