/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.filter
 *  t@CFLoggingSessionFilter.java
 *  FZbVMONXłB
 *
 *  쐬: 2004/10/19
 */
package openolap.viewer.filter;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;

import openolap.viewer.common.CommonUtils;

import org.apache.log4j.Logger;

/**
 *  NXFLoggingSessionFilter<br>
 *  FZbVMONXłB
 */
public class LoggingSessionFilter implements Filter {


	// ********** CX^Xϐ **********

	/** MOIuWFNg */
	private static final Logger logger = Logger.getLogger(LoggingSessionFilter.class);

	/** FilterConfig IuWFNg */
	private FilterConfig filterConfig = null;


	// ********** \bh **********

	public void init(FilterConfig filterConfig)
	   throws ServletException {

	   this.filterConfig = filterConfig;
	}

	public void destroy() {

	   this.filterConfig = null;
	}


	/**
	 * NGXgɃZbVMOB
	 * @param request NGXgIuWFNg
	 * @param response X|XIuWFNg
	 * @param chain tB^[`F[IuWFNg
	 */
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
	  throws IOException, ServletException {

		if (filterConfig == null) {
			return;
		}

		if (request instanceof HttpServletRequest) {

			if(logger.isDebugEnabled()) {

				HttpServletRequest req = (HttpServletRequest) request;
				String sep = System.getProperty("line.separator");

				// ZbVMOB
				logger.debug(CommonUtils.getSessionParameters(req).toString());

			}

		}

	  // ̃tB^܂͌XvĂ\[XĂяo܂B
	  chain.doFilter(request, response);
	}

}
