/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.FontChooserPanel;
import org.jfree.ui.FontDisplayField;
import org.jfree.ui.PaintSample;

public class TitlePropertyEditPanel
extends JPanel
implements ActionListener {
    private JTextField titleField;
    private Font titleFont;
    private JTextField fontfield;
    private PaintSample titlePaint;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.ui.LocalizationBundle");

    public TitlePropertyEditPanel(Title title) {
        this.setLayout(new BorderLayout());
        this.titlePaint = new PaintSample((Paint)Color.black);
        JPanel general = new JPanel(new BorderLayout());
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), localizationResources.getString("General")));
        JPanel interior = new JPanel((LayoutManager)new LCBLayout(3));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JLabel titleLabel = new JLabel(localizationResources.getString("Text"));
        this.titleField = new JTextField();
        interior.add(titleLabel);
        interior.add(this.titleField);
        interior.add(new JPanel());
        interior.add(new JLabel(localizationResources.getString("Font")));
        this.fontfield = new FontDisplayField(this.titleFont);
        JButton b = new JButton(localizationResources.getString("Select..."));
        b.setActionCommand("SelectFont");
        b.addActionListener(this);
        interior.add(this.fontfield);
        interior.add(b);
        interior.add(new JLabel(localizationResources.getString("Color")));
        b = new JButton(localizationResources.getString("Select..."));
        b.setActionCommand("SelectPaint");
        b.addActionListener(this);
        interior.add((Component)this.titlePaint);
        interior.add(b);
        general.add(interior);
        this.add((Component)general, "North");
    }

    public String getTitle() {
        return this.titleField.getText();
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Paint getTitlePaint() {
        return this.titlePaint.getPaint();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("SelectFont")) {
            this.attemptFontSelection();
        } else if (command.equals("SelectPaint")) {
            this.attemptPaintSelection();
        }
    }

    public void attemptFontSelection() {
        FontChooserPanel panel = new FontChooserPanel(this.titleFont);
        int result = JOptionPane.showConfirmDialog(this, panel, localizationResources.getString("Font_Selection"), 2, -1);
        if (result == 0) {
            this.titleFont = panel.getSelectedFont();
            this.fontfield.setText(this.titleFont.getFontName() + " " + this.titleFont.getSize());
        }
    }

    public void attemptPaintSelection() {
        Color c = JColorChooser.showDialog(this, localizationResources.getString("Title_Color"), Color.blue);
        if (c != null) {
            this.titlePaint.setPaint((Paint)c);
        }
    }

    public void setTitleProperties(Title title) {
        if (title instanceof TextTitle) {
            // empty if block
        }
    }
}

