/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.AbstractIntervalXYDataset;
import org.jfree.data.CombinationDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.SeriesDataset;
import org.jfree.data.SubSeriesDataset;
import org.jfree.data.XYDataset;

public class CombinedDataset
extends AbstractIntervalXYDataset
implements XYDataset,
HighLowDataset,
IntervalXYDataset,
CombinationDataset {
    private List datasetInfo = new ArrayList();

    public CombinedDataset() {
    }

    public CombinedDataset(SeriesDataset[] data) {
        this.add(data);
    }

    public void add(SeriesDataset data) {
        this.fastAdd(data);
        DatasetChangeEvent event = new DatasetChangeEvent(this, this);
        this.notifyListeners(event);
    }

    public void add(SeriesDataset[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.fastAdd(data[i]);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, this);
        this.notifyListeners(event);
    }

    public void add(SeriesDataset data, int series) {
        this.add(new SubSeriesDataset(data, series));
    }

    private void fastAdd(SeriesDataset data) {
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            this.datasetInfo.add(new DatasetInfo(data, i));
        }
    }

    public int getSeriesCount() {
        return this.datasetInfo.size();
    }

    public String getSeriesName(int series) {
        DatasetInfo di = this.getDatasetInfo(series);
        return di.data.getSeriesName(di.series);
    }

    public Number getXValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        return ((XYDataset)di.data).getXValue(di.series, item);
    }

    public Number getYValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        return ((XYDataset)di.data).getYValue(di.series, item);
    }

    public int getItemCount(int series) {
        DatasetInfo di = this.getDatasetInfo(series);
        return ((XYDataset)di.data).getItemCount(di.series);
    }

    public Number getHighValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        return ((HighLowDataset)di.data).getHighValue(di.series, item);
    }

    public double getHigh(int series, int item) {
        double result = Double.NaN;
        Number high = this.getHighValue(series, item);
        if (high != null) {
            result = high.doubleValue();
        }
        return result;
    }

    public Number getLowValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        return ((HighLowDataset)di.data).getLowValue(di.series, item);
    }

    public double getLow(int series, int item) {
        double result = Double.NaN;
        Number low = this.getLowValue(series, item);
        if (low != null) {
            result = low.doubleValue();
        }
        return result;
    }

    public Number getOpenValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        return ((HighLowDataset)di.data).getOpenValue(di.series, item);
    }

    public double getOpen(int series, int item) {
        double result = Double.NaN;
        Number open = this.getOpenValue(series, item);
        if (open != null) {
            result = open.doubleValue();
        }
        return result;
    }

    public Number getCloseValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        return ((HighLowDataset)di.data).getCloseValue(di.series, item);
    }

    public double getClose(int series, int item) {
        double result = Double.NaN;
        Number close = this.getCloseValue(series, item);
        if (close != null) {
            result = close.doubleValue();
        }
        return result;
    }

    public Number getVolumeValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        return ((HighLowDataset)di.data).getVolumeValue(di.series, item);
    }

    public double getVolume(int series, int item) {
        double result = Double.NaN;
        Number volume = this.getVolumeValue(series, item);
        if (volume != null) {
            result = volume.doubleValue();
        }
        return result;
    }

    public Number getStartXValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        if (di.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)di.data).getStartXValue(di.series, item);
        }
        return this.getXValue(series, item);
    }

    public Number getEndXValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        if (di.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)di.data).getEndXValue(di.series, item);
        }
        return this.getXValue(series, item);
    }

    public Number getStartYValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        if (di.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)di.data).getStartYValue(di.series, item);
        }
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        DatasetInfo di = this.getDatasetInfo(series);
        if (di.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)di.data).getEndYValue(di.series, item);
        }
        return this.getYValue(series, item);
    }

    public SeriesDataset getParent() {
        SeriesDataset parent = null;
        for (int i = 0; i < this.datasetInfo.size(); ++i) {
            SeriesDataset child = this.getDatasetInfo(i).data;
            if (child instanceof CombinationDataset) {
                SeriesDataset childParent = ((CombinationDataset)((Object)child)).getParent();
                if (parent == null) {
                    parent = childParent;
                    continue;
                }
                if (parent == childParent) continue;
                return null;
            }
            return null;
        }
        return parent;
    }

    public int[] getMap() {
        int[] map = null;
        for (int i = 0; i < this.datasetInfo.size(); ++i) {
            int[] childMap;
            SeriesDataset child = this.getDatasetInfo(i).data;
            if (child instanceof CombinationDataset) {
                childMap = ((CombinationDataset)((Object)child)).getMap();
                if (childMap == null) {
                    return null;
                }
            } else {
                return null;
            }
            map = this.joinMap(map, childMap);
        }
        return map;
    }

    public int getChildPosition(Dataset child) {
        int n = 0;
        for (int i = 0; i < this.datasetInfo.size(); ++i) {
            SeriesDataset childDataset = this.getDatasetInfo(i).data;
            if (childDataset instanceof CombinedDataset) {
                int m = ((CombinedDataset)childDataset).getChildPosition(child);
                if (m >= 0) {
                    return n + m;
                }
                ++n;
                continue;
            }
            if (child == childDataset) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private DatasetInfo getDatasetInfo(int series) {
        return (DatasetInfo)this.datasetInfo.get(series);
    }

    private int[] joinMap(int[] a, int[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        int[] result = new int[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private class DatasetInfo {
        private SeriesDataset data;
        private int series;

        DatasetInfo(SeriesDataset data, int series) {
            this.data = data;
            this.series = series;
        }
    }
}

