package designer;

import javax.xml.parsers.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import java.io.*;

import org.xml.sax.*;

//for selectSingleNode
import org.apache.xpath.*;
import org.w3c.dom.traversal.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.dom.*;

//sort
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class XMLConverter {
	DocumentBuilderFactory dbfactory;
	DocumentBuilder builder;

	public XMLConverter() {
		try {
			// hLgr_[t@Ng𐶐
			dbfactory = DocumentBuilderFactory.newInstance();
			// hLgr_[𐶐
			builder = dbfactory.newDocumentBuilder();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

//********************************************************************************
	public Node selectSingleNode(Document doc,String xpath) {
		try{
			NodeIterator nl = XPathAPI.selectNodeIterator(doc,xpath);
			return nl.nextNode();

		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	public Node selectSingleNode(Node node,String xpath) {
		try{
			Node returnNode = XPathAPI.selectSingleNode(node,xpath);
			return returnNode;

		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
//********************************************************************************
	public NodeList selectNodes(Node node,String xpath) {
		try{
			NodeList nl = XPathAPI.selectNodeList(node,xpath);
			return nl;

		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

//	public NodeList selectNodes(Node node,String xpath,String sortKind) {
//		try{
//
//			List lst = new ArrayList();
//	 		NodeList retNodeList =null;
//System.out.println(xpath);
//	 		NodeList nl = XPathAPI.selectNodeList(node, xpath);
//	 		for(int i=0; i<nl.getLength(); i++){
//	 			lst.add(nl.item(i).getFirstChild().getNodeValue());
//System.out.println(nl.item(i).getFirstChild().getNodeValue());
//	 		}
//
//			Collections.sort(lst, new Comparator() {
//				public int compare(Object o1, Object o2) {
//					return ((Comparable) o2).compareTo(o1);
//				}
//			});
//			int j=0;
//			for (Iterator iter = lst.iterator(); iter.hasNext();) {
////				retNodeList.item(j) = selectSingleNode(node,xpath+"='"+iter.next()+"'");
//
//				System.out.println(xpath+"='"+iter.next()+"'");
//				j++;
//			}
//
//			return retNodeList;
//
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		return null;
//	}

//********************************************************************************
	public String toXMLText(Document doc) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo
			DOMSource source = new DOMSource(doc);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer); 
			transformer.transform(source, result);
			return writer.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String toXMLText(Element ele) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo
			DOMSource source = new DOMSource(ele);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer); 
			transformer.transform(source, result);
			return writer.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String toXMLText(Node node) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo
			DOMSource source = new DOMSource(node);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer); 
			transformer.transform(source, result);
			return writer.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public Document toXMLDocument(String XMLString) {
		//擪̋󔒂菜
		String XMLStr=XMLString.substring(XMLString.indexOf("<"));
		try{
			InputSource input = new InputSource(new StringReader(XMLStr));
			Document doc = builder.parse(input);
			return doc;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public Document readFile(String filepath) {
		try{
			File a = new File(filepath);
			FileInputStream b = new FileInputStream(a);
			BufferedInputStream input = new BufferedInputStream(b);
			Document doc = builder.parse(input);
			return doc;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public boolean saveFile(String filepath,Document doc) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo

			DOMSource source = new DOMSource(doc);
			File file = new File(filepath); 
			FileOutputStream out = new FileOutputStream(file); 
			StreamResult result = new StreamResult(out); 
			transformer.transform(source, result);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	public String transformDocument(String xslFilepath,Document xmlDoc) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer(new StreamSource(xslFilepath));

//ȉ̌`ɂƁAXSLTVersionHeaderĂ܂B
//Transformer transformer = transFactory.newTransformer(xsltDocS);

			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo

			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer); 

			DOMSource xmlDocS = new DOMSource(xmlDoc);
			transformer.transform(xmlDocS, result);

			return writer.toString();

		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
}
