/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFAxisMember.java
 *  F̃o[킷ۃNXłB
 *
 *  쐬: 2004/01/11
 */
package openolap.viewer;

import java.io.Serializable;

/**
 *  ۃNXFAxisMember<br>
 *  F̃o[킷ۃNXłB
 */
public abstract class AxisMember implements Serializable {

	// ********** CX^Xϐ **********

	/** o[id(0start) */
	protected final String id;

	/** o[̃j[N(Key)
	 *    W[̏ꍇAviewerW[o[ɑ΂ĐUA0̒ʔԁB
	*/
	protected final String uniqueName;

	/** o[̃x */
	protected final int level;

	/** ZN^őI΂Ă郁o[ */
	protected boolean isSelected = true;

	// ********** RXgN^ **********

	/**
	 * o[IuWFNg𐶐܂B
	 */
	public AxisMember(String id, String uniqueName, int level) {
		this.id = id;
		this.uniqueName = uniqueName;
		this.level = level;
		this.isSelected = true;
	}

	// ********** \bh **********

	/**
	 * o[̖̂߂B<br>
	 * fBVo[̏ꍇAŐݒ肳ꂽ̃^Cv(long_name or short_name)̖̂߂B
	 * @param axis o[鎲IuWFNg
	 * @return o[
	 */
	public abstract String getSpecifiedDisplayName(Axis axis);

	/**
	 * o[̃CfgtH[}bg̖̂߂B<br>
	 * fBVo[̏ꍇAŐݒ肳ꂽ̃^Cv(long_name or short_name)̃CfgtH[}bg̖̂߂B
	 * @param axis o[鎲IuWFNg
	 * @return CfgtH[}bg̃o[
	 */
	public abstract String getSpecifiedIndentedDisplayName(Axis axis);

	/**
	 * CfgtH[}bg̃V[gl[(short_name)߂B<br>
	 */
	public abstract String getIndentedShortName();

	/**
	 * o[̃CfgtH[}bg̃Ol[(long_name)߂B<br>
	 */
	public abstract String getIndentedLongName();

	// ********** setter **********

	/**
	 * o[I΂Ă邩ǂ킷tOZbgB
	 * @param selectedFLG I΂Ă邩
	 */
	public void setIsSelected(boolean selectedFLG) {
		this.isSelected = selectedFLG;
	}

	// ********** getter **********

	/**
	 * o[ID߂B
	 * @return o[ID
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * o[̃j[N(key)߂B
	 * @return o[̃j[N
	 */
	public String getUniqueName() {
		return this.uniqueName;
	}

	/**
	 * o[ZN^őIĂ邩ǂ̃tO߂B
	 * @return ZN^őIĂ邩
	 */
	public boolean isSelected() {
		return this.isSelected;
	}

	/**
	 * o[̃x߂B
	 * @return o[̃x
	 */
	public int getLevel() {
		return level;
	}

}
