/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFDimensionMember.java
 *  FfBṼo[킷NXłB
 *
 *  쐬: 2004/01/10
 */
package openolap.viewer;

import java.io.Serializable;

/**
 *  NXFDimensionMember<br>
 *  FfBṼo[킷NXłB
 */
public class DimensionMember extends AxisMember implements Serializable {

	// ********** CX^Xϐ **********	

	/** R[h */
	final private String code;

	/** V[gl[ */
	final private String short_name;

	/** Ol[ */
	final private String long_name;

	/** xɂCfgς݂̃V[gl[ */
	final private String indentedShortName;

	/** xɂCfgς݂̃Ol[ */
	final private String indentedLongName;

	/** o[t */
	final private boolean isLeaf;

	/** hĂ邩 */
	private boolean isDrilled;

	// ********** RXgN^ **********

	/**
	 * fBVo[IuWFNg𐶐܂B
	 */
	public DimensionMember(String id, String uniqueName, String code, String short_name, String long_name, String indentedShortName, String indentedLongName, int level, boolean isLeaf) {

		super(id, uniqueName, level);
		this.code = code;
		this.short_name = short_name;
		this.long_name = long_name;
		this.indentedShortName = indentedShortName;
		this.indentedLongName = indentedLongName;
		this.isLeaf = isLeaf;

		if(level == 1){
			this.isDrilled = true;
		} else {
			this.isDrilled = false;
		}
		this.isSelected = true;

	}

	// ********** \bh **********

	/**
	 * ̖̂߂B<br>
	 * fBVo[̏ꍇAŐݒ肳ꂽ̃^Cv(long_name or short_name)̖̂߂B
	 * @param axis fBVo[鎲IuWFNg
	 * @return o[
	 */
	public String getSpecifiedDisplayName(Axis axis) {
		if(axis instanceof Dimension){
			if(((Dimension)axis).getDispMemberNameType().equals(Dimension.DISP_SHORT_NAME)){
				return short_name;
			} else if(((Dimension)axis).getDispMemberNameType().equals(Dimension.DISP_LONG_NAME)){
				return long_name;
			} else {
				throw new IllegalStateException();
			}
		} else {	// fBṼo[\郁\bhłAW[ł邱Ƃ͂
			throw new IllegalArgumentException();
		}
	}

	/**
	 * ̃CfgtH[}bg̖̂߂B<br>
	 * fBVo[̏ꍇAŐݒ肳ꂽ̃^Cv(long_name or short_name)̃CfgtH[}bg̖̂߂B
	 * @param axis o[鎲IuWFNg
	 * @return CfgtH[}bg̃o[
	 */
	public String getSpecifiedIndentedDisplayName(Axis axis){
		if(axis instanceof Dimension){
			if(((Dimension)axis).getDispMemberNameType().equals(Dimension.DISP_SHORT_NAME)){
				return indentedShortName;
			} else if(((Dimension)axis).getDispMemberNameType().equals(Dimension.DISP_LONG_NAME)){
				return indentedLongName;
			} else {
				throw new IllegalStateException();
			}		
		} else {	// fBṼo[\郁\bhłAW[ł邱Ƃ͂
			throw new IllegalArgumentException();
		}
	}

	/**
	 * ̖̂߂B<br>
	 * w肳ꂽ̃^Cv(long_name or short_name)̖̂߂B
	 * @param dispNameType ̃^Cv(long_name or short_name)
	 * @return o[
	 */
	public String getNameByDispNameType(String dispNameType){
		if (dispNameType == null) { throw new IllegalArgumentException();}
		if ((!Dimension.DISP_SHORT_NAME.equals(dispNameType)) && (!Dimension.DISP_LONG_NAME.equals(dispNameType)) ) { throw new IllegalArgumentException(); }

		String name = null;
		if (Dimension.DISP_SHORT_NAME.equals(dispNameType)) {
			name = this.getShort_name();
		} else if (Dimension.DISP_LONG_NAME.equals(dispNameType)) {
			name = this.getLong_name();
		}
		
		return name;
	}

	/**
	 * ̖̂߂B<br>
	 * w肳ꂽ̃^Cv(long_name or short_name)̃CfgtH[}bg̖̂߂B
	 * @param dispNameType ̃^Cv(long_name or short_name)
	 * @return CfgtH[}bg̃o[
	 */
	public String getIndentedNameByDispNameType(String dispNameType){
		if (dispNameType == null) { throw new IllegalArgumentException();}
		if ((!Dimension.DISP_SHORT_NAME.equals(dispNameType)) && (!Dimension.DISP_LONG_NAME.equals(dispNameType)) ) { throw new IllegalArgumentException(); }

		String indentedName = null;
		if (Dimension.DISP_SHORT_NAME.equals(dispNameType)) {
			indentedName = this.getIndentedShortName();
		} else if (Dimension.DISP_LONG_NAME.equals(dispNameType)) {
			indentedName = this.getIndentedLongName();
		}
		
		return indentedName;
	}

	// ********** setter **********

	/**
	 * o[hĂ邩ǂ킷tOZbgB
	 * @param isDrilled hĂ邩
	 */
	public void setDrilled(boolean isDrilled) {
		this.isDrilled = isDrilled;
	}

	/**
	 * o[IĂ邩ǂ킷tOZbgB
	 * @param isSelected IĂ邩
	 */
	public void setSelected(boolean isSelected) {
		this.isSelected = isSelected;
	}

	// ********** getter **********

	/**
	 * o[̃R[h߂B
	 * @return R[h
	 */
	public String getCode() {
		return code;
	}

	/**
	 * o[̃V[gl[߂B
	 * @return V[gl[
	 */
	public String getShort_name() {
		return short_name;
	}

	/**
	 * o[̃Ol[߂B
	 * @return Ol[
	 */
	public String getLong_name() {
		return long_name;
	}

	/**
	 * o[̃xɂCfgꂽV[gl[߂B
	 * @return Cfgς݃V[gl[
	 */
	public String getIndentedShortName() {
		return indentedShortName;
	}

	/**
	 * o[̃xɂCfgꂽOl[߂B
	 * @return Cfgς݃V[gl[
	 */
	public String getIndentedLongName() {
		return indentedLongName;
	}

	/**
	 * o[[tłqo[ȂꍇtrueAłȂꍇfalse߂B
	 * @return [t
	 */
	public boolean isLeaf() {
		return isLeaf;
	}

	/**
	 * o[hĂꍇtrueAłȂꍇfalse߂B
	 * @return hĂ邩
	 */
	public boolean isDrilled() {
		return isDrilled;
	}


}
