package openolap.viewer;

import javax.xml.parsers.*;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.*;

import org.xml.sax.*;

//for selectSingleNode
import org.apache.xpath.*;
import org.w3c.dom.traversal.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.dom.*;

public class XMLConverter {
	DocumentBuilderFactory dbfactory;
	DocumentBuilder builder;

	public XMLConverter() throws ParserConfigurationException {
		// hLgr_[t@Ng𐶐
		dbfactory = DocumentBuilderFactory.newInstance();
		// hLgr_[𐶐
		builder = dbfactory.newDocumentBuilder();
	}

	public Node selectSingleNode(Document doc,String xpath) throws TransformerException {
		NodeIterator nl = XPathAPI.selectNodeIterator(doc,xpath);
		return nl.nextNode();
	}
	public Node selectSingleNode(Node node,String xpath) throws TransformerException {
		Node returnNode = XPathAPI.selectSingleNode(node,xpath);
		return returnNode;
	}
	public NodeList selectNodes(Node node,String xpath) throws TransformerException {
		NodeList nl = XPathAPI.selectNodeList(node,xpath);
		return nl;

	}

	public String toXMLText(Document doc) throws TransformerException {
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo
		DOMSource source = new DOMSource(doc);
		StringWriter writer = new StringWriter();
		StreamResult result = new StreamResult(writer); 
		transformer.transform(source, result);
		return writer.toString();
	}

	public String toXMLText(Element ele) throws TransformerException {
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo
		DOMSource source = new DOMSource(ele);
		StringWriter writer = new StringWriter();
		StreamResult result = new StreamResult(writer); 
		transformer.transform(source, result);
		return writer.toString();
	}

	public String toXMLText(Node node) throws TransformerException {
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo
		DOMSource source = new DOMSource(node);
		StringWriter writer = new StringWriter();
		StreamResult result = new StreamResult(writer); 
		transformer.transform(source, result);
		return writer.toString();
	}

	public Document toXMLDocument(String XMLString) throws SAXException, IOException {
		//擪̋󔒂菜
		String XMLStr=XMLString.substring(XMLString.indexOf("<"));

		InputSource input = new InputSource(new StringReader(XMLString));
		Document doc = builder.parse(input);
		return doc;
	}

	public Document readFile(String filepath) throws SAXException, IOException {
		File a = new File(filepath);
		FileInputStream b = new FileInputStream(a);
		BufferedInputStream input = new BufferedInputStream(b);
		Document doc = builder.parse(input);
		return doc;
	}

	public boolean saveFile(String filepath,Document doc) throws FileNotFoundException, TransformerException {
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo

		DOMSource source = new DOMSource(doc);
		File file = new File(filepath); 
		FileOutputStream out = new FileOutputStream(file); 
		StreamResult result = new StreamResult(out); 
		transformer.transform(source, result);

		return true;
	}

	public String transformDocument(String xslFilepath,Document xmlDoc) throws TransformerException {
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer(new StreamSource(xslFilepath));

//ȉ̌`ɂƁAXSLTVersionHeaderĂ܂B
//Transformer transformer = transFactory.newTransformer(xsltDocS);

		transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo

		StringWriter writer = new StringWriter();
		StreamResult result = new StreamResult(writer); 

		DOMSource xmlDocS = new DOMSource(xmlDoc);
		transformer.transform(xmlDocS, result);

		return writer.toString();

	}
}
