/* OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFGetChartInfoCommand.java
 *  FJFreeChartpXMLhLg𐶐NXłB
 *  쐬: 2004/08/05
 */
package openolap.viewer.controller;

import java.io.IOException;

import javax.servlet.ServletException;

import org.w3c.dom.Document;

import openolap.viewer.Report;
import openolap.viewer.chart.ChartCreator;
import openolap.viewer.chart.ChartXMLCreator;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.manager.CellDataManager;

/**
 *  NXFGetChartInfoCommand<br>
 *  FJFreeChartpXMLhLg𐶐NXłB
 */
public class GetChartInfoCommand implements Command {

	/*
	 * ZbVReportIuWFNgA`[gʃ^CvEftHg`[g^CvXVA
	 * JFreeChartpXMLhLg𐶐B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException, Exception {

		// SessionReportIuWFNgXV
		Report report = (Report)helper.getRequest().getSession().getAttribute("report");

		// `[gʃ^CvXV
		String dispScreenType = (String)helper.getRequest().getParameter("displayScreenType");
		report.setDisplayScreenType(dispScreenType);

		// ftHg`[g^CvXV
		String chartID = (String)helper.getRequest().getParameter("chartID");
		String chartName = (new ChartXMLCreator()).chartIdToName(ChartXMLCreator.getChartXMLFilePath(helper), chartID);
		report.setCurrentChart(chartName);

		// ʃ^CvASʁi\jł΁Aȍ~̃`[g͍sȂȂ
		// iA܂ł̏ŁAZbV͍XVłBj
		if ("0".equals(dispScreenType)) {
			return "/spread/blank.html";
		}
		

		// fBVoAZf[^擾SessionɈꎞۑ
		// iZf[^擾|[g̒l擾Ƌʉ邽߁j
		CellDataManager.saveRequestParamsToSession(helper);

		// ChartpXMLhLg𐶐A擾
		Document chartXMLDoc = (new ChartXMLCreator()).createXML(helper, commonSettings);

		// ChartCreatorgpAXMLhLg`[gݒ
		ChartCreator chartCreator = new ChartCreator();
		chartCreator.createChart(chartXMLDoc);

		// ChartCreatorIuWFNgArequest IuWFNgɕۑ
		helper.getRequest().setAttribute("chartCreator", chartCreator);

		// SessionAf[^擾p̃^폜
//		CellDataManager.clearRequestParamForGetDataInfo(helper); 

		return "/spread/chartInfo.jsp";
	}

}
