//package org.jfree.chart.urls;

package openolap.viewer.chart;
import java.io.Serializable;

import org.jfree.data.PieDataset;

import org.jfree.chart.urls.*;

import org.jfree.data.*;

public class CustomPieURLGenerator3 implements PieURLGenerator, Serializable {

    /** The prefix. */
    private String prefix = "index.html";

    /** The category parameter name. */
    private String categoryParameterName = "category";
    
    /** The pie index parameter name. */
    private String indexParameterName = "pieIndex";

		public DefaultPieDataset pieDataset;
		public CategoryDataset multiPieDataset;

	// ********** RXgN^ **********

	/**
	 *  ~OtpRXgN^
	 *  @param pieDataset ~Otpf[^Zbg
	 */
    public CustomPieURLGenerator3(DefaultPieDataset pieDataset) {

        super();

				this.pieDataset = pieDataset;
				this.multiPieDataset = null;
    }

	/**
	 *  ~OtpRXgN^
	 *  @param multiPieDataset ~Otpf[^Zbg
	 */
    public CustomPieURLGenerator3(DefaultCategoryDataset multiPieDataset) {

        super();

				this.multiPieDataset = multiPieDataset;
				this.pieDataset = null;

    }

	// ********** \bh **********

    public String generateURL(PieDataset data, Comparable key, int pieIndex) {

		String url = "";

		//}`pCOtpIMAGEMAP
		if(multiPieDataset != null) {

			url =  (String)this.multiPieDataset.getRowKey(pieIndex) + "," +  (String)this.multiPieDataset.getColumnKey(data.getIndex(key));

		} else {

			//pCOtpIMAGEMAP
   			url =  (String)this.pieDataset.getKey(data.getIndex(key));//R[h

		}

		return url;

    }


    /**
     * equals\bh̎
     *
     * @param o IuWFNg
     * @return A boolean ǂ
     */
    public boolean equals(Object o) {

        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }

        if ((o instanceof CustomPieURLGenerator3) == false) {
            return false;
        }

        CustomPieURLGenerator3 generator = (CustomPieURLGenerator3) o;
        return (this.categoryParameterName.equals(generator.categoryParameterName))
            && (this.prefix.equals(generator.prefix));

    }
}
