/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresDAOFactory.java
 *  FiǗNXQPostgrespIuWFNg𐶐NXłB
 *
 *  쐬: 2004/01/06
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import openolap.viewer.Axis;
import openolap.viewer.Dimension;
import openolap.viewer.Measure;
import openolap.viewer.common.Messages;

/**
 *  NXFPostgresDAOFactory
 *  FiǗNXQPostgrespIuWFNg𐶐NXłB
 */
public class PostgresDAOFactory extends DAOFactory {

	// ********** \bh **********

	/**
	 * Connection PoolConnection擾AConnection܂B
	 * @return Connection IuWFNg
	 */
	public Connection getConnection(){
		Connection conn = null;
		try {
			InitialContext initCtx = new InitialContext();
			DataSource ds = (DataSource)initCtx.lookup("java:comp/env/jdbc/WroxTC41"); //$NON-NLS-1$
			conn = ds.getConnection();
			conn = initialyzeConnection(conn);
		} catch (SQLException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return conn;
	}

	/**
	 * ^ꂽConnectionIuWFNgĖ߂܂B
	 *   FvpeB[t@CɎw肳ꂽƂsearch pathݒ肷B
	 * @param conn Connection IuWFNg
	 * @return Connection IuWFNg
	 * @exception SQLException ɗO
	 */
	private Connection initialyzeConnection(Connection conn) throws SQLException {
		Statement stmt = null;
		String SQL = "";
		SQL =   "";
		SQL +=	"set search_path to " + Messages.getString("PostgresDAOFactory.meta") + ",public"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

		try {
			stmt = conn.createStatement();
			int retNum = stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
				}
			} catch (SQLException e) {
				throw e;
			}
		}
		return conn;
	}


	// DAO擾p\bh

	/**
	 * fBVIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return DimensionDAO IuWFNg
	 */
	public DimensionDAO getDimensionDAO(Connection conn) {
		return new PostgresDimensionDAO(conn);
	}

	/**
	 * W[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return MeasureDAO IuWFNg
	 */
	public MeasureDAO getMeasureDAO(Connection conn) {
		return new PostgresMeasureDAO(conn);
	}

	/**
	 * W[o[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return MeasureMemberDAO IuWFNg
	 */
	public MeasureMemberDAO getMeasureMemberDAO(Connection conn) {
		return new PostgresMeasureMemberDAO(conn);
	}

	/**
	 * |[gIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return ReportDAO IuWFNg
	 */
	public ReportDAO getReportDAO(Connection conn) {
		return new PostgresReportDAO(conn);
	}

	/**
	 * L[uIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return CubeDAO IuWFNg
	 */
	public CubeDAO getCubeDAO(Connection conn) {
		return new PostgresCubeDAO(conn);
	}

	/**
	 * xIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return AxisLevelDAO IuWFNg
	 */
	public AxisLevelDAO getAxisLevelDAO(Connection conn) {
		return new PostgresAxisLevelDAO(conn);
	}

	/**
	 * fBVo[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return DimensionMemberDAO IuWFNg
	 */
	public DimensionMemberDAO getDimensionMemberDAO(Connection conn) {
		return new PostgresDimensionMemberDAO(conn);
	}

	/**
	 * Zf[^IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return CellDataDAO IuWFNg
	 */
	public CellDataDAO getCellDataDAO(Connection conn){
		return new PostgresCellDataDAO(conn);
	}

	/**
	 * W[o[^CvIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return MeasureMemberTypeDAO IuWFNg
	 */
	public MeasureMemberTypeDAO getMeasureMemberTypeDAO(Connection conn) {
		return new PostgresMeasureMemberTypeDAO(conn);
	}

	/**
	 * IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return AxisDAO IuWFNg
	 */
	public AxisDAO getAxisDAO(Connection conn) {
		return new PostgresAxisDAO(conn);
	}

	/**
	 * o[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return AxisMemberDAO IuWFNg
	 */
	public AxisMemberDAO getAxisMemberDAO(Connection conn) {
		return new PostgresDimensionMemberDAO(conn);
	}

	/**
	 * o[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return AxisMemberDAO IuWFNg
	 */
	public AxisMemberDAO getAxisMemberDAO(Connection conn, Axis axis) {
		if (axis == null) {
			return new PostgresDimensionMemberDAO(conn);
		} else if(axis instanceof Measure){
			return new PostgresMeasureMemberDAO(conn);
		} else if (axis instanceof Dimension){
			return new PostgresDimensionMemberDAO(conn);
		} else {
			throw new IllegalStateException();
		}
	}

	/**
	 * FIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return ColorDAO IuWFNg
	 */
	public ColorDAO getColorDAO(Connection conn){
		return new PostgresColorDAO(conn);
	}

	/**
	 * [U[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return UserDAO IuWFNg
	 */
	public UserDAO getUserDAO(Connection conn) {
		return new PostgresUserDAO(conn);
	}


}
