/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.swt;

import java.io.File;
import java.util.LinkedHashMap;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.custom.ScrolledComposite;
import org.jense.ktreemap.ITreeMapColorProvider;
import org.jense.ktreemap.KTreeMap;
import org.jense.ktreemap.SplitByNumber;
import org.jense.ktreemap.SplitBySlice;
import org.jense.ktreemap.SplitBySortedWeight;
import org.jense.ktreemap.SplitByWeight;
import org.jense.ktreemap.SplitSquarified;
import org.jense.ktreemap.SplitStrategy;
import org.jense.ktreemap.TreeMapNode;
import org.jense.ktreemap.example.BuilderTM3;
import org.jense.ktreemap.example.HSBTreeMapColorProvider;
import org.jense.ktreemap.example.TM3Bean;
import org.jense.ktreemap.example.TM3TreeMapProvider;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;

public class ClientAdmin {

	private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="10,10"
	private Menu menuBar = null;
	private TabFolder tabFolder = null;
	private Composite compositeRegister = null;
	private Composite compositeValidation = null;
	private Composite compositeTreemap = null;
	private SashForm sashFormTreeMap = null;
	private KTreeMap kTreeMap = null;
	//private static TreeMapNode treemapComponentRoot;  //  @jve:decl-index=0:
	private TreeMapNode root;
	private TM3TreeMapProvider tm3Provider;
	//private static XMLTreeMapProvider xmlProvider;
	//private Composite composite1 = null;
	private Composite composite2 = null;
	private Group groupSplitStrategy = null;
	private Group groupColorProviders = null;
	
	private LinkedHashMap<String, SplitStrategy> strategies = new LinkedHashMap<String, SplitStrategy>();  //  @jve:decl-index=0:
	private LinkedHashMap<String, ITreeMapColorProvider> colorProviders = new LinkedHashMap<String, ITreeMapColorProvider>();  //  @jve:decl-index=0:
	private Combo comboStrategy = null;
	//private File cmbColorProvider;
	private Group groupParams = null;
	private Combo comboColorProviders = null;
	private Combo comboWeight = null;
	private Combo comboValue = null;
	private Composite legend;
	private BuilderTM3 builder;
	private Group groupPlatformInfo = null;
	private Group groupUserInfo = null;
	private Text textVendor = null;
	private Text textType = null;
	private Text textBiosVersion = null;
	private Button buttonSubmitPlatformInfo = null;
	private Group groupServer = null;
	private Combo comboServers = null;
	private Text textAdminName = null;
	private Text textPassword = null;
	private Text textUserName = null;
	private Text textUserPassword = null;
	private Button buttonCreateNewUser = null;
	private Label label = null;
	private Label label1 = null;
	private Label label2 = null;
	private Label label3 = null;
	private Label label4 = null;
	private Label label5 = null;
	private Label label6 = null;
	private Label label7 = null;
	private ProgressBar progressBar = null;
	private Button buttonValidate = null;
	private Group groupBios = null;
	private Group groupRuntime = null;
	private Label label8 = null;
	private Button checkBox = null;
	private Label label9 = null;
	private Label label10 = null;
	private Label label11 = null;
	private Label label12 = null;
	private Label label13 = null;
	private Button checkBox1 = null;
	private Button checkBox2 = null;
	private Button checkBox3 = null;
	private Button checkBox4 = null;
	private Button checkBox5 = null;
	private Label label14 = null;
	private Label label15 = null;
	private Button checkBox6 = null;
	private Button checkBox7 = null;
	private Label label16 = null;
	private Button checkBox8 = null;
	private Label label17 = null;
	private Button checkBox9 = null;
	private Label label18 = null;
	private Label label19 = null;
	private Button checkBox10 = null;
	private Button checkBox11 = null;
	private Label label20 = null;
	private Label label21 = null;
	private Button checkBox12 = null;
	private Button checkBox13 = null;
	/**
	 * This method initializes tabFolder	
	 *
	 */
	private void createTabFolder() {
		tabFolder = new TabFolder(sShell, SWT.NONE);
		createCompositeRegister();
		createCompositeValidation();
		createCompositeTreemap();
		TabItem tabItem = new TabItem(tabFolder, SWT.NONE);
		tabItem.setText("登録");
		tabItem.setControl(compositeRegister);
		TabItem tabItem1 = new TabItem(tabFolder, SWT.NONE);
		tabItem1.setText("検証");
		tabItem1.setControl(compositeValidation);
		TabItem tabItem2 = new TabItem(tabFolder, SWT.NONE);
		tabItem2.setText("マップ表示");
		tabItem2.setControl(compositeTreemap);
	}

	/**
	 * This method initializes compositeRegister	
	 *
	 */
	private void createCompositeRegister() {
		GridLayout gridLayout2 = new GridLayout();
		gridLayout2.numColumns = 2;
		compositeRegister = new Composite(tabFolder, SWT.NONE);
		compositeRegister.setSize(new Point(535, 299));
		createGroupServer();
		compositeRegister.setLayout(gridLayout2);
		createGroupUserInfo();
		createGroupPlatformInfo();
	}

	/**
	 * This method initializes compositeValidation	
	 *
	 */
	private void createCompositeValidation() {
		GridData gridData13 = new GridData();
		gridData13.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout4 = new GridLayout();
		gridLayout4.numColumns = 2;
		compositeValidation = new Composite(tabFolder, SWT.NONE);
		compositeValidation.setLayout(gridLayout4);
		createGroupBios();
		createGroupRuntime();
		Label filler2 = new Label(compositeValidation, SWT.NONE);
		buttonValidate = new Button(compositeValidation, SWT.NONE);
		buttonValidate.setText("Validate");
		buttonValidate.setLayoutData(gridData13);
		Label filler3 = new Label(compositeValidation, SWT.NONE);
		progressBar = new ProgressBar(compositeValidation, SWT.NONE);
	}

	/**
	 * This method initializes compositeTreemap	
	 *
	 */
	private void createCompositeTreemap() {
		compositeTreemap = new Composite(tabFolder, SWT.NONE);
		compositeTreemap.setLayout(new FillLayout());
		createSashFormTreeMap();
	}

	/**
	 * This method initializes sashFormTreeMap	
	 *
	 */
	private void createSashFormTreeMap() {
		sashFormTreeMap = new SashForm(compositeTreemap,SWT.HORIZONTAL);

		createKTreeMap();
		createCompositeSelect();
		
		sashFormTreeMap.setWeights(new int[] { 70, 30 });
	}

	/**
	 * This method initializes kTreeMap	
	 *
	 */
	private void createKTreeMap() {
		//compositeTreeMap = new Composite(sashFormTreeMap, SWT.NONE);
		//compositeTreeMap.setLayout(new FillLayout());
		
		kTreeMap = new KTreeMap(sashFormTreeMap, SWT.NONE, root);
		kTreeMap.setTreeMapProvider(tm3Provider);
		//kTreeMap.setTreeMapProvider(xmlProvider);
		
		createColorProviders();
		//updateColorProvider(cmbColorProvider.getParent());
	}

	/**
	 * This method initializes composite2	
	 *
	 */
	private void createCompositeSelect() {
		composite2 = new Composite(sashFormTreeMap, SWT.NONE);
		composite2.setLayout(new GridLayout());
		createGroupParams();
		createGroupColorProviders();
		createGroupSplitStrategy();
		
	
	}

	/**
	 * This method initializes groupSplitStrategy	
	 *
	 */
	private void createGroupSplitStrategy() {
	    //this.strategies.put("Squarified", new SplitSquarified());
	    //this.strategies.put("Sorted Weight", new SplitBySortedWeight());
	    //this.strategies.put("Weight", new SplitByWeight());
	    //this.strategies.put("Slice", new SplitBySlice());
	    //this.strategies.put("Equal Weight", new SplitByNumber());
	    
	    
	    

	    // Strategy choice :
	    //updateStrategy();
		
		GridData gridData21 = new GridData();
		gridData21.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		groupSplitStrategy = new Group(composite2, SWT.NONE);
		groupSplitStrategy.setLayout(new GridLayout());
		groupSplitStrategy.setText("SplitStrategy");
		groupSplitStrategy.setLayoutData(gridData21);
		
		createComboStrategy();
	}

	/**
	 * This method initializes groupColorProviders	
	 *
	 */
	private void createGroupColorProviders() {
		GridData gridData20 = new GridData();
		gridData20.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		groupColorProviders = new Group(composite2, SWT.NONE);
		groupColorProviders.setLayout(new GridLayout());
		groupColorProviders.setText("ColorProviders");
		createComboColorProviders();
		groupColorProviders.setLayoutData(gridData20);
		groupColorProviders.setToolTipText("");
	}

	/**
	 * This method initializes comboStrategy	
	 *
	 */
	private void createComboStrategy() {
		comboStrategy = new Combo(groupSplitStrategy, SWT.NONE);
		comboStrategy.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				System.out.println("widgetSelected()"); // TODO Auto-generated Event stub widgetSelected()

				 String key = comboStrategy.getText();
				 SplitStrategy strat = strategies.get(key);
				 kTreeMap.setStrategy(strat);
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {
			}
		});
		
		
	    //this.combo = new Combo(group, SWT.NONE);
	    this.comboStrategy.removeAll();
	    for (String key : this.strategies.keySet()) {
	      this.comboStrategy.add(key);
	    }
	    this.comboStrategy.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
	        | GridData.VERTICAL_ALIGN_BEGINNING));

	    this.comboStrategy.select(0);
	    
	}

	/**
	 * This method initializes groupParams	
	 *
	 */
	private void createGroupParams() {
		GridData gridData19 = new GridData();
		gridData19.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		groupParams = new Group(composite2, SWT.NONE);
		groupParams.setText("Select Parms");
		groupParams.setLayout(new GridLayout());
		createComboWeight();
		groupParams.setLayoutData(gridData19);
		createComboValue();
		
		
		setTM3Fields();
		// TODO 
		comboWeight.select(2); //Dependency
		comboValue.select(1); // CVSS
		
	}

	/**
	 * This method initializes comboColorProviders	
	 *
	 */
	private void createComboColorProviders() {
		GridData gridData18 = new GridData();
		gridData18.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		comboColorProviders = new Combo(groupColorProviders, SWT.NONE);
		comboColorProviders.setLayoutData(gridData18);
		comboColorProviders.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				System.out.println("widgetSelected()"); // TODO Auto-generated Event stub widgetSelected()

				updateColorProvider(comboColorProviders);
			
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {
			}
		});
		
		for (String key : this.colorProviders.keySet()) {
		      comboColorProviders.add(key);
		}
		comboColorProviders.select(0);
	}

	/**
	 * This method initializes comboWeight	
	 *
	 */
	private void createComboWeight() {
		GridData gridData16 = new GridData();
		gridData16.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		comboWeight = new Combo(groupParams, SWT.NONE);
		comboWeight.setToolTipText("Select the weight field");
		comboWeight.setLayoutData(gridData16);
		comboWeight.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				System.out.println("widgetSelected()"); // TODO Auto-generated Event stub widgetSelected()
		
				// TODO Revise
		        Combo cmb = (Combo)e.getSource();
		        String field = cmb.getText();
		        BuilderTM3.setFieldWeight(field);
		        builder.setWeights();
		        kTreeMap.calculatePositions();
		        kTreeMap.redraw();
		        
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {
			}
		});
	}






	/**
	 * This method initializes comboValue	
	 *
	 */
	private void createComboValue() {
		GridData gridData17 = new GridData();
		gridData17.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		comboValue = new Combo(groupParams, SWT.NONE);
		comboValue.setText("");
		comboValue.setLayoutData(gridData17);
		comboValue.setToolTipText("Select the value field");
		comboValue.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				System.out.println("widgetSelected()"); // TODO Auto-generated Event stub widgetSelected()
				
				// TODO Revise
				Combo cmb = (Combo)e.getSource();
		        String field = cmb.getText();
		        TM3TreeMapProvider.setValueField(field);
		        createColorProviders();
		        updateColorProvider(comboColorProviders.getParent());
		        kTreeMap.redraw();
				
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {
			}
		});
	}

	/**
	 * This method initializes groupPlatformInfo	
	 *
	 */
	private void createGroupPlatformInfo() {
		GridData gridData10 = new GridData();
		gridData10.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData6 = new GridData();
		gridData6.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData5 = new GridData();
		gridData5.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData4 = new GridData();
		gridData4.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 2;
		groupPlatformInfo = new Group(compositeRegister, SWT.NONE);
		groupPlatformInfo.setText("Platform Information");
		groupPlatformInfo.setLayoutData(gridData10);
		groupPlatformInfo.setLayout(gridLayout1);
		label3 = new Label(groupPlatformInfo, SWT.NONE);
		label3.setText("Vendor");
		textVendor = new Text(groupPlatformInfo, SWT.BORDER);
		textVendor.setText("Lenovo");
		textVendor.setLayoutData(gridData3);
		label4 = new Label(groupPlatformInfo, SWT.NONE);
		label4.setText("Type");
		textType = new Text(groupPlatformInfo, SWT.BORDER);
		textType.setText("Thinkpad T42");
		textType.setLayoutData(gridData4);
		label5 = new Label(groupPlatformInfo, SWT.NONE);
		label5.setText("BIOS Version");
		textBiosVersion = new Text(groupPlatformInfo, SWT.BORDER);
		textBiosVersion.setLayoutData(gridData5);
		Label filler = new Label(groupPlatformInfo, SWT.NONE);
		buttonSubmitPlatformInfo = new Button(groupPlatformInfo, SWT.NONE);
		buttonSubmitPlatformInfo.setText("Submit");
		buttonSubmitPlatformInfo.setLayoutData(gridData6);
	}

	/**
	 * This method initializes groupUserInfo	
	 *
	 */
	private void createGroupUserInfo() {
		GridData gridData12 = new GridData();
		gridData12.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData9 = new GridData();
		gridData9.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData8 = new GridData();
		gridData8.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData7 = new GridData();
		gridData7.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout3 = new GridLayout();
		gridLayout3.numColumns = 2;
		groupUserInfo = new Group(compositeRegister, SWT.NONE);
		groupUserInfo.setText("User Account");
		groupUserInfo.setLayoutData(gridData12);
		groupUserInfo.setLayout(gridLayout3);
		label6 = new Label(groupUserInfo, SWT.NONE);
		label6.setText("User Name");
		textUserName = new Text(groupUserInfo, SWT.BORDER);
		textUserName.setText("guest");
		textUserName.setLayoutData(gridData8);
		label7 = new Label(groupUserInfo, SWT.NONE);
		label7.setText("Password");
		textUserPassword = new Text(groupUserInfo, SWT.BORDER | SWT.PASSWORD);
		textUserPassword.setText("password");
		textUserPassword.setLayoutData(gridData9);
		Label filler1 = new Label(groupUserInfo, SWT.NONE);
		buttonCreateNewUser = new Button(groupUserInfo, SWT.NONE);
		buttonCreateNewUser.setText("Create");
		buttonCreateNewUser.setLayoutData(gridData7);
		

	}

	/**
	 * This method initializes groupServer	
	 *
	 */
	private void createGroupServer() {
		GridData gridData11 = new GridData();
		gridData11.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData = new GridData();
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		groupServer = new Group(compositeRegister, SWT.NONE);
		groupServer.setText("Server");
		groupServer.setLayoutData(gridData11);
		groupServer.setLayout(gridLayout);
		label1 = new Label(groupServer, SWT.NONE);
		label1.setText("Admin Name");
		textAdminName = new Text(groupServer, SWT.BORDER);
		textAdminName.setText("munetoh");
		textAdminName.setLayoutData(gridData);
		label = new Label(groupServer, SWT.NONE);
		label.setText("Password");
		textPassword = new Text(groupServer, SWT.BORDER | SWT.PASSWORD);
		textPassword.setText("password");
		textPassword.setLayoutData(gridData1);
		label2 = new Label(groupServer, SWT.NONE);
		label2.setText("Server");
		createComboServers();
	}

	/**
	 * This method initializes comboServers	
	 *
	 */
	private void createComboServers() {
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		comboServers = new Combo(groupServer, SWT.NONE);
		comboServers.setText("http://localhost:8080/");
		comboServers.setLayoutData(gridData2);
	}

	/**
	 * This method initializes groupBios	
	 *
	 */
	private void createGroupBios() {
		GridData gridData15 = new GridData();
		gridData15.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout5 = new GridLayout();
		gridLayout5.numColumns = 2;
		groupBios = new Group(compositeValidation, SWT.NONE);
		groupBios.setText("BIOS Reference Manifest");
		groupBios.setLayoutData(gridData15);
		groupBios.setLayout(gridLayout5);
		label8 = new Label(groupBios, SWT.NONE);
		label8.setText("PCR 0 (CRTM)");
		checkBox = new Button(groupBios, SWT.CHECK);
		checkBox.setSelection(true);
		label9 = new Label(groupBios, SWT.NONE);
		label9.setText("PCR 1 ()");
		checkBox1 = new Button(groupBios, SWT.CHECK);
		label10 = new Label(groupBios, SWT.NONE);
		label10.setText("PCR 2 ()");
		checkBox2 = new Button(groupBios, SWT.CHECK);
		checkBox2.setSelection(true);
		label11 = new Label(groupBios, SWT.NONE);
		label11.setText("PCR 3 ()");
		checkBox3 = new Button(groupBios, SWT.CHECK);
		label12 = new Label(groupBios, SWT.NONE);
		label12.setText("PCR 4 ()");
		checkBox4 = new Button(groupBios, SWT.CHECK);
		checkBox4.setSelection(true);
		label13 = new Label(groupBios, SWT.NONE);
		label13.setText("PCR 5 ()");
		checkBox5 = new Button(groupBios, SWT.CHECK);
		label14 = new Label(groupBios, SWT.NONE);
		label14.setText("PCR 6 ()");
		checkBox6 = new Button(groupBios, SWT.CHECK);
		label15 = new Label(groupBios, SWT.NONE);
		label15.setText("PCR 7 ()");
		checkBox7 = new Button(groupBios, SWT.CHECK);
	}

	/**
	 * This method initializes groupRuntime	
	 *
	 */
	private void createGroupRuntime() {
		GridData gridData14 = new GridData();
		gridData14.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout6 = new GridLayout();
		gridLayout6.numColumns = 2;
		groupRuntime = new Group(compositeValidation, SWT.NONE);
		groupRuntime.setText("Runtime Reference Manifest");
		groupRuntime.setLayoutData(gridData14);
		groupRuntime.setLayout(gridLayout6);
		label16 = new Label(groupRuntime, SWT.NONE);
		label16.setText("PCR 4 (IPL)");
		checkBox8 = new Button(groupRuntime, SWT.CHECK);
		checkBox8.setSelection(true);
		label17 = new Label(groupRuntime, SWT.NONE);
		label17.setText("PCR 5 (IPL Data)");
		checkBox9 = new Button(groupRuntime, SWT.CHECK);
		label18 = new Label(groupRuntime, SWT.NONE);
		label18.setText("PCR 8 (O/S)");
		checkBox10 = new Button(groupRuntime, SWT.CHECK);
		checkBox10.setSelection(true);
		label19 = new Label(groupRuntime, SWT.NONE);
		label19.setText("PCR 10 (IMA)");
		checkBox11 = new Button(groupRuntime, SWT.CHECK);
		label20 = new Label(groupRuntime, SWT.NONE);
		label20.setText("PCR 17 (VMM)");
		checkBox12 = new Button(groupRuntime, SWT.CHECK);
		checkBox12.setSelection(true);
		label21 = new Label(groupRuntime, SWT.NONE);
		label21.setText("PCR 18 (VMM)");
		checkBox13 = new Button(groupRuntime, SWT.CHECK);
		checkBox13.setSelection(true);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		
		
		
		
		/**/ 
		
		
		/* Before this is run, be sure to set up the launch configuration (Arguments->VM Arguments)
		 * for the correct SWT library path in order to run with the SWT dlls. 
		 * The dlls are located in the SWT plugin jar.  
		 * For example, on Windows the Eclipse SWT 3.1 plugin jar is:
		 *       installation_directory\plugins\org.eclipse.swt.win32_3.1.0.jar
		 */
		Display display = Display.getDefault();
		ClientAdmin thisClass = new ClientAdmin();
		thisClass.createSShell();
		thisClass.sShell.open();
		

		while (!thisClass.sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

	public ClientAdmin(){
		
		/* Treemap Components */
		try {			
			
			/* TM3 (default) */
			//String filename="sampledata/rpm-qi-data.tm3"; // TODO
			//String filename="sampledata/knoppix511tcg.tm3"; // TODO
			String filename="../openpts-testsuite/sandbox/knoppix511tcg.tm3"; // TODO
			
			String value  = "CVSS";
			String weight = "Dependency";
			
			//String cpFilename="sampledata/test.tm3"; // TODO
			//BuilderTM3 
			builder = new BuilderTM3(new File(filename));
		    tm3Provider = new TM3TreeMapProvider();
		    
		    /* Select weight and value */
		    TM3TreeMapProvider.setValueField(value);
		    BuilderTM3.setFieldWeight(weight);
	        builder.setWeights();
		    
			root = builder.getRoot();
			
			// XML OK
			//String cpFilename="sampledata/test.xml"; // TODO
		    //BuilderXML builder = new BuilderXML(new File(cpFilename));
		    //xmlProvider = new XMLTreeMapProvider();	    
		    //root = builder.getRoot();
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		/**/
		strategies.put("Squarified", new SplitSquarified());
	    strategies.put("Sorted Weight", new SplitBySortedWeight());
	    strategies.put("Weight", new SplitByWeight());
	    strategies.put("Slice", new SplitBySlice());
	    strategies.put("Equal Weight", new SplitByNumber());
	    
	    

		
	}
	
	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		sShell = new Shell();
		sShell.setText("管理ツール");
		sShell.setLayout(new FillLayout());
		createTabFolder();
		sShell.setSize(new Point(551, 378));
		menuBar = new Menu(sShell, SWT.BAR);
		MenuItem pushFile = new MenuItem(menuBar, SWT.PUSH);
		pushFile.setText("ファイル");
		MenuItem pushHelp = new MenuItem(menuBar, SWT.PUSH);
		pushHelp.setText("ヘルプ");
		MenuItem radio = new MenuItem(menuBar, SWT.RADIO);
		radio.setText("デモ");
		sShell.setMenuBar(menuBar);
		
		


	}

	private void createColorProviders() {
		// TODO Revise	
	    colorProviders.put("HSB CVSS", new CvssColorProvider(kTreeMap));

	    colorProviders.put("HSB linear", new HSBTreeMapColorProvider(kTreeMap,
		        HSBTreeMapColorProvider.ColorDistributionTypes.Linear, Display
		            .getDefault().getSystemColor(SWT.COLOR_GREEN), Display.getDefault()
		            .getSystemColor(SWT.COLOR_RED)));
	    colorProviders.put("HSB log", new HSBTreeMapColorProvider(kTreeMap,
		        HSBTreeMapColorProvider.ColorDistributionTypes.Log, Display
		            .getDefault().getSystemColor(SWT.COLOR_GREEN), Display.getDefault()
		            .getSystemColor(SWT.COLOR_RED)));
	    colorProviders.put("HSB SquareRoot", new HSBTreeMapColorProvider(
		        kTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.SquareRoot,
		        Display.getDefault().getSystemColor(SWT.COLOR_GREEN), Display
		            .getDefault().getSystemColor(SWT.COLOR_RED)));
	    colorProviders.put("HSB CubicRoot", new HSBTreeMapColorProvider(
		        kTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.CubicRoot,
		        Display.getDefault().getSystemColor(SWT.COLOR_GREEN), Display
		            .getDefault().getSystemColor(SWT.COLOR_RED)));
	    colorProviders.put("HSB exp", new HSBTreeMapColorProvider(kTreeMap,
		        HSBTreeMapColorProvider.ColorDistributionTypes.Exp, Display
		            .getDefault().getSystemColor(SWT.COLOR_GREEN), Display.getDefault()
		            .getSystemColor(SWT.COLOR_RED)));
	    
		/* set default map */
	    String cpDef = "HSB CVSS"; //"HSB linear";
	    ITreeMapColorProvider itmcp = colorProviders.get(cpDef);
	    kTreeMap.setColorProvider(itmcp);
	}
	
	 void updateColorProvider(Composite comp) {
			// TODO Revise
		    String key = this.comboColorProviders.getText();
		    ITreeMapColorProvider cp = this.colorProviders.get(key);
		    this.kTreeMap.setColorProvider(cp);
		    if (legend != null) {
		      legend.dispose();
		    }
		    legend = cp.getLegend(comp, SWT.NONE);
		    legend.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
		        | GridData.VERTICAL_ALIGN_BEGINNING));
		    comp.layout();
	}
	 
	 // TODO Revise
	  private void setTM3Fields() {
		    String[] numberFields = TM3Bean.getNumberFields();
		    String[] cmbValues = new String[numberFields.length + 1];
		    cmbValues[0] = "";
		    for (int i = 1; i < cmbValues.length; i++) {
		      cmbValues[i] = numberFields[i - 1];
		    }
		    this.comboWeight.removeAll();
		    this.comboValue.removeAll();
		    for (int i = 0; i < cmbValues.length; i++) {
		      String item = cmbValues[i];
		      this.comboWeight.add(item);
		      this.comboValue.add(item);
		    }

		  }	 

	 
}
