/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.swt;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.layout.GridData;

public class ClientUser {

	private Shell sShell = null;
	private TabFolder tabFolder = null;
	private Composite composite = null;
	private Menu menuBar = null;
	private Composite composite1 = null;
	private Label label = null;
	private Text textAccount = null;
	private Label label1 = null;
	private Text textPassword = null;
	private Label label2 = null;
	private Combo combo = null;
	private Text textStatus = null;
	private Label label3 = null;
	private Label label4 = null;
	private Text text = null;
	private Label label5 = null;

	/**
	 * This method initializes tabFolder	
	 *
	 */
	private void createTabFolder() {
		tabFolder = new TabFolder(sShell, SWT.NONE);
		createComposite();
		createComposite1();
		TabItem tabItem1 = new TabItem(tabFolder, SWT.NONE);
		tabItem1.setText("サービス開始");
		TabItem tabItem = new TabItem(tabFolder, SWT.NONE);
		tabItem.setText("クライアントステータス");
		tabItem.setControl(composite);
		tabItem1.setControl(composite1);
	}

	/**
	 * This method initializes composite	
	 *
	 */
	private void createComposite() {
		GridData gridData4 = new GridData();
		gridData4.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 2;
		composite = new Composite(tabFolder, SWT.NONE);
		composite.setLayout(gridLayout1);
		Label filler = new Label(composite, SWT.NONE);
		label5 = new Label(composite, SWT.NONE);
		label5.setText("ステータス");
		label3 = new Label(composite, SWT.NONE);
		label3.setText("ハードウェア");
		textStatus = new Text(composite, SWT.BORDER);
		textStatus.setEditable(false);
		textStatus.setLayoutData(gridData3);
		textStatus.setText("不明");
		label4 = new Label(composite, SWT.NONE);
		label4.setText("起動イメージ");
		text = new Text(composite, SWT.BORDER);
		text.setEditable(false);
		text.setLayoutData(gridData4);
		text.setText("不明");
	}

	/**
	 * This method initializes composite1	
	 *
	 */
	private void createComposite1() {
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData = new GridData();
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		composite1 = new Composite(tabFolder, SWT.NONE);
		composite1.setLayout(gridLayout);
		label = new Label(composite1, SWT.NONE);
		label.setText("アカウント");
		textAccount = new Text(composite1, SWT.BORDER);
		textAccount.setLayoutData(gridData);
		label1 = new Label(composite1, SWT.NONE);
		label1.setText("パスワード");
		textPassword = new Text(composite1, SWT.BORDER | SWT.PASSWORD);
		textPassword.setLayoutData(gridData1);
		label2 = new Label(composite1, SWT.NONE);
		label2.setText("サービス選択");
		createCombo();
	}

	/**
	 * This method initializes combo	
	 *
	 */
	private void createCombo() {
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		combo = new Combo(composite1, SWT.NONE);
		combo.setLayoutData(gridData2);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		/* Before this is run, be sure to set up the launch configuration (Arguments->VM Arguments)
		 * for the correct SWT library path in order to run with the SWT dlls. 
		 * The dlls are located in the SWT plugin jar.  
		 * For example, on Windows the Eclipse SWT 3.1 plugin jar is:
		 *       installation_directory\plugins\org.eclipse.swt.win32_3.1.0.jar
		 */
		Display display = Display.getDefault();
		ClientUser thisClass = new ClientUser();
		thisClass.createSShell();
		thisClass.sShell.open();

		while (!thisClass.sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		sShell = new Shell();
		sShell.setText("Shell");
		createTabFolder();
		sShell.setSize(new Point(300, 200));
		sShell.setLayout(new FillLayout());
		menuBar = new Menu(sShell, SWT.BAR);
		MenuItem pushFile = new MenuItem(menuBar, SWT.PUSH);
		pushFile.setText("ファイル");
		MenuItem pushHelp = new MenuItem(menuBar, SWT.PUSH);
		pushHelp.setText("ヘルプ");
		sShell.setMenuBar(menuBar);
	}

}
