/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.swt;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.jense.ktreemap.ITreeMapColorProvider;
import org.jense.ktreemap.KTreeMap;
//import org.jense.ktreemap.example.HSBTreeMapColorProvider.Legend;
import org.jense.ktreemap.ITreeMapProvider;

//import org.jense.ktreemap.ITreeMapColorProvider;


public class CvssColorProvider implements ITreeMapColorProvider {

	private KTreeMap _treeMap;

	public CvssColorProvider(KTreeMap treeMap) {
		_treeMap = treeMap;
	}


	public Composite getLegend(Composite parent, int style) {
		return new Legend(parent, style);
				
	}


	public Color getBackground(Object value) {
		
		ITreeMapProvider provider = _treeMap.getTreeMapProvider();
	    double v = provider.getDoubleValue(value);
	    
		if (v >= 7.0) return new Color(null,255,0,0);
		else if (v >= 4.0) return new Color(null,255,127,0);
		else if (v == 0.0) return new Color(null,0,255,0);
		else if (v < 0.0) return new Color(null,255,0,0); // Unknown
		else return new Color(null,255,255,0);
	}

	public Color getForeground(Object element) {
		double v = 8.0;
		
		return new Color(null,255,255,255);
	}

	private class Legend extends Canvas {
		public Legend(Composite parent, int style) {
			super(parent, style);
		}		
	}
}
