/*
 * 
 * Licensed Materials - Property of IBM
 *
 * OpenPTS - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */

import java.util.Random;

import com.ibm.trl.tcg.pts.PlatformTrustServices;
import com.ibm.trl.tcg.pts.tools.Base64Tool;



/**
 *  JWS Simple Server for v0.1.0
 *  
 *  Validate
 *  Client                      Server
 *  IR -> Compress -> base64 -> Deceompress -> IR
 *                                             Validate
 *  VR <- Decomp   <- base64 <- comp        <- VR      
 *  
 * @author Seiji Munetoh
 *
 */
public class Server {

	private String _username = "anonymouse";
	private String _base64nonce;
	
	/**
     * openpts-tcdemo v0.1.0 
	 * 
	 * hello
	 *  usermane ->
	 *           <- nonce
	 *           
	 * 
	 * @param username
	 * @return nonce
	 */
    public String hello010(
    		String username  // Option 
    		){    	
    	try {    		
    		if ( _username != null) {
    			_username = username;
    		}
    		
    		byte[] buf = new byte[20];
    		
    		Random rand = new Random();
    		for (int i=0;i<20;i++) {
    			int r = rand.nextInt(256); 
    			buf[i] = (byte) r;
    		}
    		
    		
    		_base64nonce = Base64Tool.encode(buf);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
    	return _base64nonce;    	
     }
	
    /**
     * 
     * Validate IR by PTS Server
     * openpts-tcdemo v0.1.0 
     * 
     *  Option            VR.Reason
     *  ServiceName       password
     * 
     * @param base64IR
     * @param base64BiosRM
     * @param base64RuntimeRM
     * @param option
     * @return
     */
    public String validate010(
    		String base64IR, 
    		String base64BiosRM,     // BIOS
    		String base64RuntimeRM,  // OS
    		String option            // Service URL
    		){
    	
    	String base64VR = null;
    	
    	try {
    		//String[]  base64FSMs = new String[1];
    		//base64FSMs[0] = base64FSM;
 			PlatformTrustServices pts = new PlatformTrustServices();
 			String[] base64RM = new String[2];
 			base64RM[0] = base64BiosRM;
 			base64RM[1] = base64RuntimeRM;
 			
 			// TODO Select ID/PW by given name and Service URL 
 			//String message = "Hello " + _username + "! ";
 			// http://124.32.19.56/package_user
 			String message = "guest password ";
 			System.out.println("Message for VALID,  " + message);
 			pts.setValidationMessageForValid(message);
 			pts.setNonce(Base64Tool.decode(_base64nonce));
 			
 			/* Validate */	
			base64VR = pts.validateIRfromMessage(_username,base64IR, base64RM);
					
		} catch (Exception e) {
			e.printStackTrace();
		}
    	return base64VR;    	
     }
}
