/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

import javax.swing.JOptionPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import tcdemo.axis.JwsWrapper;
import tcdemo.servlet.Client;

import com.ibm.trl.tcg.pts.PlatformTrustServices;
import com.ibm.trl.tcg.pts.eventlog.EventSet;
import com.ibm.trl.tcg.pts.eventlog.IML;
import com.ibm.trl.tcg.pts.eventlog.PCRS;
import com.ibm.trl.tcg.pts.eventlog.SMBIOS;
import com.ibm.trl.tcg.pts.integrity.IntegrityReport;
import com.ibm.trl.tcg.pts.integrity.ReferenceManifest;
import com.ibm.trl.tcg.pts.integrity.VerificationResult;
import com.ibm.trl.tcg.pts.tools.Base64Tool;
import com.ibm.trl.tcg.pts.tools.HexTool;
import com.ibm.trl.tcg.pts.tools.PcrComposite;


/**
 * 
 * HTTP Basic Auth
 * 
 * 
 * TODO Google Account Authentication
 *   Ref http://code.google.com/apis/accounts/AuthForWebApps.html
 * 
 * 
 */
public class Config {

	// <Services>
	//   <Service id="" url="" description="">
	//   URL
	//   Description
	//   local account
	//   server account
	//   password
	//
	
	
	private String browser;
	
	// TODO get list from server or local config
	// 0 URL
	// 1 Name
	// 2 Auth
	// 3 user (TBD)
	// 4 password (TBD)
	// 5 app path
	String[][] services = {
			{"http://localhost:8080","Tomcat(local)","none","anonymous","anonymous",""},
			{"http://localhost:3000/packages","PTS by RubyOnRails(local)","BASIC AUTH","testuser","password",""},
			{"http://documents.google.com/?hl=ja","Google Document","na","anonymous","anonymous",""},
			{"http://www.collab.net/","Collabnet","na","anonymous","anonymous",""},
	};
	
	// TODO data are testcases
	private String platformRmFilename = "../openpts/testcases/platform_rm.xml";
	private String runtimeRmFilename = "../openpts/testcases/runtime_rm.xml";
	private String irFilename = "ir.xml";
	private String vrFilename = "vr.xml";
	private String pcrFilename = "";
	private VerificationResult vr;

	// cuurent IML
	private String imlSysBiosFilename   = "/sys/kernel/security/tpm0/binary_bios_measurements"; 
	private String imlSysRuntimeFilename = "/sys/kernel/security/ima/binary_runtime_measurements"; 
	
	// IML Copy 
	private String imlBiosFilename;//   = "/sys/kernel/security/tpm0/binary_bios_measurements"; 
	private String imlRuntimeFilename;// = "/sys/kernel/security/ima/binary_runtime_measurements"; 
	

	private JwsWrapper jw;
	private Client sc; // servlet client

	private String[][] pcrTableRowData = {
		   {"0", "", "CRTM, POST BIOS, and Embedded Option ROMs", ""},
		   {"1", "", "Host Platform Configuration",""},
		   {"2", "", "Option ROM Code",""},
		   {"3", "", "Option ROM Configuration and Data",""},
		   {"4", "", "IPL",""},
		   {"5", "", "IPL Configuration and Data",""},
		   {"6", "", "State Transition",""},
		   {"7", "", "Host Platform Manufacturer Control",""},
		   {"8", "", "(Operating System)",""},
		   {"9", "", "",""},
		   {"10", "", "(IMA, LKM&ELF Components)",""},
		   {"11", "", "",""},
		   {"12", "", "",""},
		   {"13", "", "",""},
		   {"14", "", "",""},
		   {"15", "", "",""},
		   {"16", "", "Debug",""},
		   {"17", "", "",""},
		   {"18", "", "",""},
		   {"19", "", "",""},
		   {"20", "", "",""},
		   {"21", "", "",""},
		   {"22", "", "",""},
		   {"23", "", "Application Support",""},
		 };
	private String [][] eventlogTableRowData = {
			{"0", "", "BIOS CRTM", ""},
	};

	private ReferenceManifest platformRM = null;

	private ReferenceManifest runtimeRM = null;

	private SecurityProperties securityProperties;

	//private String installPath = "/opt/PlatformTrustServices";

	private String userHomeDir = "/tmp";

	private String userConfigDir = null;

	private String securityPropertiesFilename;

	private String quoteFilename;

	private boolean _verbose = true;

	private String uuid = "00000000000000000000000000000078";

	private String osName;

	private String errorMessage; // stack

	private String lookAndFeel;

	private String ptsHostname;

	private String userName;

	private String userPassword;

	private String tm3Filename; 
	//private String[][] eventlogTableRowData;

	private String pcrsFilename;

	private String dmidecodeFilename;

	private String platformManufacturerName;

	private String platformName;

	private String biosVersion;

	private Date biosDate;

	private String reason; // from TTP

	public boolean _debug = false;

	public boolean usessl = false;

	private String keystorePassword;

	private String keystoreFilename;

	//private boolean serv;

	private boolean useServlet = true;

	private int port = 8080;

	private String gkeystoreFilename;

	private String gkeystorePassword;

	private String platformModelPropFilename;

	private String runtimeModelPropFilename;

	private String grubCdromDir;

	private String grubRootfsDir;

	private boolean updateSignKey;
	
	private void usage() {
		System.out.println("Usage: Config [OPTIONS]");
		System.out.println(" OPTIONS");
		System.out.println(" --propdir dirname    to slect properties location");
		System.out.println(" --new                create new properties");
	}


	/**
	 * Setup platform info
	 * - Browser location
	 * - 
	 * 
	 * Usage  --prop propdir --new
	 *   --prop propdir
	 *   --new create new properties and try setup
	 * 
	 * @param args 
	 * args[0] config dir path 
	 * 
	 * @throws Exception 
	 */
	public Config(String[] args) throws Exception {
		/* lodal system prop */
		Properties sysProp = System.getProperties();
		osName = sysProp.getProperty("os.name");		
		
		
		System.out.println("org.apache.commons.logging.LogFactory :  " + 
				System.getProperty("org.apache.commons.logging.LogFactory"));
		System.out.println("gnu.classpath.home.url :  " + 
				System.getProperty("gnu.classpath.home.url"));
		
		Log log = LogFactory.getLog(this.getClass());
		log.debug("Log Config");
		System.out.println("Sysout Config");
		
		/* Args */
		int opType = 0; // 1:create
		
		for (int i=0; i<args.length; ++i) {
            if ("--propdir".equals(args[i])) {
            	userConfigDir = args[++i];
            }
            else if ("--new".equals(args[i])) {
            	opType = 1;
            } 
            else {
            	System.err.println("Bad option " + args[i]);
            	usage();
            	return;
            }
        }

		/* user prop dir */
		if (userConfigDir==null){
			if (opType == 1 ){
				// TODO 
				System.err.println("ERROR: set --propdir ");
				usage();
				return;
			} else {
				/* Set prop dir to HOME/.pts */  
				userHomeDir  = sysProp.getProperty("user.home");
				
				/* Check Platform Type */					
				/* user Configration Dir */
				if (osName.equals("Linux")) {
					userConfigDir = userHomeDir + "/.pts";
				}
				else { /* Win */
					userConfigDir = userHomeDir + "/Application Data/pts";
				}
			}
		}
		
		/* Setup prop */
		
		File dir = new File (userConfigDir);
		if (dir.exists() == false) {
			if (opType == 1 ) {
				if (dir.mkdir() == false) {
					throw new Exception("Can not create dir " + userConfigDir);
				}
			}
			else {
				// TODO
				throw new Exception("Need to create " + userConfigDir + "? set --new flag, and try again");
			}
		} 
		else  {
			System.out.println("User Config Dir : " + userConfigDir);
		}
		
		/* Properties */
		String propFilename = userConfigDir + "/tcdemo.properties";
		File propFile = new File (propFilename);
		if (propFile.exists() == false) {
			// TODO create new prop
		}
		
		Properties prop = new Properties();
		prop.load(new FileInputStream(propFilename));
		
		
		/* Browsers */
		if (osName.equals("Linux")) {
			lookAndFeel="com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
			browser="/usr/bin/firefox";
			System.out.println("Linux - browser : " + browser);
		}
		else if (osName.equals("Windows XP")) {
			lookAndFeel="com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
			browser="C:/Program Files/Mozilla Firefox/firefox.exe";
			System.out.println("Windows XP - browser : " + browser);
		} 
		else {
			lookAndFeel="com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
			browser="/usr/bin/firefox";
			System.err.println("Unknown O/S " + osName);
			System.out.println("?? try - browser : " + browser);
		}

		/* Config files */
		platformRmFilename = userConfigDir + "/" + prop.getProperty("platform.manifest");
		runtimeRmFilename = userConfigDir + "/" + prop.getProperty("runtime.manifest");
		quoteFilename = userConfigDir + "/quote.properties";
		
		irFilename = userConfigDir + "/" + prop.getProperty("integrity.report.filename");
		vrFilename = userConfigDir + "/" + prop.getProperty("varidation.result.filename");
		
		imlBiosFilename = userConfigDir + "/" + prop.getProperty("platform.iml");
		imlRuntimeFilename = userConfigDir + "/" + prop.getProperty("runtime.iml");
		pcrsFilename =userConfigDir + "/" + prop.getProperty("pcrs");
		dmidecodeFilename = userConfigDir + "/" + prop.getProperty("dmidecode");
		
		platformModelPropFilename = userConfigDir + "/" + prop.getProperty("platform.model.properties.filename");
		runtimeModelPropFilename = userConfigDir + "/" + prop.getProperty("runtime.model.properties.filename");
		
		//grubCdromDir = userConfigDir + "/" + prop.getProperty("runtime.grub.cdrom.dir");
		//grubRootfsDir = userConfigDir + "/" + prop.getProperty("runtime.grub.rootfs.dir");
		// TODO if the path start from / 
		grubCdromDir = prop.getProperty("runtime.grub.cdrom.dir");
		grubRootfsDir = prop.getProperty("runtime.grub.rootfs.dir");
		
		
		ptsHostname = prop.getProperty("pts.hostname");
		System.out.println("PTS Server name : " + ptsHostname);
		
		String portStr = prop.getProperty("pts.port");
		if (portStr != null) {
			port = Integer.valueOf(portStr);
		}
		
		uuid = prop.getProperty("uuid");
		
		/* SSL client setup */		
		keystoreFilename = userConfigDir + "/" + prop.getProperty("keystore.filename");
		keystorePassword = prop.getProperty("keystore.password");
		
		gkeystoreFilename = userConfigDir + "/" + prop.getProperty("gkeystore.filename");
		gkeystorePassword = prop.getProperty("gkeystore.password");
		
		if (System.getProperty("java.vm.name").equals("GNU libgcj")) {
			/* GCJ */
			System.out.println("keystore : " + gkeystoreFilename + " - GCJ");
			System.setProperty("javax.net.ssl.trustStore" , gkeystoreFilename );
			System.setProperty("javax.net.ssl.trustStorePassword", gkeystorePassword);			
		}
		else {
			/* SUN JRE */
			System.out.println("keystore : " + keystoreFilename + " - JRE");
			System.setProperty("javax.net.ssl.trustStore" , keystoreFilename );
			System.setProperty("javax.net.ssl.trustStorePassword",keystorePassword);						
		}
		
		/* Security Properties - TBD */

		String securityPropertiesFilename0 = prop.getProperty("security.properties.filename");
		if (securityPropertiesFilename0 == null) {
			throw new Exception("Missing property : security.properties.filename");
		}
		securityPropertiesFilename = userConfigDir + "/" + securityPropertiesFilename0;
		securityProperties = new SecurityProperties(securityPropertiesFilename);
		securityProperties.init();
		
		/* User info */
		userName = prop.getProperty("user.name");
		userPassword = prop.getProperty("user.password"); // TODO use TPM Key Auth
		
		System.out.println("username : " + userName);
		
		/* Service List */
		String numStr = prop.getProperty("service.num");
		int num = Integer.valueOf(numStr);
		services = new String[num][6];
		for (int i=0;i<num;i++) {
			services[i][0] = prop.getProperty("service." + i + ".url");
			services[i][1] = prop.getProperty("service." + i + ".name");
			services[i][2] = prop.getProperty("service." + i + ".authtype");
			services[i][3] = prop.getProperty("service." + i + ".account");
			services[i][4] = prop.getProperty("service." + i + ".password");
			services[i][5] = prop.getProperty("service." + i + ".extend");
		}
		
		tm3Filename = userConfigDir + "/" + prop.getProperty("tm3.filename");
		
		/* Server Connection */
		String protocol = prop.getProperty("pts.protocol");
		String ssl = prop.getProperty("pts.ssl");
		
		if (protocol.equals("soap")) {
			useServlet = false;
			jw = new JwsWrapper();			
		}
		else {
			useServlet = true;
			sc = new Client();			
		}
		
		if (ssl.equals("no")) {
			usessl = false;
		}
		else {
			usessl = true;
		}
		
	}
	
	
	public void setupManifest() throws Exception {
		/* Local Info */
		//ReferenceManifest 
		platformRM = new ReferenceManifest(platformRmFilename);
		//ReferenceManifest 
		runtimeRM = new ReferenceManifest(runtimeRmFilename);
	}

	/**
	 * 
	 * Send Validation request to PTS server 
	 * and get Result
	 * 
	 * @return
	 */
	public boolean validate(int sid) {
		
		System.out.println("validate for service[" + sid + "]= " + services[sid][1]);
		
		/* Restart TCSD */
		// TODO 
		
		restartTcsd();
		
		/* Measure */
		if (measure(services[sid][5]) == false) {
			errorMessage = "measurement of " + services[sid][5] + " was failed.";
			return false;
		}
		//getiml();
		copyIML(imlSysBiosFilename,userConfigDir);
		copyIML(imlSysRuntimeFilename,userConfigDir);
		
		/* Attestation */
		boolean rc = false;
		try {
			/* Get Nonce */
			long start, stop, diff;
			start = System.currentTimeMillis();
			byte[] nonce;
			
			if (useServlet) {
				if (usessl) {
					nonce = sc.sopen(ptsHostname,userName,keystoreFilename,keystorePassword);
				}
				else {
					nonce = sc.open(ptsHostname,port,userName);
				}
			}
			else {
				if (usessl) {
					jw.sopen(ptsHostname,keystoreFilename,keystorePassword );				
				}
				else {
					jw.open(ptsHostname);	
				}
				nonce = jw.hello(userName);						
			}
			
			
			stop = System.currentTimeMillis();
			diff = stop - start;
			System.out.println("Elapsed Time      : " + diff + " [msec]");	
			start = System.currentTimeMillis();
			
			String nonceHexStr = HexTool.getHexString(nonce);
			
			/* Get Quote*/
			
			if (_debug) {
				// use local date
			}
			else {
				tpmQuote(uuid,nonceHexStr,quoteFilename);
				
				copyIML(imlSysBiosFilename,userConfigDir);
				copyIML(imlSysRuntimeFilename,userConfigDir);
				//getiml();
			}
			
			/* Create IR from IML, Quote */
			PlatformTrustServices pts = new PlatformTrustServices();
			
			String[] imlFiles = {
					userConfigDir + "/binary_bios_measurements",
					userConfigDir + "/binary_runtime_measurements"
			};
			String[] rmFiles = {
					platformRmFilename,
					runtimeRmFilename
			};
			
			IntegrityReport localIR = new IntegrityReport();
			localIR.generateIntegrityReportFromIML(
					imlFiles, 
					pcrFilename,
					rmFiles, 
					quoteFilename);
			/* check */
			if (localIR.validateQuoteData() !=0) {
				// TODO
				System.err.println("Error: QuoteData is wrong try Quote again?");
			}
			
			localIR.save(irFilename);
			
			// TEST 
			//IntegrityReport localIR = new IntegrityReport(irFilename);			
			//IntegrityReport localIR = new IntegrityReport();
			//localIR.
			
			stop = System.currentTimeMillis();
			diff = stop - start;
			System.out.println("Elapsed Time      : " + diff + " [msec]");	
			start = System.currentTimeMillis();
			
			/* Validate */
			
			if (useServlet) {
				vr = sc.validate(
						localIR,
						platformRM,
						runtimeRM,
						services[sid][0]); // Service URL
			}
			else {
				vr = jw.validate(
						localIR,
						platformRM,
						runtimeRM,
						services[sid][0]); // Service URL
				jw.close();
			}
			
			//vr = new VerificationResult();
			//vr.loadFile(vrFilename);
			vr.save(vrFilename);
			
			String result = vr.getResult();
			reason = vr.getReason();
			
			if (result.equals("VALID")) {
				// GOOD
				//jLabelResult.setText("You are using Good BIOS and Runtime!!");
				String[] msg = reason.split(" ");
				services[sid][3] = msg[0]; // account  
				services[sid][4] = msg[1]; // password
				reason = "Good! Start Service ";
				rc = true;
			} 
			else  {
				// BAD 
				//jLabelResult.setText("There are problems. See below");						
				System.out.println("VR result : " + result);
				System.out.println("VR reason : " + reason);
				rc = false;
			}
	
			stop = System.currentTimeMillis();
			diff = stop - start;
			System.out.println("Elapsed Time      : " + diff + " [msec]");	
			start = System.currentTimeMillis();
			
			
			/* Update Client Info -- PCR & Eventlog */
			EventSet[] eventSet = localIR.getEventSet();
			Vector vec = new Vector();
			
			PcrComposite pc = localIR.getPcrComposite();
			for (int i=0;i<pc.getSelectedPcrNums();i++) {
				int pcrindex = pc.getPcrIndex(i);
				byte [] pcrvalue = pc.getPcrValue(i);
				pcrTableRowData[pcrindex][1]=HexTool.getHexString(pcrvalue);
				pcrTableRowData[pcrindex][3]="Valid!";
				/* Eventlog */
				com.ibm.trl.tcg.pts.engine.Event[] event = eventSet[pcrindex].getEventList();
				for (int j=0;j<event.length;j++) {
					vec.add(event[j]);					
				}				
			}
			
			/* Update Client Info -- IML */
			int eventNum = vec.size();
			eventlogTableRowData = null;
			eventlogTableRowData = new String[eventNum][4];
			for (int i=0;i<eventNum;i++) {
				com.ibm.trl.tcg.pts.engine.Event e = (com.ibm.trl.tcg.pts.engine.Event) vec.get(i);
				eventlogTableRowData[i][0]=new Integer((int)e.getPcrIndex()).toString();
				eventlogTableRowData[i][1]=HexTool.getHexString(e.getDigest());
				
				byte [] buf = Base64Tool.decode(e.getEventDataStr());
				if (buf != null) {
					eventlogTableRowData[i][2]=new String(buf);
				}	
				else {
					eventlogTableRowData[i][2]="n/a";	
				}
				
				eventlogTableRowData[i][3]="Valid!!"; // TODO				
			}
			
			
			
			for (int i=0;i<eventNum;i++) {				
				
			}
			
			
		} catch (Exception e) {
			e.printStackTrace();
			errorMessage = e.getMessage();
		}
		return rc;
	}


	private boolean measure(String filename) {
		System.out.println("-- measure --");
		System.out.println(" filename : " + filename);
		String cmdname = "/usr/bin/tpm_extend";
		
		/* check the filename */
		if (filename == null) {
			// TODO FOR DEBUG
			errorMessage = "no file to be measured";
			return true;
		}
		
		File exfile = new File(filename);
		if (exfile.isFile() == false ) {
			errorMessage = filename + " is missing. wrong service configuration?";
			return false;
		}
		
		/* check the command */
		File cmdfile = new File(cmdname);
		if (cmdfile.isFile() == false ) {
			errorMessage = cmdname + " is missing. please install tools package";
			return false;
		}
		
		try {
			String cmd;
			Runtime rt = Runtime.getRuntime();
			cmd = cmdname + " -f " + filename;
			System.out.println(" CMD  : " + cmd);

			Process	pr = rt.exec(cmd);
			pr.waitFor();
			
		} catch (IOException e) {
			e.printStackTrace();
			errorMessage = "IOException Error";
			return false;
		} catch (InterruptedException e) {
			e.printStackTrace();
			errorMessage = "InterruptedException Error";
			return false;
		}
		return true;
	}


	private boolean copyIML(String imlFilename, String configDir) {
		boolean rc = false;
		File cmdFile = new File (imlFilename);
		if (cmdFile.exists()) {
			try {
				Runtime rt = Runtime.getRuntime();
				String cmd = "cp " + imlFilename + " " + configDir;
				if (_verbose) System.out.println("Copy: " + cmd);				
				Process p = rt.exec(cmd);
				p.waitFor();				
				if (_verbose) System.out.println("Copy...done");				
				rc = true;
			} catch (IOException e) {
				e.printStackTrace();
			} catch (InterruptedException e) { // waitFOr
				e.printStackTrace();
			}
		} 
		else {
			System.out.println("Error: copy was fail command " + imlFilename + " not found");
		}
		return rc;
	}


	/**
	 * 
	 * Issue TPM Quote
	 * 
	 * @param quoteFilename
	 */
	private boolean tpmQuote(
			String uuid,
			String nonce,
			String quoteFilename) {
		boolean rc = false;
		String cmdFIlename = "/usr/bin/tpm_quote";
		File cmdFile = new File (cmdFIlename);
		if (cmdFile.exists()) {
			try {
				Runtime rt = Runtime.getRuntime();
				String cmd = cmdFIlename + 
				" --popup " +
				" -u " + uuid +
				" -n " + nonce +
				//" -p 0 -p 2 -p 4 -p 8 -p 10 -p 17 -p 18 " +
				" -p 0 -p 2 -p 4 -p 5 -p 8 -p 10 " +
				" -o " + quoteFilename;
				
				if (_verbose) System.out.println("TPM_Quote : " + cmd);				
				Process p = rt.exec(cmd);
				p.waitFor();				
				if (_verbose) System.out.println("TPM_Quote...done");				
				rc = true;
			} catch (IOException e) {
				e.printStackTrace();
			} catch (InterruptedException e) { // waitFOr
				e.printStackTrace();
			}
		} 
		else {
			System.out.println("Error: TPM_Quote was fail command " + cmdFIlename + " not found");
		}
		return rc;
	}


	public void startService(int id) {
		System.out.println("Start Service[" + id + "] ");
		String urlString = services[id][0];
		System.out.println(" URL  : " + urlString);
		System.out.println(" AUTH : " + services[id][2]);
		try {
			String cmd;
			Runtime rt = Runtime.getRuntime();
			URL url = new URL(services[id][0]);
			
			
			if (services[id][2].equals("BASIC AUTH")) {
				cmd = browser + " -url " + 
				url.getProtocol() + 
				"://" + services[id][3] + ":" + services[id][4] + "@" + 
				url.getHost() + ":" +
				url.getPort() + 
				url.getPath();
					
				
			} else {
				cmd = browser + " -url " + url.toString();
			}
			//String cmd = browser + " -url http://localhost:8080";
			//cmd = "C:/Program Files/Mozilla Firefox/firefox.exe -url http://munetoh:seiji@localhost:8080";
			System.out.println(" CMD  : " + cmd);

			rt.exec(cmd);
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}
	public String getServerName() {
		return ptsHostname;
	}


	public String[] getServiceList() {
		String[] list = new String[services.length];
		for (int i=0;i<services.length;i++) {
			list[i] = services[i][1];	
		}		
		return list;
	}
	public String[] getServiceListByURL() {
		String[] list = new String[services.length];
		for (int i=0;i<services.length;i++) {
			list[i] = services[i][0];	
		}		
		return list;
	}
	public String getServiceDescription(int i) {
		//String out = "URL : " + services[i][0] + "\n\r";
		String out = "" + services[i][1] + "";
		//out += "TBD";
		
		return out;
	}


	public String getServiceAuth(int i) {
		String out = "" + services[i][2] + "";
		return out;
	}


	public String getUsername(int select) {
		String name = "N/A";
		if (select > services.length) {
			// TODO 
		} else {
			name = services[select][3];
		}
		return name;
	}
	
	public String getPassword() {
		// TODO Auto-generated method stub
		return "TBD";
	}
	//public String[][] GetEventlogData() {
	//	// TODO Auto-generated method stub
	//	return null;
	//}
	public String[][] getPcrData() {
		return pcrTableRowData;
	}
	public String[][] getEventlogData() {
		return eventlogTableRowData;
	}
	public String getPcVendorName() {
		return platformManufacturerName;
	}
	public String getMacineTypeName() {
		return platformName;
	}
	public String getBiosVersionName() {
		return biosVersion;
	}
	public Date getBiosData() {
		return biosDate;
	}
	public String[][] getSecurityPropertyList() {
		return securityProperties.getSecurityPropertyList();
	}
	public String getErrorMessage() {
		return errorMessage;
	}
	public String getLookAndFeel() {
		return lookAndFeel;
	}
	public String getUserName() {
		return userName;
	}


	public String getTM3Filename() {
		return tm3Filename;
	}


	public void issueGetIml() {
		/* Issue getiml script */
		getiml();
		
		
		
		/* re-load IML/PCR/dmidata */
		
		try {
			/* dmidecode */
			SMBIOS smbios = new SMBIOS();
			smbios.loadDmidecodeOutput(dmidecodeFilename);
			platformManufacturerName =  smbios.getManufacturerName();
			platformName = smbios.getProductName();
			biosVersion = smbios.getBIOSVersion();
			biosDate = smbios.getBIOSDate();
			
			/* PCRS */
			PCRS pcrs = new PCRS();
			pcrs.loadfile(pcrsFilename);
			int pcrNum = pcrs.size();
			byte[][] pcrData = pcrs.getByteArray();
			
			for (int i=0;i<pcrNum;i++) {
				pcrTableRowData[i][1] =  HexTool.getHexString(pcrData[i]);			
			}
			for (int i=pcrNum;i<24;i++) {
				pcrTableRowData[i][1] =  "";							
			}

			/* BIOS IML */
			IML iml = new IML();
			iml.loadBIOSIML(imlBiosFilename);
			
			com.ibm.trl.tcg.pts.engine.Event[] e = iml.getEventList();
			eventlogTableRowData = new String[e.length][4];
						
			for (int i=0;i<e.length;i++) {
				eventlogTableRowData[i][0] = "" + e[i].getPcrIndex(); 
				eventlogTableRowData[i][1] = HexTool.getHexString(e[i].getDigest()); 
				eventlogTableRowData[i][2] = e[i].getEventDataString(); 
				eventlogTableRowData[i][3] = ""; 
			}
			
			
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		
		
	}


	private boolean getiml() {
		System.out.println("-- getiml --");
		String cmdname = "/opt/OpenPlatformTrustServices/bin/getiml";
		
		/* check the command */
		File cmdfile = new File(cmdname);
		if (cmdfile.isFile() == false ) {
			errorMessage = cmdname + " is missing....";
			return false;
		}
		
		try {
			String cmd;
			Runtime rt = Runtime.getRuntime();
			cmd = cmdname + " /opt/OpenPlatformTrustServices/tcdemo"; // TODO 
			System.out.println(" CMD  : " + cmd);

			Process	pr = rt.exec(cmd);
			pr.waitFor();
			
		} catch (IOException e) {
			e.printStackTrace();
			errorMessage = "IOException Error";
			return false;
		} catch (InterruptedException e) {
			e.printStackTrace();
			errorMessage = "InterruptedException Error";
			return false;
		}
		return true;		
	}


	public boolean restartTcsd() {
		System.out.println("-- restartTcsd --");
		String cmdname = "/opt/OpenPlatformTrustServices/bin/restarttcsd";
		
		/* check the command */
		File cmdfile = new File(cmdname);
		if (cmdfile.isFile() == false ) {
			errorMessage = cmdname + " is missing....";
			return false;
		}
		
		try {
			Runtime rt = Runtime.getRuntime();

			Process	pr = rt.exec(cmdname);
			pr.waitFor();
			
		} catch (IOException e) {
			e.printStackTrace();
			errorMessage = "IOException Error";
			return false;
		} catch (InterruptedException e) {
			e.printStackTrace();
			errorMessage = "InterruptedException Error";
			return false;
		}
		return true;		
	}


	public void generatePlatformRm() {
		// TODO Auto-generated method stub
		
	}


	public void generateRuntimeRm() {
		// TODO Auto-generated method stub
		
	}


	public String getReason() {
		return reason;
	}


	public boolean checkPassword(char[] password) {
		boolean rc = true;
		
		// TODO TPM Quote with PW
		//char[] refpw = {'p','a','s','s','w','o','r','d'};
		char[] refpw = userPassword.toCharArray();
		
		if ( password== null) {		
			reason = "Please input your password";
			rc = false;
		}
		else {
			if (refpw.length != password.length) {
				System.out.println("Wrong PW");
				reason = "Wrong password, try again";
				rc=false;
			}
			else {
				for (int i=0;i<refpw.length;i++) {
					if (refpw[i]!=password[i]){
						System.out.println("Wrong PW");
						reason = "wrong password, try again";
						rc = false;
						break;
					}
				}							
			}
		}
		
		return rc;
	}

	/**
	 * 
	 * Check Platform RM
	 * 
	 * @return
	 */
	public boolean isPlatformManifestExist() {
		if (platformRM != null) {
			// TODO Maybe exit
			return true;
		}
		else {
			return false;
		}
	}

	/**
	 * 
	 * Create/Update Platform Manifest
	 * if RM exist ask update or not 
	 * if not exist create new
	 * 
	 * 
	 * @return status string, 
	 */
	public String createPlatformManifest() {
		String out = "TBD";
		//System.out.println("createPlatformManifest");
		
		/* create new RM */
		// IML -> RM
		try {
			SMBIOS smbios = new SMBIOS();
			smbios.loadDmidecodeOutput(dmidecodeFilename);
			
			platformRM = new ReferenceManifest();
			platformRM.generatePlatformReferenceManifestByProp(
					imlBiosFilename,//inputFilename[0],
					smbios,
					platformModelPropFilename);
			
			/* save to file */
			//rm0.indent();
			platformRM.save(platformRmFilename);
			
			/* Status */
			Date date = platformRM.getDate();	
			out = "VersionBuild : " + date.toString();
		} catch (Exception e) {
			e.printStackTrace();
			out = "Sorry, internal error, load RM was failed";	
			platformRM = null;
			return out;
		}		
		
		return out;
	}
	public String getPlatformManifestStatus() {
		String out = "ERROR";
		
		if (platformRM == null) {
			try {
				platformRM = new ReferenceManifest();
				platformRM.loadFile(platformRmFilename);
			} catch (Exception e) {
				e.printStackTrace();
				out = "Sorry, internal error, load RM was failed";	
				platformRM = null;
				return out;
			}			
		}
		
		/* Status */
		Date date = platformRM.getDate();	
		out = "VersionBuild : " + date.toString();
		
		return out;
	}

	public String getPlatformManifestUUID() {		
		String uuid;
		if (platformRM == null) {
			uuid = "TBD";
		}
		else {
			uuid = platformRM.getUUID();
		}
		return uuid;
	}

	/**
	 * View Platfrom RM by browser
	 *
	 */
	public void viewPlatformManifest() {
		try {
			String cmd;
			Runtime rt = Runtime.getRuntime();
			File file = new File(platformRmFilename);
			
			if (osName.equals("Linux")) {
				cmd = browser + " -url " + 
				"file:///" + file.getAbsolutePath();				
			}
			else {
				cmd = browser + " -url " + 
				"\"file:///" + file.getAbsolutePath() + "\"";
			}
			
			//cmd = browser + " -url " + 
			//	"\"file:///" + file.getAbsolutePath() + "\"";
			System.out.println(" CMD  : " + cmd);

			rt.exec(cmd);
		} catch (IOException e) {
			e.printStackTrace();
		}		
	}


	
	/**
	 * Runtime 
	 * @return
	 */
	public boolean isRuntimeManifestExist() {
		if (runtimeRM != null) {
			// TODO Maybe exit
			return true;
		}
		else {
			return false;
		}
	}

	public String createRuntimeManifest() {
		String out = "TBD";

		/* create new RM */
		// IML -> RM
		try {
			SMBIOS smbios = new SMBIOS();
			smbios.loadDmidecodeOutput(dmidecodeFilename);
			
			runtimeRM = new ReferenceManifest();
			
			// TODO support Redhat
			runtimeRM.generateKnoppixReferenceManifestByProp(
					imlBiosFilename,//inputFilename[0],//biosImlFilename,
					imlRuntimeFilename,//inputFilename[1],//runtimeImlFilename, // TBD
					runtimeModelPropFilename,//modelPropFilename,
					grubCdromDir, //grubBinariesDir, 
					grubRootfsDir
					//runtimeBehaviorModelFilenames,
					);
			
			
			/* save to file */
			//rm0.indent();
			runtimeRM.save(runtimeRmFilename);
			
			/* Status */
			Date date = runtimeRM.getDate();	
			out = "VersionBuild : " + date.toString();
		} catch (Exception e) {
			e.printStackTrace();
			out = "Sorry, internal error, load RM was failed";	
			runtimeRM = null;
			return out;
		}		
		
		return out;	
	}


	public String getRuntimeManifestStatus() {
		String out = "ERROR";
		
		if (runtimeRM == null) {
			try {
				runtimeRM = new ReferenceManifest();
				runtimeRM.loadFile(runtimeRmFilename);
			} catch (Exception e) {
				e.printStackTrace();
				out = "Sorry, internal error, load RM was failed";	
				runtimeRM = null;
				return out;
			}			
		}
		
		/* Status */
		Date date = runtimeRM.getDate();	
		out = "VersionBuild : " + date.toString();
		
		return out;
	}

	public String getRuntimeManifestUUID() {
		String uuid;
		if (platformRM == null) {
			uuid = "TBD";
		}
		else {
			uuid = runtimeRM.getUUID();
		}
		return uuid;
	}


	public void viewRuntimeManifest() {
		try {
			String cmd;
			Runtime rt = Runtime.getRuntime();
			File file = new File(runtimeRmFilename);
			if (osName.equals("Linux")) {
				cmd = browser + " -url " + 
				"file:///" + file.getAbsolutePath();				
			}
			else {
				cmd = browser + " -url " + 
				"\"file:///" + file.getAbsolutePath() + "\"";
			}
				
			System.out.println(" CMD  : " + cmd);

			rt.exec(cmd);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}


	/**
	 * 
	 * Get Suppoerted Service List From Server
	 * 
	 * @return
	 */
	public boolean getServiceListFromPTSServer() {				
		return false;
	}


	public boolean invokeTPMManager() {
		System.out.println("invokeTPMManager");
		String cmdname = "/usr/bin/tpmmanager";
		
		/* check the command */
		File cmdfile = new File(cmdname);
		if (cmdfile.isFile() == false ) {
			errorMessage = cmdname + " is missing";
			return false;
		}
		
		try {
			String cmd;
			Runtime rt = Runtime.getRuntime();
			cmd = cmdname;
			
			System.out.println(" CMD  : " + cmd);
			rt.exec(cmd);
			
		} catch (IOException e) {
			e.printStackTrace();
			errorMessage = "IOException";
			return false;
		}
		
		return true;
	}


	public String getSignKeyUUID() {
		return uuid;
	}
	public void setSignKeyUUID(String signKeyUUID) {
		uuid =  signKeyUUID;		
	}
	public void setSignKeyUpdateFlag(boolean flag) {
		updateSignKey = flag;
	}
	public boolean createSignKey() {
		System.out.println("createSignKey");
		System.out.println(" UUID : " + uuid);
		String cmdname = "/usr/bin/tpm_createkey";
		
		/* check the command */
		File cmdfile = new File(cmdname);
		if (cmdfile.isFile() == false ) {
			errorMessage = cmdname + " is missing. please install tools package";
			return false;
		}
		
		/* Restart TCSD */
		// TODO 
		
		restartTcsd();
		
		
		/* OK, issue  /usr/bin/tpm_createkey*/
		
		try {
			String cmd;
			Runtime rt = Runtime.getRuntime();
			cmd = cmdname;
			if (updateSignKey) {
				cmd += " --popup --force ";
			}
			cmd += "--uuid " + uuid;
			
			System.out.println(" CMD  : " + cmd);

			//rt.exec(cmd);
			Process	pr = rt.exec(cmd);
			pr.waitFor();
		} catch (IOException e) {
			e.printStackTrace();
			errorMessage = "IOException Error";
			return false;
		} catch (InterruptedException e) {
			e.printStackTrace();
			errorMessage = "InterruptedException Error";
			return false;
		}
		return true;
	}













}
